/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;

public class MovieHeaderBox
extends AbstractFullBox {
    private long creationTime;
    private long modificationTime;
    private long timescale;
    private long duration;
    private double rate = 1.0;
    private float volume = 1.0f;
    private long[] matrix = new long[]{65536L, 0L, 0L, 0L, 65536L, 0L, 0L, 0L, 0x40000000L};
    private long nextTrackId;
    private int previewTime;
    private int previewDuration;
    private int posterTime;
    private int selectionTime;
    private int selectionDuration;
    private int currentTime;
    public static final String TYPE = "mvhd";

    public MovieHeaderBox() {
        super(TYPE);
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public long getTimescale() {
        return this.timescale;
    }

    public long getDuration() {
        return this.duration;
    }

    public double getRate() {
        return this.rate;
    }

    public float getVolume() {
        return this.volume;
    }

    public long[] getMatrix() {
        return this.matrix;
    }

    public long getNextTrackId() {
        return this.nextTrackId;
    }

    @Override
    protected long getContentSize() {
        long l = 4L;
        l = this.getVersion() == 1 ? (l += 28L) : (l += 16L);
        return l += 80L;
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        if (this.getVersion() == 1) {
            this.creationTime = IsoTypeReader.readUInt64(byteBuffer);
            this.modificationTime = IsoTypeReader.readUInt64(byteBuffer);
            this.timescale = IsoTypeReader.readUInt32(byteBuffer);
            this.duration = IsoTypeReader.readUInt64(byteBuffer);
        } else {
            this.creationTime = IsoTypeReader.readUInt32(byteBuffer);
            this.modificationTime = IsoTypeReader.readUInt32(byteBuffer);
            this.timescale = IsoTypeReader.readUInt32(byteBuffer);
            this.duration = IsoTypeReader.readUInt32(byteBuffer);
        }
        this.rate = IsoTypeReader.readFixedPoint1616(byteBuffer);
        this.volume = IsoTypeReader.readFixedPoint88(byteBuffer);
        IsoTypeReader.readUInt16(byteBuffer);
        IsoTypeReader.readUInt32(byteBuffer);
        IsoTypeReader.readUInt32(byteBuffer);
        this.matrix = new long[9];
        for (int i = 0; i < 9; ++i) {
            this.matrix[i] = IsoTypeReader.readUInt32(byteBuffer);
        }
        this.previewTime = byteBuffer.getInt();
        this.previewDuration = byteBuffer.getInt();
        this.posterTime = byteBuffer.getInt();
        this.selectionTime = byteBuffer.getInt();
        this.selectionDuration = byteBuffer.getInt();
        this.currentTime = byteBuffer.getInt();
        this.nextTrackId = IsoTypeReader.readUInt32(byteBuffer);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MovieHeaderBox[");
        stringBuilder.append("creationTime=").append(this.getCreationTime());
        stringBuilder.append(";");
        stringBuilder.append("modificationTime=").append(this.getModificationTime());
        stringBuilder.append(";");
        stringBuilder.append("timescale=").append(this.getTimescale());
        stringBuilder.append(";");
        stringBuilder.append("duration=").append(this.getDuration());
        stringBuilder.append(";");
        stringBuilder.append("rate=").append(this.getRate());
        stringBuilder.append(";");
        stringBuilder.append("volume=").append(this.getVolume());
        for (int i = 0; i < this.matrix.length; ++i) {
            stringBuilder.append(";");
            stringBuilder.append("matrix").append(i).append("=").append(this.matrix[i]);
        }
        stringBuilder.append(";");
        stringBuilder.append("nextTrackId=").append(this.getNextTrackId());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        if (this.getVersion() == 1) {
            IsoTypeWriter.writeUInt64(byteBuffer, this.creationTime);
            IsoTypeWriter.writeUInt64(byteBuffer, this.modificationTime);
            IsoTypeWriter.writeUInt32(byteBuffer, this.timescale);
            IsoTypeWriter.writeUInt64(byteBuffer, this.duration);
        } else {
            IsoTypeWriter.writeUInt32(byteBuffer, this.creationTime);
            IsoTypeWriter.writeUInt32(byteBuffer, this.modificationTime);
            IsoTypeWriter.writeUInt32(byteBuffer, this.timescale);
            IsoTypeWriter.writeUInt32(byteBuffer, this.duration);
        }
        IsoTypeWriter.writeFixedPoint1616(byteBuffer, this.rate);
        IsoTypeWriter.writeFixedPoint88(byteBuffer, this.volume);
        IsoTypeWriter.writeUInt16(byteBuffer, 0);
        IsoTypeWriter.writeUInt32(byteBuffer, 0L);
        IsoTypeWriter.writeUInt32(byteBuffer, 0L);
        for (int i = 0; i < 9; ++i) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.matrix[i]);
        }
        byteBuffer.putInt(this.previewTime);
        byteBuffer.putInt(this.previewDuration);
        byteBuffer.putInt(this.posterTime);
        byteBuffer.putInt(this.selectionTime);
        byteBuffer.putInt(this.selectionDuration);
        byteBuffer.putInt(this.currentTime);
        IsoTypeWriter.writeUInt32(byteBuffer, this.nextTrackId);
    }

    public void setCreationTime(long l) {
        this.creationTime = l;
    }

    public void setModificationTime(long l) {
        this.modificationTime = l;
    }

    public void setTimescale(long l) {
        this.timescale = l;
    }

    public void setDuration(long l) {
        this.duration = l;
    }

    public void setRate(double d) {
        this.rate = d;
    }

    public void setVolume(float f) {
        this.volume = f;
    }

    public void setMatrix(long[] lArray) {
        this.matrix = lArray;
    }

    public void setNextTrackId(long l) {
        this.nextTrackId = l;
    }

    public int getPreviewTime() {
        return this.previewTime;
    }

    public void setPreviewTime(int n) {
        this.previewTime = n;
    }

    public int getPreviewDuration() {
        return this.previewDuration;
    }

    public void setPreviewDuration(int n) {
        this.previewDuration = n;
    }

    public int getPosterTime() {
        return this.posterTime;
    }

    public void setPosterTime(int n) {
        this.posterTime = n;
    }

    public int getSelectionTime() {
        return this.selectionTime;
    }

    public void setSelectionTime(int n) {
        this.selectionTime = n;
    }

    public int getSelectionDuration() {
        return this.selectionDuration;
    }

    public void setSelectionDuration(int n) {
        this.selectionDuration = n;
    }

    public int getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(int n) {
        this.currentTime = n;
    }
}

