/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractFullBox;
import com.googlecode.mp4parser.util.CastUtils;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class SampleAuxiliaryInformationSizesBox
extends AbstractFullBox {
    public static final String TYPE = "saiz";
    private int defaultSampleInfoSize;
    private List<Short> sampleInfoSizes = new LinkedList<Short>();
    private int sampleCount;
    private String auxInfoType;
    private String auxInfoTypeParameter;

    public SampleAuxiliaryInformationSizesBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        int n = 4;
        if ((this.getFlags() & 1) == 1) {
            n += 8;
        }
        n += 5;
        return n += this.defaultSampleInfoSize == 0 ? this.sampleInfoSizes.size() : 0;
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        if ((this.getFlags() & 1) == 1) {
            byteBuffer.put(IsoFile.fourCCtoBytes(this.auxInfoType));
            byteBuffer.put(IsoFile.fourCCtoBytes(this.auxInfoTypeParameter));
        }
        IsoTypeWriter.writeUInt8(byteBuffer, this.defaultSampleInfoSize);
        if (this.defaultSampleInfoSize == 0) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.sampleInfoSizes.size());
            for (short s : this.sampleInfoSizes) {
                IsoTypeWriter.writeUInt8(byteBuffer, s);
            }
        } else {
            IsoTypeWriter.writeUInt32(byteBuffer, this.sampleCount);
        }
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        if ((this.getFlags() & 1) == 1) {
            this.auxInfoType = IsoTypeReader.read4cc(byteBuffer);
            this.auxInfoTypeParameter = IsoTypeReader.read4cc(byteBuffer);
        }
        this.defaultSampleInfoSize = (short)IsoTypeReader.readUInt8(byteBuffer);
        this.sampleCount = CastUtils.l2i(IsoTypeReader.readUInt32(byteBuffer));
        this.sampleInfoSizes.clear();
        if (this.defaultSampleInfoSize == 0) {
            for (int i = 0; i < this.sampleCount; ++i) {
                this.sampleInfoSizes.add((short)IsoTypeReader.readUInt8(byteBuffer));
            }
        }
    }

    public String getAuxInfoType() {
        return this.auxInfoType;
    }

    public void setAuxInfoType(String string) {
        this.auxInfoType = string;
    }

    public String getAuxInfoTypeParameter() {
        return this.auxInfoTypeParameter;
    }

    public void setAuxInfoTypeParameter(String string) {
        this.auxInfoTypeParameter = string;
    }

    public int getDefaultSampleInfoSize() {
        return this.defaultSampleInfoSize;
    }

    public void setDefaultSampleInfoSize(int n) {
        assert (n <= 255);
        this.defaultSampleInfoSize = n;
    }

    public List<Short> getSampleInfoSizes() {
        return this.sampleInfoSizes;
    }

    public void setSampleInfoSizes(List<Short> list) {
        this.sampleInfoSizes = list;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public void setSampleCount(int n) {
        this.sampleCount = n;
    }

    public String toString() {
        return "SampleAuxiliaryInformationSizesBox{defaultSampleInfoSize=" + this.defaultSampleInfoSize + ", sampleCount=" + this.sampleCount + ", auxInfoType='" + this.auxInfoType + '\'' + ", auxInfoTypeParameter='" + this.auxInfoTypeParameter + '\'' + '}';
    }
}

