/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractFullBox;
import com.googlecode.mp4parser.util.CastUtils;
import java.nio.ByteBuffer;

public class SampleSizeBox
extends AbstractFullBox {
    private long sampleSize;
    private long[] sampleSizes = new long[0];
    public static final String TYPE = "stsz";
    int sampleCount;

    public SampleSizeBox() {
        super(TYPE);
    }

    public long getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(long l) {
        this.sampleSize = l;
    }

    public long getSampleSizeAtIndex(int n) {
        if (this.sampleSize > 0L) {
            return this.sampleSize;
        }
        return this.sampleSizes[n];
    }

    public long getSampleCount() {
        if (this.sampleSize > 0L) {
            return this.sampleCount;
        }
        return this.sampleSizes.length;
    }

    public long[] getSampleSizes() {
        return this.sampleSizes;
    }

    public void setSampleSizes(long[] lArray) {
        this.sampleSizes = lArray;
    }

    @Override
    protected long getContentSize() {
        return 12 + (this.sampleSize == 0L ? this.sampleSizes.length * 4 : 0);
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        this.sampleSize = IsoTypeReader.readUInt32(byteBuffer);
        this.sampleCount = CastUtils.l2i(IsoTypeReader.readUInt32(byteBuffer));
        if (this.sampleSize == 0L) {
            this.sampleSizes = new long[this.sampleCount];
            for (int i = 0; i < this.sampleCount; ++i) {
                this.sampleSizes[i] = IsoTypeReader.readUInt32(byteBuffer);
            }
        }
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeUInt32(byteBuffer, this.sampleSize);
        if (this.sampleSize == 0L) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.sampleSizes.length);
            for (long l : this.sampleSizes) {
                IsoTypeWriter.writeUInt32(byteBuffer, l);
            }
        } else {
            IsoTypeWriter.writeUInt32(byteBuffer, this.sampleCount);
        }
    }

    public String toString() {
        return "SampleSizeBox[sampleSize=" + this.getSampleSize() + ";sampleCount=" + this.getSampleCount() + "]";
    }
}

