/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractBox;
import java.nio.ByteBuffer;

public class TrackReferenceTypeBox
extends AbstractBox {
    public static final String TYPE1 = "hint";
    public static final String TYPE2 = "cdsc";
    private long[] trackIds;

    public TrackReferenceTypeBox(String string) {
        super(string);
    }

    public long[] getTrackIds() {
        return this.trackIds;
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining() / 4;
        this.trackIds = new long[n];
        for (int i = 0; i < n; ++i) {
            this.trackIds[i] = IsoTypeReader.readUInt32(byteBuffer);
        }
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        for (long l : this.trackIds) {
            IsoTypeWriter.writeUInt32(byteBuffer, l);
        }
    }

    @Override
    protected long getContentSize() {
        return this.trackIds.length * 4;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("TrackReferenceTypeBox[type=").append(this.getType());
        for (int i = 0; i < this.trackIds.length; ++i) {
            stringBuilder.append(";trackId");
            stringBuilder.append(i);
            stringBuilder.append("=");
            stringBuilder.append(this.trackIds[i]);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

