/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.fragment;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeReaderVariable;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.IsoTypeWriterVariable;
import com.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TrackFragmentRandomAccessBox
extends AbstractFullBox {
    public static final String TYPE = "tfra";
    private long trackId;
    private int reserved;
    private int lengthSizeOfTrafNum = 2;
    private int lengthSizeOfTrunNum = 2;
    private int lengthSizeOfSampleNum = 2;
    private List<Entry> entries = Collections.emptyList();

    public TrackFragmentRandomAccessBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        long l = 4L;
        l += 12L;
        l = this.getVersion() == 1 ? (l += (long)(16 * this.entries.size())) : (l += (long)(8 * this.entries.size()));
        l += (long)(this.lengthSizeOfTrafNum * this.entries.size());
        l += (long)(this.lengthSizeOfTrunNum * this.entries.size());
        return l += (long)(this.lengthSizeOfSampleNum * this.entries.size());
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        this.trackId = IsoTypeReader.readUInt32(byteBuffer);
        long l = IsoTypeReader.readUInt32(byteBuffer);
        this.reserved = (int)(l >> 6);
        this.lengthSizeOfTrafNum = ((int)(l & 0x3FL) >> 4) + 1;
        this.lengthSizeOfTrunNum = ((int)(l & 0xCL) >> 2) + 1;
        this.lengthSizeOfSampleNum = (int)(l & 3L) + 1;
        long l2 = IsoTypeReader.readUInt32(byteBuffer);
        this.entries = new ArrayList<Entry>();
        int n = 0;
        while ((long)n < l2) {
            Entry entry = new Entry();
            if (this.getVersion() == 1) {
                entry.time = IsoTypeReader.readUInt64(byteBuffer);
                entry.moofOffset = IsoTypeReader.readUInt64(byteBuffer);
            } else {
                entry.time = IsoTypeReader.readUInt32(byteBuffer);
                entry.moofOffset = IsoTypeReader.readUInt32(byteBuffer);
            }
            entry.trafNumber = IsoTypeReaderVariable.read(byteBuffer, this.lengthSizeOfTrafNum);
            entry.trunNumber = IsoTypeReaderVariable.read(byteBuffer, this.lengthSizeOfTrunNum);
            entry.sampleNumber = IsoTypeReaderVariable.read(byteBuffer, this.lengthSizeOfSampleNum);
            this.entries.add(entry);
            ++n;
        }
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeUInt32(byteBuffer, this.trackId);
        long l = this.reserved << 6;
        l |= (long)((this.lengthSizeOfTrafNum - 1 & 3) << 4);
        l |= (long)((this.lengthSizeOfTrunNum - 1 & 3) << 2);
        IsoTypeWriter.writeUInt32(byteBuffer, l |= (long)(this.lengthSizeOfSampleNum - 1 & 3));
        IsoTypeWriter.writeUInt32(byteBuffer, this.entries.size());
        for (Entry entry : this.entries) {
            if (this.getVersion() == 1) {
                IsoTypeWriter.writeUInt64(byteBuffer, entry.time);
                IsoTypeWriter.writeUInt64(byteBuffer, entry.moofOffset);
            } else {
                IsoTypeWriter.writeUInt32(byteBuffer, entry.time);
                IsoTypeWriter.writeUInt32(byteBuffer, entry.moofOffset);
            }
            IsoTypeWriterVariable.write(entry.trafNumber, byteBuffer, this.lengthSizeOfTrafNum);
            IsoTypeWriterVariable.write(entry.trunNumber, byteBuffer, this.lengthSizeOfTrunNum);
            IsoTypeWriterVariable.write(entry.sampleNumber, byteBuffer, this.lengthSizeOfSampleNum);
        }
    }

    public void setTrackId(long l) {
        this.trackId = l;
    }

    public void setLengthSizeOfTrafNum(int n) {
        this.lengthSizeOfTrafNum = n;
    }

    public void setLengthSizeOfTrunNum(int n) {
        this.lengthSizeOfTrunNum = n;
    }

    public void setLengthSizeOfSampleNum(int n) {
        this.lengthSizeOfSampleNum = n;
    }

    public long getTrackId() {
        return this.trackId;
    }

    public int getReserved() {
        return this.reserved;
    }

    public int getLengthSizeOfTrafNum() {
        return this.lengthSizeOfTrafNum;
    }

    public int getLengthSizeOfTrunNum() {
        return this.lengthSizeOfTrunNum;
    }

    public int getLengthSizeOfSampleNum() {
        return this.lengthSizeOfSampleNum;
    }

    public long getNumberOfEntries() {
        return this.entries.size();
    }

    public List<Entry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public void setEntries(List<Entry> list) {
        this.entries = list;
    }

    public String toString() {
        return "TrackFragmentRandomAccessBox{trackId=" + this.trackId + ", entries=" + this.entries + '}';
    }

    public static class Entry {
        private long time;
        private long moofOffset;
        private long trafNumber;
        private long trunNumber;
        private long sampleNumber;

        public Entry() {
        }

        public Entry(long l, long l2, long l3, long l4, long l5) {
            this.moofOffset = l2;
            this.sampleNumber = l5;
            this.time = l;
            this.trafNumber = l3;
            this.trunNumber = l4;
        }

        public long getTime() {
            return this.time;
        }

        public long getMoofOffset() {
            return this.moofOffset;
        }

        public long getTrafNumber() {
            return this.trafNumber;
        }

        public long getTrunNumber() {
            return this.trunNumber;
        }

        public long getSampleNumber() {
            return this.sampleNumber;
        }

        public void setTime(long l) {
            this.time = l;
        }

        public void setMoofOffset(long l) {
            this.moofOffset = l;
        }

        public void setTrafNumber(long l) {
            this.trafNumber = l;
        }

        public void setTrunNumber(long l) {
            this.trunNumber = l;
        }

        public void setSampleNumber(long l) {
            this.sampleNumber = l;
        }

        public String toString() {
            return "Entry{time=" + this.time + ", moofOffset=" + this.moofOffset + ", trafNumber=" + this.trafNumber + ", trunNumber=" + this.trunNumber + ", sampleNumber=" + this.sampleNumber + '}';
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Entry entry = (Entry)object;
            if (this.moofOffset != entry.moofOffset) {
                return false;
            }
            if (this.sampleNumber != entry.sampleNumber) {
                return false;
            }
            if (this.time != entry.time) {
                return false;
            }
            if (this.trafNumber != entry.trafNumber) {
                return false;
            }
            return this.trunNumber == entry.trunNumber;
        }

        public int hashCode() {
            int n = (int)(this.time ^ this.time >>> 32);
            n = 31 * n + (int)(this.moofOffset ^ this.moofOffset >>> 32);
            n = 31 * n + (int)(this.trafNumber ^ this.trafNumber >>> 32);
            n = 31 * n + (int)(this.trunNumber ^ this.trunNumber >>> 32);
            n = 31 * n + (int)(this.sampleNumber ^ this.sampleNumber >>> 32);
            return n;
        }
    }
}

