/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.mdat;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ChunkOffsetBox;
import com.coremedia.iso.boxes.SampleSizeBox;
import com.coremedia.iso.boxes.SampleToChunkBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.fragment.MovieExtendsBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentBox;
import com.coremedia.iso.boxes.fragment.TrackExtendsBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentHeaderBox;
import com.coremedia.iso.boxes.fragment.TrackRunBox;
import com.coremedia.iso.boxes.mdat.MediaDataBox;
import com.googlecode.mp4parser.util.CastUtils;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SampleList
extends AbstractList<ByteBuffer> {
    long[] offsets;
    long[] sizes;
    IsoFile isoFile;
    MediaDataBox[] mdats;

    public long[] getOffsetKeys() {
        return this.offsets;
    }

    public SampleList(TrackBox trackBox) {
        Object object;
        long[] lArray;
        this.initIsoFile(trackBox.getIsoFile());
        SampleSizeBox sampleSizeBox = trackBox.getSampleTableBox().getSampleSizeBox();
        ChunkOffsetBox chunkOffsetBox = trackBox.getSampleTableBox().getChunkOffsetBox();
        SampleToChunkBox sampleToChunkBox = trackBox.getSampleTableBox().getSampleToChunkBox();
        long[] lArray2 = lArray = chunkOffsetBox != null ? chunkOffsetBox.getChunkOffsets() : new long[]{};
        if (sampleToChunkBox != null && sampleToChunkBox.getEntries().size() > 0 && lArray.length > 0 && sampleSizeBox != null && sampleSizeBox.getSampleCount() > 0L) {
            object = sampleToChunkBox.blowup(lArray.length);
            int n = 0;
            if (sampleSizeBox.getSampleSize() > 0L) {
                this.sizes = new long[CastUtils.l2i(sampleSizeBox.getSampleCount())];
                Arrays.fill(this.sizes, sampleSizeBox.getSampleSize());
            } else {
                this.sizes = sampleSizeBox.getSampleSizes();
            }
            this.offsets = new long[this.sizes.length];
            for (int i = 0; i < ((Object)object).length; ++i) {
                Object object2 = object[i];
                long l = lArray[i];
                int n2 = 0;
                while ((long)n2 < object2) {
                    long l2 = this.sizes[n];
                    this.offsets[n] = l;
                    l += l2;
                    ++n;
                    ++n2;
                }
            }
        }
        if ((object = trackBox.getParent().getBoxes(MovieExtendsBox.class)).size() > 0) {
            HashMap<Long, Long> hashMap = new HashMap<Long, Long>();
            List<TrackExtendsBox> list = object.get(0).getBoxes(TrackExtendsBox.class);
            for (TrackExtendsBox trackExtendsBox : list) {
                if (trackExtendsBox.getTrackId() != trackBox.getTrackHeaderBox().getTrackId()) continue;
                for (MovieFragmentBox movieFragmentBox : trackBox.getIsoFile().getBoxes(MovieFragmentBox.class)) {
                    hashMap.putAll(this.getOffsets(movieFragmentBox, trackBox.getTrackHeaderBox().getTrackId(), trackExtendsBox));
                }
            }
            if (this.sizes == null || this.offsets == null) {
                this.sizes = new long[0];
                this.offsets = new long[0];
            }
            this.splitToArrays(hashMap);
        }
    }

    private void splitToArrays(Map<Long, Long> map) {
        ArrayList<Long> arrayList = new ArrayList<Long>(map.keySet());
        Collections.sort(arrayList);
        long[] lArray = new long[this.sizes.length + arrayList.size()];
        System.arraycopy(this.sizes, 0, lArray, 0, this.sizes.length);
        long[] lArray2 = new long[this.offsets.length + arrayList.size()];
        System.arraycopy(this.offsets, 0, lArray2, 0, this.offsets.length);
        for (int i = 0; i < arrayList.size(); ++i) {
            lArray2[i + this.offsets.length] = (Long)arrayList.get(i);
            lArray[i + this.sizes.length] = map.get(arrayList.get(i));
        }
        this.sizes = lArray;
        this.offsets = lArray2;
    }

    public SampleList(TrackFragmentBox trackFragmentBox) {
        this.sizes = new long[0];
        this.offsets = new long[0];
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>();
        this.initIsoFile(trackFragmentBox.getIsoFile());
        List<MovieFragmentBox> list = this.isoFile.getBoxes(MovieFragmentBox.class);
        long l = trackFragmentBox.getTrackFragmentHeaderBox().getTrackId();
        for (MovieFragmentBox movieFragmentBox : list) {
            List<TrackFragmentHeaderBox> list2 = movieFragmentBox.getTrackFragmentHeaderBoxes();
            for (TrackFragmentHeaderBox trackFragmentHeaderBox : list2) {
                if (trackFragmentHeaderBox.getTrackId() != l) continue;
                hashMap.putAll(this.getOffsets(movieFragmentBox, l, null));
            }
        }
        this.splitToArrays(hashMap);
    }

    private void initIsoFile(IsoFile isoFile) {
        this.isoFile = isoFile;
        long l = 0L;
        LinkedList<MediaDataBox> linkedList = new LinkedList<MediaDataBox>();
        for (Box box : this.isoFile.getBoxes()) {
            long l2 = box.getSize();
            if ("mdat".equals(box.getType())) {
                if (box instanceof MediaDataBox) {
                    linkedList.add((MediaDataBox)box);
                } else {
                    throw new RuntimeException("Sample need to be in mdats and mdats need to be instanceof MediaDataBox");
                }
            }
            l += l2;
        }
        this.mdats = linkedList.toArray(new MediaDataBox[linkedList.size()]);
    }

    @Override
    public int size() {
        return this.sizes.length;
    }

    @Override
    public ByteBuffer get(int n) {
        long l = this.offsets[n];
        int n2 = CastUtils.l2i(this.sizes[n]);
        for (MediaDataBox mediaDataBox : this.mdats) {
            if (mediaDataBox.getDataStartPosition() > l || l + (long)n2 > mediaDataBox.getDataEndPosition()) continue;
            return mediaDataBox.getContent(l - mediaDataBox.getDataStartPosition(), n2);
        }
        throw new RuntimeException("The sample with offset " + l + " and size " + CastUtils.l2i(this.sizes[n]) + " is NOT located within an mdat");
    }

    Map<Long, Long> getOffsets(MovieFragmentBox movieFragmentBox, long l, TrackExtendsBox trackExtendsBox) {
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>();
        List<TrackFragmentBox> list = movieFragmentBox.getBoxes(TrackFragmentBox.class);
        for (TrackFragmentBox trackFragmentBox : list) {
            if (trackFragmentBox.getTrackFragmentHeaderBox().getTrackId() != l) continue;
            long l2 = trackFragmentBox.getTrackFragmentHeaderBox().hasBaseDataOffset() ? trackFragmentBox.getTrackFragmentHeaderBox().getBaseDataOffset() : movieFragmentBox.getOffset();
            for (TrackRunBox trackRunBox : trackFragmentBox.getBoxes(TrackRunBox.class)) {
                long l3 = l2 + (long)trackRunBox.getDataOffset();
                TrackFragmentHeaderBox trackFragmentHeaderBox = ((TrackFragmentBox)trackRunBox.getParent()).getTrackFragmentHeaderBox();
                long l4 = 0L;
                for (TrackRunBox.Entry entry : trackRunBox.getEntries()) {
                    long l5;
                    if (trackRunBox.isSampleSizePresent()) {
                        l5 = entry.getSampleSize();
                        hashMap.put(l4 + l3, l5);
                        l4 += l5;
                        continue;
                    }
                    if (trackFragmentHeaderBox.hasDefaultSampleSize()) {
                        l5 = trackFragmentHeaderBox.getDefaultSampleSize();
                        hashMap.put(l4 + l3, l5);
                        l4 += l5;
                        continue;
                    }
                    if (trackExtendsBox == null) {
                        throw new RuntimeException("File doesn't contain trex box but track fragments aren't fully self contained. Cannot determine sample size.");
                    }
                    l5 = trackExtendsBox.getDefaultSampleSize();
                    hashMap.put(l4 + l3, l5);
                    l4 += l5;
                }
            }
        }
        return hashMap;
    }
}

