/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.builder;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.DataEntryUrlBox;
import com.coremedia.iso.boxes.DataInformationBox;
import com.coremedia.iso.boxes.DataReferenceBox;
import com.coremedia.iso.boxes.FileTypeBox;
import com.coremedia.iso.boxes.HandlerBox;
import com.coremedia.iso.boxes.MediaBox;
import com.coremedia.iso.boxes.MediaHeaderBox;
import com.coremedia.iso.boxes.MediaInformationBox;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.MovieHeaderBox;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleTableBox;
import com.coremedia.iso.boxes.StaticChunkOffsetBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.TrackHeaderBox;
import com.coremedia.iso.boxes.fragment.MovieExtendsBox;
import com.coremedia.iso.boxes.fragment.MovieExtendsHeaderBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentHeaderBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentRandomAccessBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentRandomAccessOffsetBox;
import com.coremedia.iso.boxes.fragment.SampleFlags;
import com.coremedia.iso.boxes.fragment.TrackExtendsBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentHeaderBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentRandomAccessBox;
import com.coremedia.iso.boxes.fragment.TrackRunBox;
import com.googlecode.mp4parser.authoring.DateHelper;
import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.builder.FragmentIntersectionFinder;
import com.googlecode.mp4parser.authoring.builder.Mp4Builder;
import com.googlecode.mp4parser.authoring.builder.SyncSampleIntersectFinderImpl;
import com.googlecode.mp4parser.util.CastUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class FragmentedMp4Builder
implements Mp4Builder {
    private static final Logger LOG = Logger.getLogger(FragmentedMp4Builder.class.getName());
    protected FragmentIntersectionFinder intersectionFinder = new SyncSampleIntersectFinderImpl();

    public List<String> getAllowedHandlers() {
        return Arrays.asList("soun", "vide");
    }

    public Box createFtyp(Movie movie) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("isom");
        linkedList.add("iso2");
        linkedList.add("avc1");
        return new FileTypeBox("isom", 0L, linkedList);
    }

    protected List<Track> sortTracksInSequence(List<Track> list, final int n, final Map<Track, long[]> map) {
        list = new LinkedList<Track>(list);
        Collections.sort(list, new Comparator<Track>(){

            @Override
            public int compare(Track track, Track track2) {
                long[] lArray = (long[])map.get(track);
                long l = lArray[n];
                long l2 = n + 1 < lArray.length ? lArray[n + 1] : (long)(track.getSamples().size() + 1);
                long[] lArray2 = (long[])map.get(track2);
                long l3 = lArray2[n];
                long l4 = n + 1 < lArray2.length ? lArray2[n + 1] : (long)(track2.getSamples().size() + 1);
                List<ByteBuffer> list = track.getSamples().subList(CastUtils.l2i(l) - 1, CastUtils.l2i(l2) - 1);
                List<ByteBuffer> list2 = track2.getSamples().subList(CastUtils.l2i(l3) - 1, CastUtils.l2i(l4) - 1);
                int n3 = 0;
                for (ByteBuffer object : list) {
                    n3 += object.remaining();
                }
                int n2 = 0;
                for (ByteBuffer byteBuffer : list2) {
                    n2 += byteBuffer.remaining();
                }
                return n3 - n2;
            }
        });
        return list;
    }

    protected List<Box> createMoofMdat(Movie movie) {
        Object object;
        LinkedList<Box> linkedList = new LinkedList<Box>();
        HashMap<Track, long[]> hashMap = new HashMap<Track, long[]>();
        int n = 0;
        for (Track track : movie.getTracks()) {
            object = this.intersectionFinder.sampleNumbers(track, movie);
            hashMap.put(track, (long[])object);
            n = Math.max(n, ((Object)object).length);
        }
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            object = this.sortTracksInSequence(movie.getTracks(), i, hashMap);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                long l;
                long l2;
                long[] lArray;
                Track track = (Track)iterator.next();
                if (!this.getAllowedHandlers().isEmpty() && !this.getAllowedHandlers().contains(track.getHandler()) || i >= (lArray = hashMap.get(track)).length || (l2 = lArray[i]) == (l = i + 1 < lArray.length ? lArray[i + 1] : (long)(track.getSamples().size() + 1))) continue;
                linkedList.add(this.createMoof(l2, l, track, n2));
                linkedList.add(this.createMdat(l2, l, track, n2++));
            }
        }
        return linkedList;
    }

    @Override
    public IsoFile build(Movie movie) {
        LOG.fine("Creating movie " + movie);
        IsoFile isoFile = new IsoFile();
        isoFile.addBox(this.createFtyp(movie));
        isoFile.addBox(this.createMoov(movie));
        for (Box box : this.createMoofMdat(movie)) {
            isoFile.addBox(box);
        }
        isoFile.addBox(this.createMfra(movie, isoFile));
        return isoFile;
    }

    protected Box createMdat(final long l, final long l2, final Track track, final int n) {
        class Mdat
        implements Box {
            ContainerBox parent;

            Mdat() {
            }

            @Override
            public ContainerBox getParent() {
                return this.parent;
            }

            @Override
            public void setParent(ContainerBox containerBox) {
                this.parent = containerBox;
            }

            @Override
            public long getSize() {
                long l3 = 8L;
                for (ByteBuffer byteBuffer : FragmentedMp4Builder.this.getSamples(l, l2, track, n)) {
                    l3 += (long)byteBuffer.remaining();
                }
                return l3;
            }

            @Override
            public String getType() {
                return "mdat";
            }

            @Override
            public void getBox(WritableByteChannel writableByteChannel) throws IOException {
                ByteBuffer byteBuffer = ByteBuffer.allocate(8);
                IsoTypeWriter.writeUInt32(byteBuffer, CastUtils.l2i(this.getSize()));
                byteBuffer.put(IsoFile.fourCCtoBytes(this.getType()));
                byteBuffer.rewind();
                writableByteChannel.write(byteBuffer);
                List<ByteBuffer> list = FragmentedMp4Builder.this.getSamples(l, l2, track, n);
                for (ByteBuffer byteBuffer2 : list) {
                    writableByteChannel.write(byteBuffer2);
                }
            }

            @Override
            public void parse(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer, long l3, BoxParser boxParser) throws IOException {
            }
        }
        return new Mdat();
    }

    protected Box createTfhd(long l, long l2, Track track, int n) {
        TrackFragmentHeaderBox trackFragmentHeaderBox = new TrackFragmentHeaderBox();
        SampleFlags sampleFlags = new SampleFlags();
        trackFragmentHeaderBox.setDefaultSampleFlags(sampleFlags);
        trackFragmentHeaderBox.setBaseDataOffset(-1L);
        trackFragmentHeaderBox.setTrackId(track.getTrackMetaData().getTrackId());
        return trackFragmentHeaderBox;
    }

    protected Box createMfhd(long l, long l2, Track track, int n) {
        MovieFragmentHeaderBox movieFragmentHeaderBox = new MovieFragmentHeaderBox();
        movieFragmentHeaderBox.setSequenceNumber(n);
        return movieFragmentHeaderBox;
    }

    protected Box createTraf(long l, long l2, Track track, int n) {
        TrackFragmentBox trackFragmentBox = new TrackFragmentBox();
        trackFragmentBox.addBox(this.createTfhd(l, l2, track, n));
        for (Box box : this.createTruns(l, l2, track, n)) {
            trackFragmentBox.addBox(box);
        }
        return trackFragmentBox;
    }

    protected List<ByteBuffer> getSamples(long l, long l2, Track track, int n) {
        return track.getSamples().subList(CastUtils.l2i(l) - 1, CastUtils.l2i(l2) - 1);
    }

    protected long[] getSampleSizes(long l, long l2, Track track, int n) {
        List<ByteBuffer> list = this.getSamples(l, l2, track, n);
        long[] lArray = new long[list.size()];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = list.get(i).remaining();
        }
        return lArray;
    }

    protected List<? extends Box> createTruns(long l, long l2, Track track, int n) {
        long l3;
        TrackRunBox trackRunBox = new TrackRunBox();
        long[] lArray = this.getSampleSizes(l, l2, track, n);
        trackRunBox.setSampleDurationPresent(true);
        trackRunBox.setSampleSizePresent(true);
        ArrayList<TrackRunBox.Entry> arrayList = new ArrayList<TrackRunBox.Entry>(CastUtils.l2i(l2 - l));
        LinkedList<TimeToSampleBox.Entry> linkedList = new LinkedList<TimeToSampleBox.Entry>(track.getDecodingTimeEntries());
        long l4 = ((TimeToSampleBox.Entry)linkedList.peek()).getCount();
        for (l3 = l - 1L; l3 > l4; l3 -= l4) {
            linkedList.remove();
            l4 = ((TimeToSampleBox.Entry)linkedList.peek()).getCount();
        }
        l4 -= l3;
        LinkedList<CompositionTimeToSample.Entry> linkedList2 = track.getCompositionTimeEntries() != null && track.getCompositionTimeEntries().size() > 0 ? new LinkedList<CompositionTimeToSample.Entry>(track.getCompositionTimeEntries()) : null;
        long l5 = linkedList2 != null ? (long)((CompositionTimeToSample.Entry)linkedList2.peek()).getCount() : -1L;
        trackRunBox.setSampleCompositionTimeOffsetPresent(l5 > 0L);
        for (long i = 1L; i < l; ++i) {
            if (linkedList2 == null || --l5 != 0L || linkedList2.size() <= 1) continue;
            linkedList2.remove();
            l5 = ((CompositionTimeToSample.Entry)linkedList2.element()).getCount();
        }
        boolean bl = track.getSampleDependencies() != null && !track.getSampleDependencies().isEmpty() || track.getSyncSamples() != null && track.getSyncSamples().length != 0;
        trackRunBox.setSampleFlagsPresent(bl);
        for (int i = 0; i < lArray.length; ++i) {
            TrackRunBox.Entry entry = new TrackRunBox.Entry();
            entry.setSampleSize(lArray[i]);
            if (bl) {
                SampleFlags sampleFlags = new SampleFlags();
                if (track.getSampleDependencies() != null && !track.getSampleDependencies().isEmpty()) {
                    SampleDependencyTypeBox.Entry entry2 = track.getSampleDependencies().get(i);
                    sampleFlags.setSampleDependsOn(entry2.getSampleDependsOn());
                    sampleFlags.setSampleIsDependedOn(entry2.getSampleIsDependentOn());
                    sampleFlags.setSampleHasRedundancy(entry2.getSampleHasRedundancy());
                }
                if (track.getSyncSamples() != null && track.getSyncSamples().length > 0) {
                    if (Arrays.binarySearch(track.getSyncSamples(), l + (long)i) >= 0) {
                        sampleFlags.setSampleIsDifferenceSample(false);
                        sampleFlags.setSampleDependsOn(2);
                    } else {
                        sampleFlags.setSampleIsDifferenceSample(true);
                        sampleFlags.setSampleDependsOn(1);
                    }
                }
                entry.setSampleFlags(sampleFlags);
            }
            entry.setSampleDuration(((TimeToSampleBox.Entry)linkedList.peek()).getDelta());
            if (--l4 == 0L && linkedList.size() > 1) {
                linkedList.remove();
                l4 = ((TimeToSampleBox.Entry)linkedList.peek()).getCount();
            }
            if (linkedList2 != null) {
                entry.setSampleCompositionTimeOffset(((CompositionTimeToSample.Entry)linkedList2.peek()).getOffset());
                if (--l5 == 0L && linkedList2.size() > 1) {
                    linkedList2.remove();
                    l5 = ((CompositionTimeToSample.Entry)linkedList2.element()).getCount();
                }
            }
            arrayList.add(entry);
        }
        trackRunBox.setEntries(arrayList);
        return Collections.singletonList(trackRunBox);
    }

    protected Box createMoof(long l, long l2, Track track, int n) {
        MovieFragmentBox movieFragmentBox = new MovieFragmentBox();
        movieFragmentBox.addBox(this.createMfhd(l, l2, track, n));
        movieFragmentBox.addBox(this.createTraf(l, l2, track, n));
        TrackRunBox trackRunBox = movieFragmentBox.getTrackRunBoxes().get(0);
        trackRunBox.setDataOffset(1);
        trackRunBox.setDataOffset((int)(8L + movieFragmentBox.getSize()));
        return movieFragmentBox;
    }

    protected Box createMvhd(Movie movie) {
        MovieHeaderBox movieHeaderBox = new MovieHeaderBox();
        movieHeaderBox.setVersion(1);
        movieHeaderBox.setCreationTime(DateHelper.convert(new Date()));
        movieHeaderBox.setModificationTime(DateHelper.convert(new Date()));
        long l = movie.getTimescale();
        long l2 = 0L;
        for (Track track : movie.getTracks()) {
            long l3 = this.getDuration(track) * l / track.getTrackMetaData().getTimescale();
            if (l3 <= l2) continue;
            l2 = l3;
        }
        movieHeaderBox.setDuration(l2);
        movieHeaderBox.setTimescale(l);
        long l4 = 0L;
        for (Track track : movie.getTracks()) {
            l4 = l4 < track.getTrackMetaData().getTrackId() ? track.getTrackMetaData().getTrackId() : l4;
        }
        movieHeaderBox.setNextTrackId(++l4);
        return movieHeaderBox;
    }

    protected Box createMoov(Movie movie) {
        MovieBox movieBox = new MovieBox();
        movieBox.addBox(this.createMvhd(movie));
        movieBox.addBox(this.createMvex(movie));
        for (Track track : movie.getTracks()) {
            movieBox.addBox(this.createTrak(track, movie));
        }
        return movieBox;
    }

    protected Box createTfra(Track track, IsoFile isoFile) {
        TrackFragmentRandomAccessBox trackFragmentRandomAccessBox = new TrackFragmentRandomAccessBox();
        trackFragmentRandomAccessBox.setVersion(1);
        LinkedList<TrackFragmentRandomAccessBox.Entry> linkedList = new LinkedList<TrackFragmentRandomAccessBox.Entry>();
        List<Box> list = isoFile.getBoxes();
        long l = 0L;
        long l2 = 0L;
        for (Box box : list) {
            if (box instanceof MovieFragmentBox) {
                List<TrackFragmentBox> list2 = ((MovieFragmentBox)box).getBoxes(TrackFragmentBox.class);
                for (int i = 0; i < list2.size(); ++i) {
                    TrackFragmentBox trackFragmentBox = list2.get(i);
                    if (trackFragmentBox.getTrackFragmentHeaderBox().getTrackId() != track.getTrackMetaData().getTrackId()) continue;
                    List<TrackRunBox> list3 = trackFragmentBox.getBoxes(TrackRunBox.class);
                    for (int j = 0; j < list3.size(); ++j) {
                        LinkedList<TrackFragmentRandomAccessBox.Entry> linkedList2 = new LinkedList<TrackFragmentRandomAccessBox.Entry>();
                        TrackRunBox trackRunBox = list3.get(j);
                        for (int k = 0; k < trackRunBox.getEntries().size(); ++k) {
                            TrackRunBox.Entry entry = trackRunBox.getEntries().get(k);
                            SampleFlags sampleFlags = null;
                            if (k == 0 && trackRunBox.isFirstSampleFlagsPresent()) {
                                sampleFlags = trackRunBox.getFirstSampleFlags();
                            } else if (trackRunBox.isSampleFlagsPresent()) {
                                sampleFlags = entry.getSampleFlags();
                            } else {
                                List<MovieExtendsBox> list4 = isoFile.getMovieBox().getBoxes(MovieExtendsBox.class);
                                for (MovieExtendsBox movieExtendsBox : list4) {
                                    List<TrackExtendsBox> list5 = movieExtendsBox.getBoxes(TrackExtendsBox.class);
                                    for (TrackExtendsBox trackExtendsBox : list5) {
                                        if (trackExtendsBox.getTrackId() != track.getTrackMetaData().getTrackId()) continue;
                                        sampleFlags = trackExtendsBox.getDefaultSampleFlags();
                                    }
                                }
                            }
                            if (sampleFlags == null) {
                                throw new RuntimeException("Could not find any SampleFlags to indicate random access or not");
                            }
                            if (sampleFlags.getSampleDependsOn() == 2) {
                                linkedList2.add(new TrackFragmentRandomAccessBox.Entry(l2, l, i + 1, j + 1, k + 1));
                            }
                            l2 += entry.getSampleDuration();
                        }
                        if (linkedList2.size() == trackRunBox.getEntries().size() && trackRunBox.getEntries().size() > 0) {
                            linkedList.add((TrackFragmentRandomAccessBox.Entry)linkedList2.get(0));
                            continue;
                        }
                        linkedList.addAll(linkedList2);
                    }
                }
            }
            l += box.getSize();
        }
        trackFragmentRandomAccessBox.setEntries(linkedList);
        trackFragmentRandomAccessBox.setTrackId(track.getTrackMetaData().getTrackId());
        return trackFragmentRandomAccessBox;
    }

    protected Box createMfra(Movie movie, IsoFile isoFile) {
        MovieFragmentRandomAccessBox movieFragmentRandomAccessBox = new MovieFragmentRandomAccessBox();
        for (Track track : movie.getTracks()) {
            movieFragmentRandomAccessBox.addBox(this.createTfra(track, isoFile));
        }
        MovieFragmentRandomAccessOffsetBox movieFragmentRandomAccessOffsetBox = new MovieFragmentRandomAccessOffsetBox();
        movieFragmentRandomAccessBox.addBox(movieFragmentRandomAccessOffsetBox);
        movieFragmentRandomAccessOffsetBox.setMfraSize(movieFragmentRandomAccessBox.getSize());
        return movieFragmentRandomAccessBox;
    }

    protected Box createTrex(Movie movie, Track track) {
        TrackExtendsBox trackExtendsBox = new TrackExtendsBox();
        trackExtendsBox.setTrackId(track.getTrackMetaData().getTrackId());
        trackExtendsBox.setDefaultSampleDescriptionIndex(1L);
        trackExtendsBox.setDefaultSampleDuration(0L);
        trackExtendsBox.setDefaultSampleSize(0L);
        SampleFlags sampleFlags = new SampleFlags();
        if ("soun".equals(track.getHandler())) {
            sampleFlags.setSampleDependsOn(2);
            sampleFlags.setSampleIsDependedOn(2);
        }
        trackExtendsBox.setDefaultSampleFlags(sampleFlags);
        return trackExtendsBox;
    }

    protected Box createMvex(Movie movie) {
        MovieExtendsBox movieExtendsBox = new MovieExtendsBox();
        MovieExtendsHeaderBox movieExtendsHeaderBox = new MovieExtendsHeaderBox();
        for (Track track : movie.getTracks()) {
            long l = this.getTrackDuration(movie, track);
            if (movieExtendsHeaderBox.getFragmentDuration() >= l) continue;
            movieExtendsHeaderBox.setFragmentDuration(l);
        }
        movieExtendsBox.addBox(movieExtendsHeaderBox);
        for (Track track : movie.getTracks()) {
            movieExtendsBox.addBox(this.createTrex(movie, track));
        }
        return movieExtendsBox;
    }

    protected Box createTkhd(Movie movie, Track track) {
        TrackHeaderBox trackHeaderBox = new TrackHeaderBox();
        trackHeaderBox.setVersion(1);
        int n = 0;
        if (track.isEnabled()) {
            ++n;
        }
        if (track.isInMovie()) {
            n += 2;
        }
        if (track.isInPreview()) {
            n += 4;
        }
        if (track.isInPoster()) {
            n += 8;
        }
        trackHeaderBox.setFlags(n);
        trackHeaderBox.setAlternateGroup(track.getTrackMetaData().getGroup());
        trackHeaderBox.setCreationTime(DateHelper.convert(track.getTrackMetaData().getCreationTime()));
        trackHeaderBox.setDuration(this.getTrackDuration(movie, track));
        trackHeaderBox.setHeight(track.getTrackMetaData().getHeight());
        trackHeaderBox.setWidth(track.getTrackMetaData().getWidth());
        trackHeaderBox.setLayer(track.getTrackMetaData().getLayer());
        trackHeaderBox.setModificationTime(DateHelper.convert(new Date()));
        trackHeaderBox.setTrackId(track.getTrackMetaData().getTrackId());
        trackHeaderBox.setVolume(track.getTrackMetaData().getVolume());
        return trackHeaderBox;
    }

    private long getTrackDuration(Movie movie, Track track) {
        return this.getDuration(track) * movie.getTimescale() / track.getTrackMetaData().getTimescale();
    }

    protected Box createMdhd(Movie movie, Track track) {
        MediaHeaderBox mediaHeaderBox = new MediaHeaderBox();
        mediaHeaderBox.setCreationTime(DateHelper.convert(track.getTrackMetaData().getCreationTime()));
        mediaHeaderBox.setDuration(this.getDuration(track));
        mediaHeaderBox.setTimescale(track.getTrackMetaData().getTimescale());
        mediaHeaderBox.setLanguage(track.getTrackMetaData().getLanguage());
        return mediaHeaderBox;
    }

    protected Box createStbl(Movie movie, Track track) {
        SampleTableBox sampleTableBox = new SampleTableBox();
        sampleTableBox.addBox(track.getSampleDescriptionBox());
        sampleTableBox.addBox(new TimeToSampleBox());
        sampleTableBox.addBox(new StaticChunkOffsetBox());
        return sampleTableBox;
    }

    protected Box createMinf(Track track, Movie movie) {
        MediaInformationBox mediaInformationBox = new MediaInformationBox();
        mediaInformationBox.addBox(track.getMediaHeaderBox());
        mediaInformationBox.addBox(this.createDinf(movie, track));
        mediaInformationBox.addBox(this.createStbl(movie, track));
        return mediaInformationBox;
    }

    protected Box createMdiaHdlr(Track track, Movie movie) {
        HandlerBox handlerBox = new HandlerBox();
        handlerBox.setHandlerType(track.getHandler());
        return handlerBox;
    }

    protected Box createMdia(Track track, Movie movie) {
        MediaBox mediaBox = new MediaBox();
        mediaBox.addBox(this.createMdhd(movie, track));
        mediaBox.addBox(this.createMdiaHdlr(track, movie));
        mediaBox.addBox(this.createMinf(track, movie));
        return mediaBox;
    }

    protected Box createTrak(Track track, Movie movie) {
        LOG.fine("Creating Track " + track);
        TrackBox trackBox = new TrackBox();
        trackBox.addBox(this.createTkhd(movie, track));
        trackBox.addBox(this.createMdia(track, movie));
        return trackBox;
    }

    protected DataInformationBox createDinf(Movie movie, Track track) {
        DataInformationBox dataInformationBox = new DataInformationBox();
        DataReferenceBox dataReferenceBox = new DataReferenceBox();
        dataInformationBox.addBox(dataReferenceBox);
        DataEntryUrlBox dataEntryUrlBox = new DataEntryUrlBox();
        dataEntryUrlBox.setFlags(1);
        dataReferenceBox.addBox(dataEntryUrlBox);
        return dataInformationBox;
    }

    public FragmentIntersectionFinder getFragmentIntersectionFinder() {
        return this.intersectionFinder;
    }

    public void setIntersectionFinder(FragmentIntersectionFinder fragmentIntersectionFinder) {
        this.intersectionFinder = fragmentIntersectionFinder;
    }

    protected long getDuration(Track track) {
        long l = 0L;
        for (TimeToSampleBox.Entry entry : track.getDecodingTimeEntries()) {
            l += entry.getCount() * entry.getDelta();
        }
        return l;
    }
}

