/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.apple;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;

public class BaseMediaInfoAtom
extends AbstractFullBox {
    public static final String TYPE = "gmin";
    short graphicsMode = (short)64;
    int opColorR = 32768;
    int opColorG = 32768;
    int opColorB = 32768;
    short balance;
    short reserved;

    public BaseMediaInfoAtom() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        return 16L;
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        byteBuffer.putShort(this.graphicsMode);
        IsoTypeWriter.writeUInt16(byteBuffer, this.opColorR);
        IsoTypeWriter.writeUInt16(byteBuffer, this.opColorG);
        IsoTypeWriter.writeUInt16(byteBuffer, this.opColorB);
        byteBuffer.putShort(this.balance);
        byteBuffer.putShort(this.reserved);
    }

    @Override
    protected void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        this.graphicsMode = byteBuffer.getShort();
        this.opColorR = IsoTypeReader.readUInt16(byteBuffer);
        this.opColorG = IsoTypeReader.readUInt16(byteBuffer);
        this.opColorB = IsoTypeReader.readUInt16(byteBuffer);
        this.balance = byteBuffer.getShort();
        this.reserved = byteBuffer.getShort();
    }

    public short getGraphicsMode() {
        return this.graphicsMode;
    }

    public void setGraphicsMode(short s) {
        this.graphicsMode = s;
    }

    public int getOpColorR() {
        return this.opColorR;
    }

    public void setOpColorR(int n) {
        this.opColorR = n;
    }

    public int getOpColorG() {
        return this.opColorG;
    }

    public void setOpColorG(int n) {
        this.opColorG = n;
    }

    public int getOpColorB() {
        return this.opColorB;
    }

    public void setOpColorB(int n) {
        this.opColorB = n;
    }

    public short getBalance() {
        return this.balance;
    }

    public void setBalance(short s) {
        this.balance = s;
    }

    public short getReserved() {
        return this.reserved;
    }

    public void setReserved(short s) {
        this.reserved = s;
    }

    public String toString() {
        return "BaseMediaInfoAtom{graphicsMode=" + this.graphicsMode + ", opColorR=" + this.opColorR + ", opColorG=" + this.opColorG + ", opColorB=" + this.opColorB + ", balance=" + this.balance + ", reserved=" + this.reserved + '}';
    }
}

