/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.mp4.samplegrouping;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractFullBox;
import com.googlecode.mp4parser.boxes.mp4.samplegrouping.CencSampleEncryptionInformationGroupEntry;
import com.googlecode.mp4parser.boxes.mp4.samplegrouping.GroupEntry;
import com.googlecode.mp4parser.boxes.mp4.samplegrouping.RateShareEntry;
import com.googlecode.mp4parser.boxes.mp4.samplegrouping.RollRecoveryEntry;
import com.googlecode.mp4parser.boxes.mp4.samplegrouping.TemporalLevelEntry;
import com.googlecode.mp4parser.boxes.mp4.samplegrouping.UnknownEntry;
import com.googlecode.mp4parser.boxes.mp4.samplegrouping.VisualRandomAccessEntry;
import com.googlecode.mp4parser.util.CastUtils;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class SampleGroupDescriptionBox
extends AbstractFullBox {
    public static final String TYPE = "sgpd";
    private String groupingType;
    private int defaultLength;
    private List<GroupEntry> groupEntries = new LinkedList<GroupEntry>();
    private int descriptionLength;

    public SampleGroupDescriptionBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        long l = 8L;
        if (this.getVersion() == 1) {
            l += 4L;
        }
        l += 4L;
        for (GroupEntry groupEntry : this.groupEntries) {
            if (this.getVersion() == 1 && this.defaultLength == 0) {
                l += 4L;
            }
            l += (long)groupEntry.size();
        }
        return l;
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        byteBuffer.put(this.groupingType.getBytes());
        if (this.getVersion() == 1) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.defaultLength);
        }
        IsoTypeWriter.writeUInt32(byteBuffer, this.groupEntries.size());
        for (GroupEntry groupEntry : this.groupEntries) {
            if (this.getVersion() == 1 && this.defaultLength == 0) {
                IsoTypeWriter.writeUInt32(byteBuffer, groupEntry.get().limit());
            }
            byteBuffer.put(groupEntry.get());
        }
    }

    @Override
    protected void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        if (this.getVersion() != 1) {
            throw new RuntimeException("SampleGroupDescriptionBox are only supported in version 1");
        }
        this.groupingType = IsoTypeReader.read4cc(byteBuffer);
        if (this.getVersion() == 1) {
            this.defaultLength = CastUtils.l2i(IsoTypeReader.readUInt32(byteBuffer));
        }
        long l = IsoTypeReader.readUInt32(byteBuffer);
        while (l-- > 0L) {
            int n = this.defaultLength;
            if (this.getVersion() == 1) {
                if (this.defaultLength == 0) {
                    n = this.descriptionLength = CastUtils.l2i(IsoTypeReader.readUInt32(byteBuffer));
                }
            } else {
                throw new RuntimeException("This should be implemented");
            }
            int n2 = byteBuffer.position() + n;
            ByteBuffer byteBuffer2 = byteBuffer.slice();
            byteBuffer2.limit(n);
            this.groupEntries.add(this.parseGroupEntry(byteBuffer2, this.groupingType));
            byteBuffer.position(n2);
        }
    }

    private GroupEntry parseGroupEntry(ByteBuffer byteBuffer, String string) {
        GroupEntry groupEntry = "roll".equals(string) ? new RollRecoveryEntry() : ("rash".equals(string) ? new RateShareEntry() : ("seig".equals(string) ? new CencSampleEncryptionInformationGroupEntry() : ("rap ".equals(string) ? new VisualRandomAccessEntry() : ("tele".equals(string) ? new TemporalLevelEntry() : new UnknownEntry()))));
        ((GroupEntry)groupEntry).parse(byteBuffer);
        return groupEntry;
    }

    public String getGroupingType() {
        return this.groupingType;
    }

    public void setGroupingType(String string) {
        this.groupingType = string;
    }

    public int getDefaultLength() {
        return this.defaultLength;
    }

    public void setDefaultLength(int n) {
        this.defaultLength = n;
    }

    public List<GroupEntry> getGroupEntries() {
        return this.groupEntries;
    }

    public void setGroupEntries(List<GroupEntry> list) {
        this.groupEntries = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SampleGroupDescriptionBox sampleGroupDescriptionBox = (SampleGroupDescriptionBox)object;
        if (this.defaultLength != sampleGroupDescriptionBox.defaultLength) {
            return false;
        }
        if (this.groupEntries != null ? !this.groupEntries.equals(sampleGroupDescriptionBox.groupEntries) : sampleGroupDescriptionBox.groupEntries != null) {
            return false;
        }
        return !(this.groupingType != null ? !this.groupingType.equals(sampleGroupDescriptionBox.groupingType) : sampleGroupDescriptionBox.groupingType != null);
    }

    public int hashCode() {
        int n = this.groupingType != null ? this.groupingType.hashCode() : 0;
        n = 31 * n + this.defaultLength;
        n = 31 * n + (this.groupEntries != null ? this.groupEntries.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "SampleGroupDescriptionBox{groupingType='" + this.groupingType + '\'' + ", defaultLength=" + this.defaultLength + ", groupEntries=" + this.groupEntries + '}';
    }
}

