/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.h264.read;

import com.googlecode.mp4parser.h264.CharCache;
import java.io.IOException;
import java.io.InputStream;

public class BitstreamReader {
    private InputStream is;
    private int curByte;
    private int nextByte;
    int nBit;
    protected static int bitsRead;
    protected CharCache debugBits = new CharCache(50);

    public BitstreamReader(InputStream inputStream) throws IOException {
        this.is = inputStream;
        this.curByte = inputStream.read();
        this.nextByte = inputStream.read();
    }

    public int read1Bit() throws IOException {
        if (this.nBit == 8) {
            this.advance();
            if (this.curByte == -1) {
                return -1;
            }
        }
        int n = this.curByte >> 7 - this.nBit & 1;
        ++this.nBit;
        this.debugBits.append(n == 0 ? (char)'0' : '1');
        ++bitsRead;
        return n;
    }

    public long readNBit(int n) throws IOException {
        if (n > 64) {
            throw new IllegalArgumentException("Can not readByte more then 64 bit");
        }
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            l <<= 1;
            l |= (long)this.read1Bit();
        }
        return l;
    }

    private void advance() throws IOException {
        this.curByte = this.nextByte;
        this.nextByte = this.is.read();
        this.nBit = 0;
    }

    public int readByte() throws IOException {
        if (this.nBit > 0) {
            this.advance();
        }
        int n = this.curByte;
        this.advance();
        return n;
    }

    public boolean moreRBSPData() throws IOException {
        int n;
        int n2;
        if (this.nBit == 8) {
            this.advance();
        }
        boolean bl = (this.curByte & (n2 = ((n = 1 << 8 - this.nBit - 1) << 1) - 1)) == n;
        return this.curByte != -1 && (this.nextByte != -1 || !bl);
    }

    public long getBitPosition() {
        return bitsRead * 8 + this.nBit % 8;
    }

    public long readRemainingByte() throws IOException {
        return this.readNBit(8 - this.nBit);
    }

    public int peakNextBits(int n) throws IOException {
        int n2;
        if (n > 8) {
            throw new IllegalArgumentException("N should be less then 8");
        }
        if (this.nBit == 8) {
            this.advance();
            if (this.curByte == -1) {
                return -1;
            }
        }
        int[] nArray = new int[16 - this.nBit];
        int n3 = 0;
        for (n2 = this.nBit; n2 < 8; ++n2) {
            nArray[n3++] = this.curByte >> 7 - n2 & 1;
        }
        for (n2 = 0; n2 < 8; ++n2) {
            nArray[n3++] = this.nextByte >> 7 - n2 & 1;
        }
        n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 <<= 1;
            n2 |= nArray[i];
        }
        return n2;
    }

    public boolean isByteAligned() {
        return this.nBit % 8 == 0;
    }

    public void close() throws IOException {
    }

    public int getCurBit() {
        return this.nBit;
    }
}

