/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.SupportedFileFormat;
import org.jaudiotagger.audio.aiff.AiffFileReader;
import org.jaudiotagger.audio.asf.AsfFileReader;
import org.jaudiotagger.audio.asf.AsfFileWriter;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.audio.flac.FlacFileReader;
import org.jaudiotagger.audio.flac.FlacFileWriter;
import org.jaudiotagger.audio.generic.AudioFileModificationListener;
import org.jaudiotagger.audio.generic.AudioFileReader;
import org.jaudiotagger.audio.generic.AudioFileWriter;
import org.jaudiotagger.audio.generic.ModificationHandler;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp3.MP3FileReader;
import org.jaudiotagger.audio.mp3.MP3FileWriter;
import org.jaudiotagger.audio.mp4.Mp4FileReader;
import org.jaudiotagger.audio.mp4.Mp4FileWriter;
import org.jaudiotagger.audio.ogg.OggFileReader;
import org.jaudiotagger.audio.ogg.OggFileWriter;
import org.jaudiotagger.audio.real.RealFileReader;
import org.jaudiotagger.audio.wav.WavFileReader;
import org.jaudiotagger.audio.wav.WavFileWriter;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.TagException;

public class AudioFileIO {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio");
    private static AudioFileIO defaultInstance;
    private final ModificationHandler modificationHandler;
    private Map<String, AudioFileReader> readers = new HashMap<String, AudioFileReader>();
    private Map<String, AudioFileWriter> writers = new HashMap<String, AudioFileWriter>();

    public static void delete(AudioFile audioFile) throws CannotReadException, CannotWriteException {
        AudioFileIO.getDefaultAudioFileIO().deleteTag(audioFile);
    }

    public static AudioFileIO getDefaultAudioFileIO() {
        if (defaultInstance == null) {
            defaultInstance = new AudioFileIO();
        }
        return defaultInstance;
    }

    public static AudioFile read(File file) throws CannotReadException, IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        return AudioFileIO.getDefaultAudioFileIO().readFile(file);
    }

    public static void write(AudioFile audioFile) throws CannotWriteException {
        AudioFileIO.getDefaultAudioFileIO().writeFile(audioFile);
    }

    public AudioFileIO() {
        this.modificationHandler = new ModificationHandler();
        this.prepareReadersAndWriters();
    }

    public void addAudioFileModificationListener(AudioFileModificationListener audioFileModificationListener) {
        this.modificationHandler.addAudioFileModificationListener(audioFileModificationListener);
    }

    public void deleteTag(AudioFile audioFile) throws CannotReadException, CannotWriteException {
        String string = Utils.getExtension(audioFile.getFile());
        AudioFileWriter audioFileWriter = this.writers.get(string);
        if (audioFileWriter == null) {
            throw new CannotWriteException(ErrorMessage.NO_DELETER_FOR_THIS_FORMAT.getMsg(string));
        }
        audioFileWriter.delete(audioFile);
    }

    private void prepareReadersAndWriters() {
        this.readers.put(SupportedFileFormat.OGG.getFilesuffix(), new OggFileReader());
        this.readers.put(SupportedFileFormat.FLAC.getFilesuffix(), new FlacFileReader());
        this.readers.put(SupportedFileFormat.MP3.getFilesuffix(), new MP3FileReader());
        this.readers.put(SupportedFileFormat.MP4.getFilesuffix(), new Mp4FileReader());
        this.readers.put(SupportedFileFormat.M4A.getFilesuffix(), new Mp4FileReader());
        this.readers.put(SupportedFileFormat.M4P.getFilesuffix(), new Mp4FileReader());
        this.readers.put(SupportedFileFormat.M4B.getFilesuffix(), new Mp4FileReader());
        this.readers.put(SupportedFileFormat.WAV.getFilesuffix(), new WavFileReader());
        this.readers.put(SupportedFileFormat.WMA.getFilesuffix(), new AsfFileReader());
        this.readers.put(SupportedFileFormat.AIF.getFilesuffix(), new AiffFileReader());
        RealFileReader realFileReader = new RealFileReader();
        this.readers.put(SupportedFileFormat.RA.getFilesuffix(), realFileReader);
        this.readers.put(SupportedFileFormat.RM.getFilesuffix(), realFileReader);
        this.writers.put(SupportedFileFormat.OGG.getFilesuffix(), new OggFileWriter());
        this.writers.put(SupportedFileFormat.FLAC.getFilesuffix(), new FlacFileWriter());
        this.writers.put(SupportedFileFormat.MP3.getFilesuffix(), new MP3FileWriter());
        this.writers.put(SupportedFileFormat.MP4.getFilesuffix(), new Mp4FileWriter());
        this.writers.put(SupportedFileFormat.M4A.getFilesuffix(), new Mp4FileWriter());
        this.writers.put(SupportedFileFormat.M4P.getFilesuffix(), new Mp4FileWriter());
        this.writers.put(SupportedFileFormat.M4B.getFilesuffix(), new Mp4FileWriter());
        this.writers.put(SupportedFileFormat.WAV.getFilesuffix(), new WavFileWriter());
        this.writers.put(SupportedFileFormat.WMA.getFilesuffix(), new AsfFileWriter());
        Iterator<AudioFileWriter> iterator = this.writers.values().iterator();
        for (AudioFileWriter audioFileWriter : this.writers.values()) {
            audioFileWriter.setAudioFileModificationListener(this.modificationHandler);
        }
    }

    public AudioFile readFile(File file) throws CannotReadException, IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        this.checkFileExists(file);
        String string = Utils.getExtension(file);
        AudioFileReader audioFileReader = this.readers.get(string);
        if (audioFileReader == null) {
            throw new CannotReadException(ErrorMessage.NO_READER_FOR_THIS_FORMAT.getMsg(string));
        }
        return audioFileReader.read(file);
    }

    public void checkFileExists(File file) throws FileNotFoundException {
        logger.config("Reading file:path" + file.getPath() + ":abs:" + file.getAbsolutePath());
        if (!file.exists()) {
            logger.severe("Unable to find:" + file.getPath());
            throw new FileNotFoundException(ErrorMessage.UNABLE_TO_FIND_FILE.getMsg(file.getPath()));
        }
    }

    public void removeAudioFileModificationListener(AudioFileModificationListener audioFileModificationListener) {
        this.modificationHandler.removeAudioFileModificationListener(audioFileModificationListener);
    }

    public void writeFile(AudioFile audioFile) throws CannotWriteException {
        String string = Utils.getExtension(audioFile.getFile());
        AudioFileWriter audioFileWriter = this.writers.get(string);
        if (audioFileWriter == null) {
            throw new CannotWriteException(ErrorMessage.NO_WRITER_FOR_THIS_FORMAT.getMsg(string));
        }
        audioFileWriter.write(audioFile);
    }
}

