/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.aiff;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.jaudiotagger.audio.aiff.AiffAudioHeader;
import org.jaudiotagger.audio.aiff.AiffUtil;
import org.jaudiotagger.audio.aiff.AnnotationChunk;
import org.jaudiotagger.audio.aiff.ApplicationChunk;
import org.jaudiotagger.audio.aiff.AuthorChunk;
import org.jaudiotagger.audio.aiff.Chunk;
import org.jaudiotagger.audio.aiff.ChunkHeader;
import org.jaudiotagger.audio.aiff.CommentsChunk;
import org.jaudiotagger.audio.aiff.CommonChunk;
import org.jaudiotagger.audio.aiff.CopyrightChunk;
import org.jaudiotagger.audio.aiff.FormatVersionChunk;
import org.jaudiotagger.audio.aiff.ID3Chunk;
import org.jaudiotagger.audio.aiff.NameChunk;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.AudioFileReader;
import org.jaudiotagger.audio.generic.GenericAudioHeader;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.aiff.AiffTag;

public class AiffFileReader
extends AudioFileReader {
    private static final int[] sigByte = new int[]{70, 79, 82, 77};
    private AiffAudioHeader aiffHeader = new AiffAudioHeader();
    private AiffTag aiffTag = new AiffTag();

    public AiffFileReader() {
    }

    public AiffFileReader(RandomAccessFile randomAccessFile) {
    }

    @Override
    protected GenericAudioHeader getEncodingInfo(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        logger.finest("Reading AIFF file ");
        byte[] byArray = new byte[4];
        randomAccessFile.read(byArray);
        for (int i = 0; i < 4; ++i) {
            if (byArray[i] == sigByte[i]) continue;
            logger.finest("AIFF file has incorrect signature");
            throw new CannotReadException("Not an AIFF file: incorrect signature");
        }
        long l = AiffUtil.readUINT32(randomAccessFile);
        if (!this.readFileType(randomAccessFile)) {
            throw new CannotReadException("Invalid AIFF file: Incorrect file type info");
        }
        l -= 4L;
        while (l > 0L && this.readChunk(randomAccessFile, l)) {
        }
        return this.aiffHeader;
    }

    @Override
    protected Tag getTag(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        logger.info("getTag called");
        return this.aiffTag;
    }

    private boolean readFileType(RandomAccessFile randomAccessFile) throws IOException {
        String string = AiffUtil.read4Chars(randomAccessFile);
        if ("AIFF".equals(string)) {
            this.aiffHeader.setFileType(AiffAudioHeader.FileType.AIFFTYPE);
            return true;
        }
        if ("AIFC".equals(string)) {
            this.aiffHeader.setFileType(AiffAudioHeader.FileType.AIFCTYPE);
            return true;
        }
        return false;
    }

    protected boolean readChunk(RandomAccessFile randomAccessFile, long l) throws IOException {
        Chunk chunk = null;
        ChunkHeader chunkHeader = new ChunkHeader();
        if (!chunkHeader.readHeader(randomAccessFile)) {
            return false;
        }
        int n = (int)chunkHeader.getSize();
        l -= (long)(n + 8);
        String string = chunkHeader.getID();
        if ("FVER".equals(string)) {
            chunk = new FormatVersionChunk(chunkHeader, randomAccessFile, this.aiffHeader);
        } else if ("APPL".equals(string)) {
            chunk = new ApplicationChunk(chunkHeader, randomAccessFile, this.aiffHeader);
        } else if ("COMM".equals(string)) {
            chunk = new CommonChunk(chunkHeader, randomAccessFile, this.aiffHeader);
        } else if ("COMT".equals(string)) {
            chunk = new CommentsChunk(chunkHeader, randomAccessFile, this.aiffHeader);
        } else if ("NAME".equals(string)) {
            chunk = new NameChunk(chunkHeader, randomAccessFile, this.aiffHeader);
        } else if ("AUTH".equals(string)) {
            chunk = new AuthorChunk(chunkHeader, randomAccessFile, this.aiffHeader);
        } else if ("(c) ".equals(string)) {
            chunk = new CopyrightChunk(chunkHeader, randomAccessFile, this.aiffHeader);
        } else if ("ANNO".equals(string)) {
            chunk = new AnnotationChunk(chunkHeader, randomAccessFile, this.aiffHeader);
        } else if ("ID3 ".equals(string)) {
            chunk = new ID3Chunk(chunkHeader, randomAccessFile, this.aiffTag);
        }
        if (chunk != null) {
            if (!((Chunk)chunk).readChunk()) {
                return false;
            }
        } else {
            randomAccessFile.skipBytes(n);
        }
        if ((n & 1) != 0) {
            randomAccessFile.skipBytes(1);
            --l;
        }
        return true;
    }
}

