/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.aiff;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.aiff.Chunk;
import org.jaudiotagger.audio.aiff.ChunkHeader;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.aiff.AiffTag;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.ID3v22Tag;
import org.jaudiotagger.tag.id3.ID3v23Tag;
import org.jaudiotagger.tag.id3.ID3v24Tag;

public class ID3Chunk
extends Chunk {
    private AiffTag aiffTag;

    public ID3Chunk(ChunkHeader chunkHeader, RandomAccessFile randomAccessFile, AiffTag aiffTag) {
        super(randomAccessFile, chunkHeader);
        this.aiffTag = aiffTag;
    }

    @Override
    public boolean readChunk() throws IOException {
        AbstractID3v2Tag abstractID3v2Tag;
        if (!this.isId3v2Tag()) {
            return false;
        }
        int n = this.raf.read();
        switch (n) {
            case 2: {
                abstractID3v2Tag = new ID3v22Tag();
                AudioFile.logger.finest("Reading ID3V2.2 tag");
                break;
            }
            case 3: {
                abstractID3v2Tag = new ID3v23Tag();
                AudioFile.logger.finest("Reading ID3V2.3 tag");
                break;
            }
            case 4: {
                abstractID3v2Tag = new ID3v24Tag();
                AudioFile.logger.finest("Reading ID3V2.4 tag");
                break;
            }
            default: {
                return false;
            }
        }
        this.aiffTag.setID3Tag(abstractID3v2Tag);
        this.raf.seek(this.raf.getFilePointer() - 4L);
        byte[] byArray = new byte[(int)this.bytesLeft];
        this.raf.read(byArray);
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)this.bytesLeft);
        byteBuffer.put(byArray);
        try {
            abstractID3v2Tag.read(byteBuffer);
        }
        catch (TagException tagException) {
            AudioFile.logger.info("Exception reading ID3 tag: " + tagException.getClass().getName() + ": " + tagException.getMessage());
            return false;
        }
        return true;
    }

    public void parse(byte[] byArray, AiffTag aiffTag) throws IOException, CannotReadException {
    }

    private boolean isId3v2Tag() throws IOException {
        byte[] byArray = new byte[3];
        this.raf.read(byArray);
        String string = new String(byArray, "ASCII");
        return "ID3".equals(string);
    }
}

