/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.data.StreamChunk;
import org.jaudiotagger.audio.asf.util.Utils;

public final class AudioStreamChunk
extends StreamChunk {
    public static final String[][] CODEC_DESCRIPTIONS = new String[][]{{"161", " (Windows Media Audio (ver 7,8,9))"}, {"162", " (Windows Media Audio 9 series (Professional))"}, {"163", "(Windows Media Audio 9 series (Lossless))"}, {"7A21", " (GSM-AMR (CBR))"}, {"7A22", " (GSM-AMR (VBR))"}};
    public static final long WMA = 353L;
    public static final long WMA_CBR = 31265L;
    public static final long WMA_LOSSLESS = 355L;
    public static final long WMA_PRO = 354L;
    public static final long WMA_VBR = 31266L;
    private long averageBytesPerSec;
    private int bitsPerSample;
    private long blockAlignment;
    private long channelCount;
    private byte[] codecData = new byte[0];
    private long compressionFormat;
    private GUID errorConcealment;
    private long samplingRate;

    public AudioStreamChunk(BigInteger bigInteger) {
        super(GUID.GUID_AUDIOSTREAM, bigInteger);
    }

    public long getAverageBytesPerSec() {
        return this.averageBytesPerSec;
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    public long getBlockAlignment() {
        return this.blockAlignment;
    }

    public long getChannelCount() {
        return this.channelCount;
    }

    public byte[] getCodecData() {
        return (byte[])this.codecData.clone();
    }

    public String getCodecDescription() {
        StringBuilder stringBuilder = new StringBuilder(Long.toHexString(this.getCompressionFormat()));
        String string = " (Unknown)";
        for (String[] stringArray : CODEC_DESCRIPTIONS) {
            if (!stringArray[0].equalsIgnoreCase(stringBuilder.toString())) continue;
            string = stringArray[1];
            break;
        }
        if (stringBuilder.length() % 2 == 0) {
            stringBuilder.insert(0, "0x");
        } else {
            stringBuilder.insert(0, "0x0");
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public long getCompressionFormat() {
        return this.compressionFormat;
    }

    public GUID getErrorConcealment() {
        return this.errorConcealment;
    }

    public int getKbps() {
        return (int)this.getAverageBytesPerSec() * 8 / 1000;
    }

    public long getSamplingRate() {
        return this.samplingRate;
    }

    public boolean isErrorConcealed() {
        return this.getErrorConcealment().equals(GUID.GUID_AUDIO_ERROR_CONCEALEMENT_INTERLEAVED);
    }

    @Override
    public String prettyPrint(String string) {
        StringBuilder stringBuilder = new StringBuilder(super.prettyPrint(string));
        stringBuilder.append(string).append("  |-> Audio info:").append(Utils.LINE_SEPARATOR);
        stringBuilder.append(string).append("  |  : Bitrate : ").append(this.getKbps()).append(Utils.LINE_SEPARATOR);
        stringBuilder.append(string).append("  |  : Channels : ").append(this.getChannelCount()).append(" at ").append(this.getSamplingRate()).append(" Hz").append(Utils.LINE_SEPARATOR);
        stringBuilder.append(string).append("  |  : Bits per Sample: ").append(this.getBitsPerSample()).append(Utils.LINE_SEPARATOR);
        stringBuilder.append(string).append("  |  : Formatcode: ").append(this.getCodecDescription()).append(Utils.LINE_SEPARATOR);
        return stringBuilder.toString();
    }

    public void setAverageBytesPerSec(long l) {
        this.averageBytesPerSec = l;
    }

    public void setBitsPerSample(int n) {
        this.bitsPerSample = n;
    }

    public void setBlockAlignment(long l) {
        this.blockAlignment = l;
    }

    public void setChannelCount(long l) {
        this.channelCount = l;
    }

    public void setCodecData(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException();
        }
        this.codecData = (byte[])byArray.clone();
    }

    public void setCompressionFormat(long l) {
        this.compressionFormat = l;
    }

    public void setErrorConcealment(GUID gUID) {
        this.errorConcealment = gUID;
    }

    public void setSamplingRate(long l) {
        this.samplingRate = l;
    }
}

