/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.asf.data.ContainerType;
import org.jaudiotagger.audio.asf.data.MetadataContainer;
import org.jaudiotagger.audio.asf.data.MetadataDescriptor;
import org.jaudiotagger.audio.asf.util.Utils;

public final class ContentDescription
extends MetadataContainer {
    public static final Set<String> ALLOWED = new HashSet<String>(Arrays.asList("AUTHOR", "COPYRIGHT", "DESCRIPTION", "RATING", "TITLE"));
    public static final String KEY_AUTHOR = "AUTHOR";
    public static final String KEY_COPYRIGHT = "COPYRIGHT";
    public static final String KEY_DESCRIPTION = "DESCRIPTION";
    public static final String KEY_RATING = "RATING";
    public static final String KEY_TITLE = "TITLE";

    public ContentDescription() {
        this(0L, BigInteger.ZERO);
    }

    public ContentDescription(long l, BigInteger bigInteger) {
        super(ContainerType.CONTENT_DESCRIPTION, l, bigInteger);
    }

    public String getAuthor() {
        return this.getValueFor(KEY_AUTHOR);
    }

    public String getComment() {
        return this.getValueFor(KEY_DESCRIPTION);
    }

    public String getCopyRight() {
        return this.getValueFor(KEY_COPYRIGHT);
    }

    @Override
    public long getCurrentAsfChunkSize() {
        long l = 44L;
        l += (long)(this.getAuthor().length() * 2);
        l += (long)(this.getComment().length() * 2);
        l += (long)(this.getRating().length() * 2);
        l += (long)(this.getTitle().length() * 2);
        return l += (long)(this.getCopyRight().length() * 2);
    }

    public String getRating() {
        return this.getValueFor(KEY_RATING);
    }

    public String getTitle() {
        return this.getValueFor(KEY_TITLE);
    }

    @Override
    public boolean isAddSupported(MetadataDescriptor metadataDescriptor) {
        return ALLOWED.contains(metadataDescriptor.getName()) && super.isAddSupported(metadataDescriptor);
    }

    @Override
    public String prettyPrint(String string) {
        StringBuilder stringBuilder = new StringBuilder(super.prettyPrint(string));
        stringBuilder.append(string).append("  |->Title      : ").append(this.getTitle()).append(Utils.LINE_SEPARATOR);
        stringBuilder.append(string).append("  |->Author     : ").append(this.getAuthor()).append(Utils.LINE_SEPARATOR);
        stringBuilder.append(string).append("  |->Copyright  : ").append(this.getCopyRight()).append(Utils.LINE_SEPARATOR);
        stringBuilder.append(string).append("  |->Description: ").append(this.getComment()).append(Utils.LINE_SEPARATOR);
        stringBuilder.append(string).append("  |->Rating     :").append(this.getRating()).append(Utils.LINE_SEPARATOR);
        return stringBuilder.toString();
    }

    public void setAuthor(String string) throws IllegalArgumentException {
        this.setStringValue(KEY_AUTHOR, string);
    }

    public void setComment(String string) throws IllegalArgumentException {
        this.setStringValue(KEY_DESCRIPTION, string);
    }

    public void setCopyright(String string) throws IllegalArgumentException {
        this.setStringValue(KEY_COPYRIGHT, string);
    }

    public void setRating(String string) throws IllegalArgumentException {
        this.setStringValue(KEY_RATING, string);
    }

    public void setTitle(String string) throws IllegalArgumentException {
        this.setStringValue(KEY_TITLE, string);
    }

    @Override
    public long writeInto(OutputStream outputStream) throws IOException {
        long l = this.getCurrentAsfChunkSize();
        outputStream.write(this.getGuid().getBytes());
        Utils.writeUINT64(this.getCurrentAsfChunkSize(), outputStream);
        Utils.writeUINT16(this.getTitle().length() * 2 + 2, outputStream);
        Utils.writeUINT16(this.getAuthor().length() * 2 + 2, outputStream);
        Utils.writeUINT16(this.getCopyRight().length() * 2 + 2, outputStream);
        Utils.writeUINT16(this.getComment().length() * 2 + 2, outputStream);
        Utils.writeUINT16(this.getRating().length() * 2 + 2, outputStream);
        outputStream.write(Utils.getBytes(this.getTitle(), AsfHeader.ASF_CHARSET));
        outputStream.write(AsfHeader.ZERO_TERM);
        outputStream.write(Utils.getBytes(this.getAuthor(), AsfHeader.ASF_CHARSET));
        outputStream.write(AsfHeader.ZERO_TERM);
        outputStream.write(Utils.getBytes(this.getCopyRight(), AsfHeader.ASF_CHARSET));
        outputStream.write(AsfHeader.ZERO_TERM);
        outputStream.write(Utils.getBytes(this.getComment(), AsfHeader.ASF_CHARSET));
        outputStream.write(AsfHeader.ZERO_TERM);
        outputStream.write(Utils.getBytes(this.getRating(), AsfHeader.ASF_CHARSET));
        outputStream.write(AsfHeader.ZERO_TERM);
        return l;
    }
}

