/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.io.ChunkModifier;
import org.jaudiotagger.audio.asf.io.ModificationResult;
import org.jaudiotagger.audio.asf.util.Utils;

public class AsfStreamer {
    private void copyChunk(GUID gUID, InputStream inputStream, OutputStream outputStream) throws IOException {
        long l = Utils.readUINT64(inputStream);
        outputStream.write(gUID.getBytes());
        Utils.writeUINT64(l, outputStream);
        Utils.copy(inputStream, outputStream, l - 24L);
    }

    public void createModifiedCopy(InputStream inputStream, OutputStream outputStream, List<ChunkModifier> list) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream;
        byte[] byArray2;
        long l;
        long l2;
        long l3;
        long l4;
        GUID gUID;
        ArrayList<ChunkModifier> arrayList = new ArrayList<ChunkModifier>();
        if (list != null) {
            arrayList.addAll(list);
        }
        if (GUID.GUID_HEADER.equals(gUID = Utils.readGUID(inputStream))) {
            Object object;
            l4 = 0L;
            l3 = 0L;
            l2 = Utils.readUINT64(inputStream);
            l = Utils.readUINT32(inputStream);
            byArray2 = new byte[]{(byte)(inputStream.read() & 0xFF), (byte)(inputStream.read() & 0xFF)};
            byteArrayOutputStream = new ByteArrayOutputStream();
            byArray = null;
            for (long i = 0L; i < l; ++i) {
                object = Utils.readGUID(inputStream);
                if (GUID.GUID_FILE.equals(object)) {
                    ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                    long l5 = Utils.readUINT64(inputStream);
                    Utils.writeUINT64(l5, byteArrayOutputStream2);
                    Utils.copy(inputStream, byteArrayOutputStream2, l5 - 24L);
                    byArray = byteArrayOutputStream2.toByteArray();
                    continue;
                }
                boolean bl = false;
                for (int j = 0; j < arrayList.size() && !bl; ++j) {
                    if (!((ChunkModifier)arrayList.get(j)).isApplicable((GUID)object)) continue;
                    ModificationResult modificationResult = ((ChunkModifier)arrayList.get(j)).modify((GUID)object, inputStream, byteArrayOutputStream);
                    l3 += (long)modificationResult.getChunkCountDifference();
                    l4 += modificationResult.getByteDifference();
                    arrayList.remove(j);
                    bl = true;
                }
                if (bl) continue;
                this.copyChunk((GUID)object, inputStream, byteArrayOutputStream);
            }
            for (ChunkModifier chunkModifier : arrayList) {
                object = chunkModifier.modify(null, null, byteArrayOutputStream);
                l3 += (long)((ModificationResult)object).getChunkCountDifference();
                l4 += ((ModificationResult)object).getByteDifference();
            }
        } else {
            throw new IllegalArgumentException("No ASF header object.");
        }
        outputStream.write(gUID.getBytes());
        Utils.writeUINT64(l2 + l4, outputStream);
        Utils.writeUINT32(l + l3, outputStream);
        outputStream.write(byArray2);
        this.modifyFileHeader(new ByteArrayInputStream(byArray), outputStream, l4);
        outputStream.write(byteArrayOutputStream.toByteArray());
        Utils.flush(inputStream, outputStream);
    }

    private void modifyFileHeader(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        outputStream.write(GUID.GUID_FILE.getBytes());
        long l2 = Utils.readUINT64(inputStream);
        Utils.writeUINT64(l2, outputStream);
        outputStream.write(Utils.readGUID(inputStream).getBytes());
        long l3 = Utils.readUINT64(inputStream);
        Utils.writeUINT64(l3 + l, outputStream);
        Utils.copy(inputStream, outputStream, l2 - 48L);
    }
}

