/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jaudiotagger.audio.asf.data.GUID;

final class ModificationResult {
    private final long byteDifference;
    private final int chunkDifference;
    private final Set<GUID> occuredGUIDs = new HashSet<GUID>();

    public ModificationResult(int n, long l, GUID ... gUIDArray) {
        assert (gUIDArray != null && gUIDArray.length > 0);
        this.chunkDifference = n;
        this.byteDifference = l;
        this.occuredGUIDs.addAll(Arrays.asList(gUIDArray));
    }

    public ModificationResult(int n, long l, Set<GUID> set) {
        this.chunkDifference = n;
        this.byteDifference = l;
        this.occuredGUIDs.addAll(set);
    }

    public long getByteDifference() {
        return this.byteDifference;
    }

    public int getChunkCountDifference() {
        return this.chunkDifference;
    }

    public Set<GUID> getOccuredGUIDs() {
        return new HashSet<GUID>(this.occuredGUIDs);
    }
}

