/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.generic;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.exceptions.ModifyVetoException;
import org.jaudiotagger.audio.generic.AudioFileModificationListener;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.Tag;

public abstract class AudioFileWriter {
    private static final String TEMP_FILENAME_SUFFIX = ".tmp";
    private static final String WRITE_MODE = "rws";
    private static final int MINIMUM_FILESIZE = 150;
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.generic");
    private static final String FILE_NAME_TOO_LONG = "File name too long";
    private static final String FILE_NAME_TOO_LONG2 = "The filename, directory name, or volume label syntax is incorrect";
    private static final int FILE_NAME_TOO_LONG_SAFE_LIMIT = 50;
    private AudioFileModificationListener modificationListener = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(AudioFile audioFile) throws CannotReadException, CannotWriteException {
        File file2;
        block29: {
            if (!audioFile.getFile().canWrite()) {
                throw new CannotWriteException(ErrorMessage.GENERAL_DELETE_FAILED.getMsg(audioFile.getFile().getPath()));
            }
            if (audioFile.getFile().length() <= 150L) {
                throw new CannotWriteException(ErrorMessage.GENERAL_DELETE_FAILED.getMsg(audioFile.getFile().getPath()));
            }
            RandomAccessFile randomAccessFile = null;
            RandomAccessFile randomAccessFile2 = null;
            File file = null;
            boolean bl = false;
            try {
                file = File.createTempFile(audioFile.getFile().getName().replace('.', '_'), TEMP_FILENAME_SUFFIX, audioFile.getFile().getParentFile());
                randomAccessFile2 = new RandomAccessFile(file, WRITE_MODE);
                randomAccessFile = new RandomAccessFile(audioFile.getFile(), WRITE_MODE);
                randomAccessFile.seek(0L);
                randomAccessFile2.seek(0L);
                try {
                    if (this.modificationListener != null) {
                        this.modificationListener.fileWillBeModified(audioFile, true);
                    }
                    this.deleteTag(randomAccessFile, randomAccessFile2);
                    if (this.modificationListener != null) {
                        this.modificationListener.fileModified(audioFile, file);
                    }
                }
                catch (ModifyVetoException modifyVetoException) {
                    throw new CannotWriteException(modifyVetoException);
                }
                file2 = audioFile.getFile();
            }
            catch (Exception exception) {
                try {
                    bl = true;
                    throw new CannotWriteException("\"" + audioFile.getFile().getAbsolutePath() + "\" :" + exception, exception);
                }
                catch (Throwable throwable) {
                    File file3;
                    block28: {
                        file3 = audioFile.getFile();
                        try {
                            if (randomAccessFile != null) {
                                randomAccessFile.close();
                            }
                            if (randomAccessFile2 != null) {
                                randomAccessFile2.close();
                            }
                            if (file.length() > 0L && !bl) {
                                boolean bl4 = audioFile.getFile().delete();
                                if (!bl4) {
                                    logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_DELETE_ORIGINAL_FILE.getMsg(audioFile.getFile().getPath(), file.getPath()));
                                    throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_DELETE_ORIGINAL_FILE.getMsg(audioFile.getFile().getPath(), file.getPath()));
                                }
                                boolean bl5 = file.renameTo(audioFile.getFile());
                                if (!bl5) {
                                    logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_TO_ORIGINAL_FILE.getMsg(audioFile.getFile().getPath(), file.getPath()));
                                    throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_TO_ORIGINAL_FILE.getMsg(audioFile.getFile().getPath(), file.getPath()));
                                }
                                file3 = file;
                                if (file.exists() && !file.delete()) {
                                    logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_DELETE_TEMPORARY_FILE.getMsg(file.getPath()));
                                }
                                break block28;
                            }
                            if (!file.delete()) {
                                logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_DELETE_TEMPORARY_FILE.getMsg(file.getPath()));
                            }
                        }
                        catch (Exception exception2) {
                            logger.severe("AudioFileWriter exception cleaning up delete:" + audioFile.getFile().getPath() + " or" + file.getAbsolutePath() + ":" + exception2);
                        }
                    }
                    if (this.modificationListener == null) throw throwable;
                    this.modificationListener.fileOperationFinished(file3);
                    throw throwable;
                }
            }
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                if (randomAccessFile2 != null) {
                    randomAccessFile2.close();
                }
                if (file.length() > 0L && !bl) {
                    boolean bl2 = audioFile.getFile().delete();
                    if (!bl2) {
                        logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_DELETE_ORIGINAL_FILE.getMsg(audioFile.getFile().getPath(), file.getPath()));
                        throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_DELETE_ORIGINAL_FILE.getMsg(audioFile.getFile().getPath(), file.getPath()));
                    }
                    boolean bl3 = file.renameTo(audioFile.getFile());
                    if (!bl3) {
                        logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_TO_ORIGINAL_FILE.getMsg(audioFile.getFile().getPath(), file.getPath()));
                        throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_TO_ORIGINAL_FILE.getMsg(audioFile.getFile().getPath(), file.getPath()));
                    }
                    file2 = file;
                    if (file.exists() && !file.delete()) {
                        logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_DELETE_TEMPORARY_FILE.getMsg(file.getPath()));
                    }
                    break block29;
                }
                if (!file.delete()) {
                    logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_DELETE_TEMPORARY_FILE.getMsg(file.getPath()));
                }
            }
            catch (Exception exception) {
                logger.severe("AudioFileWriter exception cleaning up delete:" + audioFile.getFile().getPath() + " or" + file.getAbsolutePath() + ":" + exception);
            }
        }
        if (this.modificationListener == null) return;
        this.modificationListener.fileOperationFinished(file2);
    }

    public void delete(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2) throws CannotReadException, CannotWriteException, IOException {
        randomAccessFile.seek(0L);
        randomAccessFile2.seek(0L);
        this.deleteTag(randomAccessFile, randomAccessFile2);
    }

    protected abstract void deleteTag(RandomAccessFile var1, RandomAccessFile var2) throws CannotReadException, CannotWriteException, IOException;

    public void setAudioFileModificationListener(AudioFileModificationListener audioFileModificationListener) {
        this.modificationListener = audioFileModificationListener;
    }

    private void precheckWrite(AudioFile audioFile) throws CannotWriteException {
        try {
            if (audioFile.getTag().isEmpty()) {
                this.delete(audioFile);
                return;
            }
        }
        catch (CannotReadException cannotReadException) {
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED.getMsg(audioFile.getFile().getPath()));
        }
        if (!audioFile.getFile().canWrite()) {
            logger.severe(ErrorMessage.GENERAL_WRITE_FAILED.getMsg(audioFile.getFile().getPath()));
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED.getMsg(audioFile.getFile().getPath()));
        }
        if (audioFile.getFile().length() <= 150L) {
            logger.severe(ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE_FILE_IS_TOO_SMALL.getMsg(audioFile.getFile().getPath()));
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE_FILE_IS_TOO_SMALL.getMsg(audioFile.getFile().getPath()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(AudioFile audioFile) throws CannotWriteException {
        File file;
        logger.config("Started writing tag data for file:" + audioFile.getFile().getName());
        this.precheckWrite(audioFile);
        if (audioFile instanceof MP3File) {
            audioFile.commit();
            return;
        }
        RandomAccessFile randomAccessFile = null;
        RandomAccessFile randomAccessFile2 = null;
        try {
            file = File.createTempFile(audioFile.getFile().getName().replace('.', '_'), TEMP_FILENAME_SUFFIX, audioFile.getFile().getParentFile());
        }
        catch (IOException iOException) {
            if (iOException.getMessage().equals(FILE_NAME_TOO_LONG) && audioFile.getFile().getName().length() > 50) {
                try {
                    file = File.createTempFile(audioFile.getFile().getName().substring(0, 50).replace('.', '_'), TEMP_FILENAME_SUFFIX, audioFile.getFile().getParentFile());
                }
                catch (IOException iOException2) {
                    logger.log(Level.SEVERE, ErrorMessage.GENERAL_WRITE_FAILED_TO_CREATE_TEMPORARY_FILE_IN_FOLDER.getMsg(audioFile.getFile().getName(), audioFile.getFile().getParentFile().getAbsolutePath()), iOException2);
                    throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_CREATE_TEMPORARY_FILE_IN_FOLDER.getMsg(audioFile.getFile().getName(), audioFile.getFile().getParentFile().getAbsolutePath()));
                }
            }
            logger.log(Level.SEVERE, ErrorMessage.GENERAL_WRITE_FAILED_TO_CREATE_TEMPORARY_FILE_IN_FOLDER.getMsg(audioFile.getFile().getName(), audioFile.getFile().getParentFile().getAbsolutePath()), iOException);
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_CREATE_TEMPORARY_FILE_IN_FOLDER.getMsg(audioFile.getFile().getName(), audioFile.getFile().getParentFile().getAbsolutePath()));
        }
        try {
            randomAccessFile2 = new RandomAccessFile(file, WRITE_MODE);
            randomAccessFile = new RandomAccessFile(audioFile.getFile(), WRITE_MODE);
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(audioFile.getFile().getAbsolutePath()), iOException);
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                if (randomAccessFile2 != null) {
                    randomAccessFile2.close();
                }
            }
            catch (IOException iOException3) {
                logger.log(Level.WARNING, ErrorMessage.GENERAL_WRITE_PROBLEM_CLOSING_FILE_HANDLE.getMsg(audioFile.getFile(), iOException.getMessage()), iOException3);
            }
            if (!file.delete()) {
                logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_DELETE_TEMPORARY_FILE.getMsg(file.getAbsolutePath()));
            }
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(audioFile.getFile().getAbsolutePath()));
        }
        try {
            randomAccessFile.seek(0L);
            randomAccessFile2.seek(0L);
            try {
                if (this.modificationListener != null) {
                    this.modificationListener.fileWillBeModified(audioFile, false);
                }
                this.writeTag(audioFile.getTag(), randomAccessFile, randomAccessFile2);
                if (this.modificationListener != null) {
                    this.modificationListener.fileModified(audioFile, file);
                }
            }
            catch (ModifyVetoException modifyVetoException) {
                throw new CannotWriteException(modifyVetoException);
            }
        }
        catch (Exception exception) {
            try {
                logger.log(Level.SEVERE, ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE.getMsg(audioFile.getFile(), exception.getMessage()), exception);
                try {
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                    if (randomAccessFile2 != null) {
                        randomAccessFile2.close();
                    }
                }
                catch (IOException iOException) {
                    logger.log(Level.WARNING, ErrorMessage.GENERAL_WRITE_PROBLEM_CLOSING_FILE_HANDLE.getMsg(audioFile.getFile().getAbsolutePath(), iOException.getMessage()), iOException);
                }
                if (!file.delete()) {
                    logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_DELETE_TEMPORARY_FILE.getMsg(file.getAbsolutePath()));
                }
                throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE.getMsg(audioFile.getFile(), exception.getMessage()));
            }
            catch (Throwable throwable) {
                try {
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                    if (randomAccessFile2 == null) throw throwable;
                    randomAccessFile2.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    logger.log(Level.WARNING, ErrorMessage.GENERAL_WRITE_PROBLEM_CLOSING_FILE_HANDLE.getMsg(audioFile.getFile().getAbsolutePath(), iOException.getMessage()), iOException);
                }
                throw throwable;
            }
        }
        try {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
            if (randomAccessFile2 != null) {
                randomAccessFile2.close();
            }
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, ErrorMessage.GENERAL_WRITE_PROBLEM_CLOSING_FILE_HANDLE.getMsg(audioFile.getFile().getAbsolutePath(), iOException.getMessage()), iOException);
        }
        File file2 = audioFile.getFile();
        if (file.length() > 0L) {
            File file3 = new File(audioFile.getFile().getAbsoluteFile().getParentFile().getPath(), AudioFile.getBaseFilename(audioFile.getFile()) + ".old");
            int n = 1;
            while (file3.exists()) {
                file3 = new File(audioFile.getFile().getAbsoluteFile().getParentFile().getPath(), AudioFile.getBaseFilename(audioFile.getFile()) + ".old" + n);
                ++n;
            }
            boolean bl = Utils.rename(audioFile.getFile(), file3);
            if (!bl) {
                logger.log(Level.SEVERE, ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_ORIGINAL_FILE_TO_BACKUP.getMsg(audioFile.getFile().getAbsolutePath(), file3.getName()));
                if (file != null) {
                    file.delete();
                }
                throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_ORIGINAL_FILE_TO_BACKUP.getMsg(audioFile.getFile().getPath(), file3.getName()));
            }
            bl = Utils.rename(file, audioFile.getFile());
            if (!bl) {
                if (!file.exists()) {
                    logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_NEW_FILE_DOESNT_EXIST.getMsg(file.getAbsolutePath()));
                }
                if (!file3.renameTo(audioFile.getFile())) {
                    logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_ORIGINAL_BACKUP_TO_ORIGINAL.getMsg(file3.getAbsolutePath(), audioFile.getFile().getName()));
                }
                logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_TO_ORIGINAL_FILE.getMsg(audioFile.getFile().getAbsolutePath(), file.getName()));
                throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_TO_ORIGINAL_FILE.getMsg(audioFile.getFile().getAbsolutePath(), file.getName()));
            }
            boolean bl2 = file3.delete();
            if (!bl2) {
                logger.warning(ErrorMessage.GENERAL_WRITE_WARNING_UNABLE_TO_DELETE_BACKUP_FILE.getMsg(file3.getAbsolutePath()));
            }
            if (file.exists() && !file.delete()) {
                logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_DELETE_TEMPORARY_FILE.getMsg(file.getPath()));
            }
        } else if (!file.delete()) {
            logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_DELETE_TEMPORARY_FILE.getMsg(file.getPath()));
        }
        if (this.modificationListener == null) return;
        this.modificationListener.fileOperationFinished(file2);
    }

    protected abstract void writeTag(Tag var1, RandomAccessFile var2, RandomAccessFile var3) throws CannotReadException, CannotWriteException, IOException;
}

