/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.generic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jaudiotagger.audio.generic.AbstractTag;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagTextField;
import org.jaudiotagger.tag.images.Artwork;

public abstract class GenericTag
extends AbstractTag {
    private static EnumSet<FieldKey> supportedKeys = EnumSet.of(FieldKey.ALBUM, new FieldKey[]{FieldKey.ARTIST, FieldKey.TITLE, FieldKey.TRACK, FieldKey.GENRE, FieldKey.COMMENT, FieldKey.YEAR});

    @Override
    protected boolean isAllowedEncoding(String string) {
        return true;
    }

    @Override
    public TagField createField(FieldKey fieldKey, String string) throws KeyNotFoundException, FieldDataInvalidException {
        if (supportedKeys.contains((Object)fieldKey)) {
            return new GenericTagTextField(fieldKey.name(), string);
        }
        throw new UnsupportedOperationException(ErrorMessage.GENERIC_NOT_SUPPORTED.getMsg());
    }

    @Override
    public String getFirst(FieldKey fieldKey) throws KeyNotFoundException {
        return this.getValue(fieldKey, 0);
    }

    @Override
    public String getValue(FieldKey fieldKey, int n) throws KeyNotFoundException {
        if (supportedKeys.contains((Object)fieldKey)) {
            return this.getItem(fieldKey.name(), n);
        }
        throw new UnsupportedOperationException(ErrorMessage.GENERIC_NOT_SUPPORTED.getMsg());
    }

    @Override
    public List<TagField> getFields(FieldKey fieldKey) throws KeyNotFoundException {
        List list = (List)this.fields.get(fieldKey.name());
        if (list == null) {
            return new ArrayList<TagField>();
        }
        return list;
    }

    @Override
    public List<String> getAll(FieldKey fieldKey) throws KeyNotFoundException {
        return super.getAll(fieldKey.name());
    }

    @Override
    public void deleteField(FieldKey fieldKey) throws KeyNotFoundException {
        if (!supportedKeys.contains((Object)fieldKey)) {
            throw new UnsupportedOperationException(ErrorMessage.GENERIC_NOT_SUPPORTED.getMsg());
        }
        this.deleteField(fieldKey.name());
    }

    @Override
    public TagField getFirstField(FieldKey fieldKey) throws KeyNotFoundException {
        if (supportedKeys.contains((Object)fieldKey)) {
            return this.getFirstField(fieldKey.name());
        }
        throw new UnsupportedOperationException(ErrorMessage.GENERIC_NOT_SUPPORTED.getMsg());
    }

    @Override
    public List<Artwork> getArtworkList() {
        return Collections.emptyList();
    }

    @Override
    public TagField createField(Artwork artwork) throws FieldDataInvalidException {
        throw new UnsupportedOperationException(ErrorMessage.GENERIC_NOT_SUPPORTED.getMsg());
    }

    private class GenericTagTextField
    implements TagTextField {
        private String content;
        private final String id;

        public GenericTagTextField(String string, String string2) {
            this.id = string;
            this.content = string2;
        }

        @Override
        public void copyContent(TagField tagField) {
            if (tagField instanceof TagTextField) {
                this.content = ((TagTextField)tagField).getContent();
            }
        }

        @Override
        public String getContent() {
            return this.content;
        }

        @Override
        public String getEncoding() {
            return "ISO-8859-1";
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public byte[] getRawContent() {
            return this.content == null ? new byte[]{} : Utils.getDefaultBytes(this.content, this.getEncoding());
        }

        @Override
        public boolean isBinary() {
            return false;
        }

        @Override
        public void isBinary(boolean bl) {
        }

        @Override
        public boolean isCommon() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.content.equals("");
        }

        @Override
        public void setContent(String string) {
            this.content = string;
        }

        @Override
        public void setEncoding(String string) {
        }

        @Override
        public String toString() {
            return this.getContent();
        }
    }
}

