/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp3;

import java.nio.ByteBuffer;
import org.jaudiotagger.audio.generic.Utils;

public class LameFrame {
    public static final int LAME_HEADER_BUFFER_SIZE = 36;
    public static final int ENCODER_SIZE = 9;
    public static final int LAME_ID_SIZE = 4;
    public static final String LAME_ID = "LAME";
    private String encoder;

    private LameFrame(ByteBuffer byteBuffer) {
        this.encoder = Utils.getString(byteBuffer, 0, 9, "ISO-8859-1");
    }

    public static LameFrame parseLameFrame(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        String string = Utils.getString(byteBuffer2, 0, 4, "ISO-8859-1");
        byteBuffer2.rewind();
        if (string.equals(LAME_ID)) {
            LameFrame lameFrame = new LameFrame(byteBuffer2);
            return lameFrame;
        }
        return null;
    }

    public String getEncoder() {
        return this.encoder;
    }
}

