/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp3;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaudiotagger.audio.AudioHeader;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.mp3.MPEGFrameHeader;
import org.jaudiotagger.audio.mp3.VbriFrame;
import org.jaudiotagger.audio.mp3.XingFrame;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.logging.Hex;

public class MP3AudioHeader
implements AudioHeader {
    protected MPEGFrameHeader mp3FrameHeader;
    protected XingFrame mp3XingFrame;
    protected VbriFrame mp3VbriFrame;
    private long fileSize;
    private long startByte;
    private double timePerFrame;
    private double trackLength;
    private long numberOfFrames;
    private long numberOfFramesEstimate;
    private long bitrate;
    private String encoder = "";
    private static final SimpleDateFormat timeInFormat = new SimpleDateFormat("ss", Locale.UK);
    private static final SimpleDateFormat timeOutFormat = new SimpleDateFormat("mm:ss", Locale.UK);
    private static final SimpleDateFormat timeOutOverAnHourFormat = new SimpleDateFormat("kk:mm:ss", Locale.UK);
    private static final char isVbrIdentifier = '~';
    private static final int CONVERT_TO_KILOBITS = 1000;
    private static final String TYPE_MP3 = "mp3";
    private static final int CONVERTS_BYTE_TO_BITS = 8;
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.mp3");
    private static final int FILE_BUFFER_SIZE = 5000;
    private static final int MIN_BUFFER_REMAINING_REQUIRED = 196;
    private static final int NO_SECONDS_IN_HOUR = 3600;

    public MP3AudioHeader() {
    }

    public MP3AudioHeader(File file) throws IOException, InvalidAudioFrameException {
        if (!this.seek(file, 0L)) {
            throw new InvalidAudioFrameException("No audio header found within" + file.getName());
        }
    }

    public MP3AudioHeader(File file, long l) throws IOException, InvalidAudioFrameException {
        if (!this.seek(file, l)) {
            throw new InvalidAudioFrameException(ErrorMessage.NO_AUDIO_HEADER_FOUND.getMsg(file.getName()));
        }
    }

    public boolean seek(File file, long l) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileChannel fileChannel = fileInputStream.getChannel();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(5000);
        fileChannel.position(l);
        long l2 = l;
        fileChannel.read(byteBuffer, l);
        byteBuffer.flip();
        boolean bl = false;
        try {
            do {
                block27: {
                    if (byteBuffer.remaining() <= 196) {
                        byteBuffer.clear();
                        fileChannel.position(l2);
                        fileChannel.read(byteBuffer, fileChannel.position());
                        byteBuffer.flip();
                        if (byteBuffer.limit() <= 196) {
                            boolean bl2 = false;
                            return bl2;
                        }
                    }
                    if (MPEGFrameHeader.isMPEGFrame(byteBuffer)) {
                        try {
                            if (logger.isLoggable(Level.FINEST)) {
                                logger.finest("Found Possible header at:" + l2);
                            }
                            this.mp3FrameHeader = MPEGFrameHeader.parseMPEGHeader(byteBuffer);
                            bl = true;
                            ByteBuffer byteBuffer2 = XingFrame.isXingFrame(byteBuffer, this.mp3FrameHeader);
                            if (byteBuffer2 != null) {
                                if (logger.isLoggable(Level.FINEST)) {
                                    logger.finest("Found Possible XingHeader");
                                }
                                try {
                                    this.mp3XingFrame = XingFrame.parseXingFrame(byteBuffer2);
                                }
                                catch (InvalidAudioFrameException invalidAudioFrameException) {}
                                break;
                            }
                            byteBuffer2 = VbriFrame.isVbriFrame(byteBuffer, this.mp3FrameHeader);
                            if (byteBuffer2 != null) {
                                if (logger.isLoggable(Level.FINEST)) {
                                    logger.finest("Found Possible VbriHeader");
                                }
                                try {
                                    this.mp3VbriFrame = VbriFrame.parseVBRIFrame(byteBuffer2);
                                }
                                catch (InvalidAudioFrameException invalidAudioFrameException) {}
                                break;
                            }
                            bl = this.isNextFrameValid(file, l2, byteBuffer, fileChannel);
                            if (!bl) break block27;
                            break;
                        }
                        catch (InvalidAudioFrameException invalidAudioFrameException) {
                            // empty catch block
                        }
                    }
                }
                byteBuffer.position(byteBuffer.position() + 1);
                ++l2;
            } while (!bl);
        }
        catch (EOFException eOFException) {
            logger.log(Level.WARNING, "Reached end of file without finding sync match", eOFException);
            bl = false;
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "IOException occurred whilst trying to find sync", iOException);
            bl = false;
            throw iOException;
        }
        finally {
            if (fileChannel != null) {
                fileChannel.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finer("Return found matching mp3 header starting at" + l2);
        }
        this.setFileSize(file.length());
        this.setMp3StartByte(l2);
        this.setTimePerFrame();
        this.setNumberOfFrames();
        this.setTrackLength();
        this.setBitRate();
        this.setEncoder();
        return bl;
    }

    private boolean isNextFrameValid(File file, long l, ByteBuffer byteBuffer, FileChannel fileChannel) throws IOException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finer("Checking next frame" + file.getName() + ":fpc:" + l + "skipping to:" + (l + (long)this.mp3FrameHeader.getFrameLength()));
        }
        boolean bl = false;
        int n = byteBuffer.position();
        if (this.mp3FrameHeader.getFrameLength() > 4804) {
            logger.finer("Frame size is too large to be a frame:" + this.mp3FrameHeader.getFrameLength());
            return false;
        }
        if (byteBuffer.remaining() <= 196 + this.mp3FrameHeader.getFrameLength()) {
            logger.finer("Buffer too small, need to reload, buffer size:" + byteBuffer.remaining());
            byteBuffer.clear();
            fileChannel.position(l);
            fileChannel.read(byteBuffer, fileChannel.position());
            byteBuffer.flip();
            n = 0;
            if (byteBuffer.limit() <= 196) {
                logger.finer("Nearly at end of file, no header found:");
                return false;
            }
            if (byteBuffer.limit() <= 196 + this.mp3FrameHeader.getFrameLength()) {
                logger.finer("Nearly at end of file, no room for next frame, no header found:");
                return false;
            }
        }
        byteBuffer.position(byteBuffer.position() + this.mp3FrameHeader.getFrameLength());
        if (MPEGFrameHeader.isMPEGFrame(byteBuffer)) {
            try {
                MPEGFrameHeader.parseMPEGHeader(byteBuffer);
                logger.finer("Check next frame confirms is an audio header ");
                bl = true;
            }
            catch (InvalidAudioFrameException invalidAudioFrameException) {
                logger.finer("Check next frame has identified this is not an audio header");
                bl = false;
            }
        } else {
            logger.finer("isMPEGFrame has identified this is not an audio header");
        }
        byteBuffer.position(n);
        return bl;
    }

    protected void setMp3StartByte(long l) {
        this.startByte = l;
    }

    public long getMp3StartByte() {
        return this.startByte;
    }

    protected void setNumberOfFrames() {
        this.numberOfFramesEstimate = (this.fileSize - this.startByte) / (long)this.mp3FrameHeader.getFrameLength();
        this.numberOfFrames = this.mp3XingFrame != null && this.mp3XingFrame.isFrameCountEnabled() ? (long)this.mp3XingFrame.getFrameCount() : (this.mp3VbriFrame != null ? (long)this.mp3VbriFrame.getFrameCount() : this.numberOfFramesEstimate);
    }

    public long getNumberOfFrames() {
        return this.numberOfFrames;
    }

    public long getNumberOfFramesEstimate() {
        return this.numberOfFramesEstimate;
    }

    protected void setTimePerFrame() {
        this.timePerFrame = (double)this.mp3FrameHeader.getNoOfSamples() / this.mp3FrameHeader.getSamplingRate().doubleValue();
    }

    private double getTimePerFrame() {
        return this.timePerFrame;
    }

    protected void setTrackLength() {
        this.trackLength = (double)this.numberOfFrames * this.getTimePerFrame();
    }

    public double getPreciseTrackLength() {
        return this.trackLength;
    }

    @Override
    public int getTrackLength() {
        return (int)this.getPreciseTrackLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTrackLengthAsString() {
        try {
            Date date;
            long l = this.getTrackLength();
            SimpleDateFormat simpleDateFormat = timeInFormat;
            synchronized (simpleDateFormat) {
                date = timeInFormat.parse(String.valueOf(l));
            }
            if (l < 3600L) {
                simpleDateFormat = timeOutFormat;
                synchronized (simpleDateFormat) {
                    return timeOutFormat.format(date);
                }
            }
            simpleDateFormat = timeOutOverAnHourFormat;
            synchronized (simpleDateFormat) {
                return timeOutOverAnHourFormat.format(date);
            }
        }
        catch (ParseException parseException) {
            logger.warning("Unable to parse:" + this.getPreciseTrackLength() + " failed with ParseException:" + parseException.getMessage());
            return "";
        }
    }

    @Override
    public String getEncodingType() {
        return TYPE_MP3;
    }

    protected void setBitRate() {
        this.bitrate = this.mp3XingFrame != null && this.mp3XingFrame.isVbr() ? (this.mp3XingFrame.isAudioSizeEnabled() && this.mp3XingFrame.getAudioSize() > 0 ? (long)((double)(this.mp3XingFrame.getAudioSize() * 8) / (this.timePerFrame * (double)this.getNumberOfFrames() * 1000.0)) : (long)((double)((this.fileSize - this.startByte) * 8L) / (this.timePerFrame * (double)this.getNumberOfFrames() * 1000.0))) : (this.mp3VbriFrame != null ? (this.mp3VbriFrame.getAudioSize() > 0 ? (long)((double)(this.mp3VbriFrame.getAudioSize() * 8) / (this.timePerFrame * (double)this.getNumberOfFrames() * 1000.0)) : (long)((double)((this.fileSize - this.startByte) * 8L) / (this.timePerFrame * (double)this.getNumberOfFrames() * 1000.0))) : (long)this.mp3FrameHeader.getBitRate().intValue());
    }

    protected void setEncoder() {
        if (this.mp3XingFrame != null) {
            if (this.mp3XingFrame.getLameFrame() != null) {
                this.encoder = this.mp3XingFrame.getLameFrame().getEncoder();
            }
        } else if (this.mp3VbriFrame != null) {
            this.encoder = this.mp3VbriFrame.getEncoder();
        }
    }

    @Override
    public long getBitRateAsNumber() {
        return this.bitrate;
    }

    @Override
    public String getBitRate() {
        if (this.mp3XingFrame != null && this.mp3XingFrame.isVbr()) {
            return '~' + String.valueOf(this.bitrate);
        }
        if (this.mp3VbriFrame != null) {
            return '~' + String.valueOf(this.bitrate);
        }
        return String.valueOf(this.bitrate);
    }

    @Override
    public int getSampleRateAsNumber() {
        return this.mp3FrameHeader.getSamplingRate();
    }

    @Override
    public int getBitsPerSample() {
        return 16;
    }

    @Override
    public String getSampleRate() {
        return String.valueOf(this.mp3FrameHeader.getSamplingRate());
    }

    public String getMpegVersion() {
        return this.mp3FrameHeader.getVersionAsString();
    }

    public String getMpegLayer() {
        return this.mp3FrameHeader.getLayerAsString();
    }

    @Override
    public String getFormat() {
        return this.mp3FrameHeader.getVersionAsString() + " " + this.mp3FrameHeader.getLayerAsString();
    }

    @Override
    public String getChannels() {
        return this.mp3FrameHeader.getChannelModeAsString();
    }

    public String getEmphasis() {
        return this.mp3FrameHeader.getEmphasisAsString();
    }

    @Override
    public boolean isVariableBitRate() {
        if (this.mp3XingFrame != null) {
            return this.mp3XingFrame.isVbr();
        }
        if (this.mp3VbriFrame != null) {
            return this.mp3VbriFrame.isVbr();
        }
        return this.mp3FrameHeader.isVariableBitRate();
    }

    public boolean isProtected() {
        return this.mp3FrameHeader.isProtected();
    }

    public boolean isPrivate() {
        return this.mp3FrameHeader.isPrivate();
    }

    public boolean isCopyrighted() {
        return this.mp3FrameHeader.isCopyrighted();
    }

    public boolean isOriginal() {
        return this.mp3FrameHeader.isOriginal();
    }

    public boolean isPadding() {
        return this.mp3FrameHeader.isPadding();
    }

    @Override
    public boolean isLossless() {
        return false;
    }

    public String getEncoder() {
        return this.encoder;
    }

    protected void setFileSize(long l) {
        this.fileSize = l;
    }

    public String toString() {
        String string = "fileSize:" + this.fileSize + " encoder:" + this.encoder + " startByte:" + Hex.asHex(this.startByte) + " numberOfFrames:" + this.numberOfFrames + " numberOfFramesEst:" + this.numberOfFramesEstimate + " timePerFrame:" + this.timePerFrame + " bitrate:" + this.bitrate + " trackLength:" + this.getTrackLengthAsString();
        string = this.mp3FrameHeader != null ? string + this.mp3FrameHeader.toString() : string + " mpegframeheader:false";
        string = this.mp3XingFrame != null ? string + this.mp3XingFrame.toString() : string + " mp3XingFrame:false";
        string = this.mp3VbriFrame != null ? string + this.mp3VbriFrame.toString() : string + " mp3VbriFrame:false";
        return string;
    }
}

