/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp3;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.mp3.LameFrame;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.audio.mp3.MPEGFrameHeader;

public class XingFrame {
    private static final int MPEG_VERSION_1_MODE_MONO_OFFSET = 21;
    private static final int MPEG_VERSION_1_MODE_STEREO_OFFSET = 36;
    private static final int MPEG_VERSION_2_MODE_MONO_OFFSET = 13;
    private static final int MPEG_VERSION_2_MODE_STEREO_OFFSET = 21;
    private static final int XING_HEADER_BUFFER_SIZE = 120;
    private static final int XING_IDENTIFIER_BUFFER_SIZE = 4;
    private static final int XING_FLAG_BUFFER_SIZE = 4;
    private static final int XING_FRAMECOUNT_BUFFER_SIZE = 4;
    private static final int XING_AUDIOSIZE_BUFFER_SIZE = 4;
    public static final int MAX_BUFFER_SIZE_NEEDED_TO_READ_XING = 192;
    private static final int BYTE_1 = 0;
    private static final int BYTE_2 = 1;
    private static final int BYTE_3 = 2;
    private static final int BYTE_4 = 3;
    private static final byte[] XING_VBR_ID = new byte[]{88, 105, 110, 103};
    private static final byte[] XING_CBR_ID = new byte[]{73, 110, 102, 111};
    private ByteBuffer header;
    private boolean vbr = false;
    private boolean isFrameCountEnabled = false;
    private int frameCount = -1;
    private boolean isAudioSizeEnabled = false;
    private int audioSize = -1;
    private LameFrame lameFrame;

    private XingFrame(ByteBuffer byteBuffer) {
        this.header = byteBuffer;
        byteBuffer.rewind();
        this.setVbr();
        byte[] byArray = new byte[4];
        byteBuffer.get(byArray);
        if ((byArray[3] & 1) != 0) {
            this.setFrameCount();
        }
        if ((byArray[3] & 2) != 0) {
            this.setAudioSize();
        }
        if (byteBuffer.limit() >= 156) {
            byteBuffer.position(120);
            this.lameFrame = LameFrame.parseLameFrame(byteBuffer);
        }
    }

    public LameFrame getLameFrame() {
        return this.lameFrame;
    }

    private void setVbr() {
        byte[] byArray = new byte[4];
        this.header.get(byArray);
        if (Arrays.equals(byArray, XING_VBR_ID)) {
            MP3File.logger.finest("Is Vbr");
            this.vbr = true;
        }
    }

    private void setFrameCount() {
        byte[] byArray = new byte[4];
        this.header.get(byArray);
        this.isFrameCountEnabled = true;
        this.frameCount = byArray[0] << 24 & 0xFF000000 | byArray[1] << 16 & 0xFF0000 | byArray[2] << 8 & 0xFF00 | byArray[3] & 0xFF;
    }

    public final boolean isFrameCountEnabled() {
        return this.isFrameCountEnabled;
    }

    public final int getFrameCount() {
        return this.frameCount;
    }

    private void setAudioSize() {
        byte[] byArray = new byte[4];
        this.header.get(byArray);
        this.isAudioSizeEnabled = true;
        this.audioSize = byArray[0] << 24 & 0xFF000000 | byArray[1] << 16 & 0xFF0000 | byArray[2] << 8 & 0xFF00 | byArray[3] & 0xFF;
    }

    public final boolean isAudioSizeEnabled() {
        return this.isAudioSizeEnabled;
    }

    public final int getAudioSize() {
        return this.audioSize;
    }

    public static XingFrame parseXingFrame(ByteBuffer byteBuffer) throws InvalidAudioFrameException {
        XingFrame xingFrame = new XingFrame(byteBuffer);
        return xingFrame;
    }

    public static ByteBuffer isXingFrame(ByteBuffer byteBuffer, MPEGFrameHeader mPEGFrameHeader) {
        int n = byteBuffer.position();
        if (mPEGFrameHeader.getVersion() == 3) {
            if (mPEGFrameHeader.getChannelMode() == 3) {
                byteBuffer.position(n + 21);
            } else {
                byteBuffer.position(n + 36);
            }
        } else if (mPEGFrameHeader.getChannelMode() == 3) {
            byteBuffer.position(n + 13);
        } else {
            byteBuffer.position(n + 21);
        }
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer.position(n);
        byte[] byArray = new byte[4];
        byteBuffer2.get(byArray);
        if (!Arrays.equals(byArray, XING_VBR_ID) && !Arrays.equals(byArray, XING_CBR_ID)) {
            return null;
        }
        MP3File.logger.finest("Found Xing Frame");
        return byteBuffer2;
    }

    public final boolean isVbr() {
        return this.vbr;
    }

    public String toString() {
        return "xingheader vbr:" + this.vbr + " frameCountEnabled:" + this.isFrameCountEnabled + " frameCount:" + this.frameCount + " audioSizeEnabled:" + this.isAudioSizeEnabled + " audioFileSize:" + this.audioSize;
    }
}

