/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.ogg.util;

import java.util.logging.Logger;

public class OggCRCFactory {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.ogg");
    private static long[] crc_lookup = new long[256];
    private static boolean init = false;

    public static void init() {
        for (int i = 0; i < 256; ++i) {
            long l = i << 24;
            for (int j = 0; j < 8; ++j) {
                if ((l & 0x80000000L) != 0L) {
                    l = l << 1 ^ 0x4C11DB7L;
                    continue;
                }
                l <<= 1;
            }
            OggCRCFactory.crc_lookup[i] = l;
        }
        init = true;
    }

    public boolean checkCRC(byte[] byArray, byte[] byArray2) {
        return new String(byArray2).equals(new String(OggCRCFactory.computeCRC(byArray)));
    }

    public static byte[] computeCRC(byte[] byArray) {
        if (!init) {
            OggCRCFactory.init();
        }
        long l = 0L;
        for (byte by : byArray) {
            int n = (int)(l >>> 24 & 0xFFL ^ (long)OggCRCFactory.u(by));
            l = l << 8 ^ crc_lookup[n];
            l &= 0xFFFFFFFFFFFFFFFFL;
        }
        byte[] byArray2 = new byte[]{(byte)(l & 0xFFL), (byte)(l >>> 8 & 0xFFL), (byte)(l >>> 16 & 0xFFL), (byte)(l >>> 24 & 0xFFL)};
        return byArray2;
    }

    private static int u(int n) {
        return n & 0xFF;
    }
}

