/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.ogg.util;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.GenericAudioHeader;
import org.jaudiotagger.audio.ogg.util.OggPageHeader;
import org.jaudiotagger.audio.ogg.util.VorbisIdentificationHeader;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;

public class OggInfoReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.ogg.atom");

    public GenericAudioHeader read(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        Object object;
        Object object2;
        long l = randomAccessFile.getFilePointer();
        GenericAudioHeader genericAudioHeader = new GenericAudioHeader();
        logger.fine("Started");
        byte[] byArray = new byte[OggPageHeader.CAPTURE_PATTERN.length];
        randomAccessFile.read(byArray);
        if (!Arrays.equals(byArray, OggPageHeader.CAPTURE_PATTERN)) {
            randomAccessFile.seek(0L);
            if (AbstractID3v2Tag.isId3Tag(randomAccessFile)) {
                randomAccessFile.read(byArray);
                if (Arrays.equals(byArray, OggPageHeader.CAPTURE_PATTERN)) {
                    l = randomAccessFile.getFilePointer();
                }
            } else {
                throw new CannotReadException(ErrorMessage.OGG_HEADER_CANNOT_BE_FOUND.getMsg(new String(byArray)));
            }
        }
        randomAccessFile.seek(l);
        double d = -1.0;
        randomAccessFile.seek(randomAccessFile.length() - 2L);
        while (randomAccessFile.getFilePointer() >= 4L) {
            if (randomAccessFile.read() == OggPageHeader.CAPTURE_PATTERN[3]) {
                randomAccessFile.seek(randomAccessFile.getFilePointer() - 4L);
                object2 = new byte[3];
                randomAccessFile.readFully((byte[])object2);
                if (object2[0] == OggPageHeader.CAPTURE_PATTERN[0] && object2[1] == OggPageHeader.CAPTURE_PATTERN[1] && object2[2] == OggPageHeader.CAPTURE_PATTERN[2]) {
                    randomAccessFile.seek(randomAccessFile.getFilePointer() - 3L);
                    long l2 = randomAccessFile.getFilePointer();
                    randomAccessFile.seek(randomAccessFile.getFilePointer() + 26L);
                    int n = randomAccessFile.readByte() & 0xFF;
                    randomAccessFile.seek(l2);
                    byArray = new byte[27 + n];
                    randomAccessFile.readFully(byArray);
                    object = new OggPageHeader(byArray);
                    randomAccessFile.seek(0L);
                    d = ((OggPageHeader)object).getAbsoluteGranulePosition();
                    break;
                }
            }
            randomAccessFile.seek(randomAccessFile.getFilePointer() - 2L);
        }
        if (d == -1.0) {
            throw new CannotReadException(ErrorMessage.OGG_VORBIS_NO_SETUP_BLOCK.getMsg());
        }
        object2 = OggPageHeader.read(randomAccessFile);
        byte[] byArray2 = new byte[((OggPageHeader)object2).getPageLength()];
        randomAccessFile.read(byArray2);
        object = new VorbisIdentificationHeader(byArray2);
        genericAudioHeader.setPreciseLength((float)(d / (double)((VorbisIdentificationHeader)object).getSamplingRate()));
        genericAudioHeader.setChannelNumber(((VorbisIdentificationHeader)object).getChannelNumber());
        genericAudioHeader.setSamplingRate(((VorbisIdentificationHeader)object).getSamplingRate());
        genericAudioHeader.setEncodingType(((VorbisIdentificationHeader)object).getEncodingType());
        genericAudioHeader.setExtraEncodingInfos("");
        genericAudioHeader.setBitsPerSample(16);
        if (((VorbisIdentificationHeader)object).getNominalBitrate() != 0 && ((VorbisIdentificationHeader)object).getMaxBitrate() == ((VorbisIdentificationHeader)object).getNominalBitrate() && ((VorbisIdentificationHeader)object).getMinBitrate() == ((VorbisIdentificationHeader)object).getNominalBitrate()) {
            genericAudioHeader.setBitrate(((VorbisIdentificationHeader)object).getNominalBitrate() / 1000);
            genericAudioHeader.setVariableBitRate(false);
        } else if (((VorbisIdentificationHeader)object).getNominalBitrate() != 0 && ((VorbisIdentificationHeader)object).getMaxBitrate() == 0 && ((VorbisIdentificationHeader)object).getMinBitrate() == 0) {
            genericAudioHeader.setBitrate(((VorbisIdentificationHeader)object).getNominalBitrate() / 1000);
            genericAudioHeader.setVariableBitRate(true);
        } else {
            genericAudioHeader.setBitrate(this.computeBitrate(genericAudioHeader.getTrackLength(), randomAccessFile.length()));
            genericAudioHeader.setVariableBitRate(true);
        }
        logger.fine("Finished");
        return genericAudioHeader;
    }

    private int computeBitrate(int n, long l) {
        return (int)(l / 1000L * 8L / (long)n);
    }
}

