/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.ogg.util;

import java.util.logging.Logger;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.ogg.VorbisVersion;
import org.jaudiotagger.audio.ogg.util.VorbisHeader;
import org.jaudiotagger.audio.ogg.util.VorbisPacketType;

public class VorbisIdentificationHeader
implements VorbisHeader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.ogg.atom");
    private int audioChannels;
    private boolean isValid = false;
    private int vorbisVersion;
    private int audioSampleRate;
    private int bitrateMinimal;
    private int bitrateNominal;
    private int bitrateMaximal;
    public static final int FIELD_VORBIS_VERSION_POS = 7;
    public static final int FIELD_AUDIO_CHANNELS_POS = 11;
    public static final int FIELD_AUDIO_SAMPLE_RATE_POS = 12;
    public static final int FIELD_BITRATE_MAX_POS = 16;
    public static final int FIELD_BITRATE_NOMAIML_POS = 20;
    public static final int FIELD_BITRATE_MIN_POS = 24;
    public static final int FIELD_BLOCKSIZE_POS = 28;
    public static final int FIELD_FRAMING_FLAG_POS = 29;
    public static final int FIELD_VORBIS_VERSION_LENGTH = 4;
    public static final int FIELD_AUDIO_CHANNELS_LENGTH = 1;
    public static final int FIELD_AUDIO_SAMPLE_RATE_LENGTH = 4;
    public static final int FIELD_BITRATE_MAX_LENGTH = 4;
    public static final int FIELD_BITRATE_NOMAIML_LENGTH = 4;
    public static final int FIELD_BITRATE_MIN_LENGTH = 4;
    public static final int FIELD_BLOCKSIZE_LENGTH = 1;
    public static final int FIELD_FRAMING_FLAG_LENGTH = 1;

    public VorbisIdentificationHeader(byte[] byArray) {
        this.decodeHeader(byArray);
    }

    public int getChannelNumber() {
        return this.audioChannels;
    }

    public String getEncodingType() {
        return VorbisVersion.values()[this.vorbisVersion].toString();
    }

    public int getSamplingRate() {
        return this.audioSampleRate;
    }

    public int getNominalBitrate() {
        return this.bitrateNominal;
    }

    public int getMaxBitrate() {
        return this.bitrateMaximal;
    }

    public int getMinBitrate() {
        return this.bitrateMinimal;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void decodeHeader(byte[] byArray) {
        byte by = byArray[0];
        logger.fine("packetType" + by);
        String string = Utils.getString(byArray, 1, 6, "ISO-8859-1");
        if (by == VorbisPacketType.IDENTIFICATION_HEADER.getType() && string.equals("vorbis")) {
            this.vorbisVersion = byArray[7] + (byArray[8] << 8) + (byArray[9] << 16) + (byArray[10] << 24);
            logger.fine("vorbisVersion" + this.vorbisVersion);
            this.audioChannels = this.u(byArray[11]);
            logger.fine("audioChannels" + this.audioChannels);
            this.audioSampleRate = this.u(byArray[12]) + (this.u(byArray[13]) << 8) + (this.u(byArray[14]) << 16) + (this.u(byArray[15]) << 24);
            logger.fine("audioSampleRate" + this.audioSampleRate);
            logger.fine("audioSampleRate" + byArray[12] + " " + byArray[13] + " " + byArray[14]);
            this.bitrateMinimal = this.u(byArray[16]) + (this.u(byArray[17]) << 8) + (this.u(byArray[18]) << 16) + (this.u(byArray[19]) << 24);
            this.bitrateNominal = this.u(byArray[20]) + (this.u(byArray[21]) << 8) + (this.u(byArray[22]) << 16) + (this.u(byArray[23]) << 24);
            this.bitrateMaximal = this.u(byArray[24]) + (this.u(byArray[25]) << 8) + (this.u(byArray[26]) << 16) + (this.u(byArray[27]) << 24);
            byte by2 = byArray[29];
            logger.fine("framingFlag" + by2);
            if (by2 != 0) {
                this.isValid = true;
            }
        }
    }

    private int u(int n) {
        return n & 0xFF;
    }
}

