/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.real;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.AudioFileReader;
import org.jaudiotagger.audio.generic.GenericAudioHeader;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.real.RealChunk;
import org.jaudiotagger.audio.real.RealTag;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;

public class RealFileReader
extends AudioFileReader {
    @Override
    protected GenericAudioHeader getEncodingInfo(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        GenericAudioHeader genericAudioHeader = new GenericAudioHeader();
        RealChunk realChunk = this.findPropChunk(randomAccessFile);
        DataInputStream dataInputStream = realChunk.getDataInputStream();
        int n = Utils.readUint16(dataInputStream);
        if (n == 0) {
            long l = Utils.readUint32(dataInputStream) / 1000L;
            long l2 = Utils.readUint32(dataInputStream) / 1000L;
            long l3 = Utils.readUint32(dataInputStream);
            long l4 = Utils.readUint32(dataInputStream);
            long l5 = Utils.readUint32(dataInputStream);
            int n2 = Utils.readUint32AsInt(dataInputStream) / 1000;
            long l6 = Utils.readUint32(dataInputStream);
            long l7 = Utils.readUint32(dataInputStream);
            long l8 = Utils.readUint32(dataInputStream);
            int n3 = Utils.readUint16(dataInputStream);
            int n4 = Utils.readUint16(dataInputStream);
            genericAudioHeader.setBitrate((int)l2);
            genericAudioHeader.setLength(n2);
            genericAudioHeader.setVariableBitRate(l != l2);
        }
        return genericAudioHeader;
    }

    private RealChunk findPropChunk(RandomAccessFile randomAccessFile) throws IOException, CannotReadException {
        RealChunk realChunk = RealChunk.readChunk(randomAccessFile);
        RealChunk realChunk2 = RealChunk.readChunk(randomAccessFile);
        return realChunk2;
    }

    private RealChunk findContChunk(RandomAccessFile randomAccessFile) throws IOException, CannotReadException {
        RealChunk realChunk = RealChunk.readChunk(randomAccessFile);
        RealChunk realChunk2 = RealChunk.readChunk(randomAccessFile);
        RealChunk realChunk3 = RealChunk.readChunk(randomAccessFile);
        while (!realChunk3.isCONT()) {
            realChunk3 = RealChunk.readChunk(randomAccessFile);
        }
        return realChunk3;
    }

    @Override
    protected Tag getTag(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        RealChunk realChunk = this.findContChunk(randomAccessFile);
        DataInputStream dataInputStream = realChunk.getDataInputStream();
        String string = Utils.readString(dataInputStream, Utils.readUint16(dataInputStream));
        String string2 = Utils.readString(dataInputStream, Utils.readUint16(dataInputStream));
        String string3 = Utils.readString(dataInputStream, Utils.readUint16(dataInputStream));
        String string4 = Utils.readString(dataInputStream, Utils.readUint16(dataInputStream));
        RealTag realTag = new RealTag();
        try {
            realTag.addField(FieldKey.TITLE, string.length() == 0 ? string2 : string);
            realTag.addField(FieldKey.ARTIST, string.length() == 0 ? string3 : string2);
            realTag.addField(FieldKey.COMMENT, string4);
        }
        catch (FieldDataInvalidException fieldDataInvalidException) {
            throw new RuntimeException(fieldDataInvalidException);
        }
        return realTag;
    }
}

