/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.logging;

import java.text.StringCharacterIterator;
import org.jaudiotagger.logging.AbstractTagDisplayFormatter;

public class XMLTagDisplayFormatter
extends AbstractTagDisplayFormatter {
    private static XMLTagDisplayFormatter formatter;
    protected static final String xmlOpenStart = "<";
    protected static final String xmlOpenEnd = ">";
    protected static final String xmlCloseStart = "</";
    protected static final String xmlCloseEnd = ">";
    protected static final String xmlSingleTagClose = " />";
    protected static final String xmlCDataTagOpen = "<![CDATA[";
    protected static final String xmlCDataTagClose = "]]>";
    StringBuffer sb = new StringBuffer();

    public static String xmlOpen(String string) {
        return xmlOpenStart + string + ">";
    }

    public static String xmlOpenHeading(String string, String string2) {
        return XMLTagDisplayFormatter.xmlOpen(string + " id=\"" + string2 + "\"");
    }

    public static String xmlCData(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || Character.isSpaceChar(c)) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append("#x").append(Character.digit(c, 16));
        }
        return xmlCDataTagOpen + stringBuffer + xmlCDataTagClose;
    }

    public static String xmlClose(String string) {
        return xmlCloseStart + string + ">";
    }

    public static String xmlSingleTag(String string) {
        return xmlOpenStart + string + xmlSingleTagClose;
    }

    public static String xmlFullTag(String string, String string2) {
        return XMLTagDisplayFormatter.xmlOpen(string) + XMLTagDisplayFormatter.xmlCData(string2) + XMLTagDisplayFormatter.xmlClose(string);
    }

    @Override
    public void openHeadingElement(String string, String string2) {
        if (string2.length() == 0) {
            this.sb.append(XMLTagDisplayFormatter.xmlOpen(string));
        } else {
            this.sb.append(XMLTagDisplayFormatter.xmlOpenHeading(string, XMLTagDisplayFormatter.replaceXMLCharacters(string2)));
        }
    }

    @Override
    public void openHeadingElement(String string, boolean bl) {
        this.openHeadingElement(string, String.valueOf(bl));
    }

    @Override
    public void openHeadingElement(String string, int n) {
        this.openHeadingElement(string, String.valueOf(n));
    }

    @Override
    public void closeHeadingElement(String string) {
        this.sb.append(XMLTagDisplayFormatter.xmlClose(string));
    }

    @Override
    public void addElement(String string, String string2) {
        this.sb.append(XMLTagDisplayFormatter.xmlFullTag(string, XMLTagDisplayFormatter.replaceXMLCharacters(string2)));
    }

    @Override
    public void addElement(String string, int n) {
        this.addElement(string, String.valueOf(n));
    }

    @Override
    public void addElement(String string, boolean bl) {
        this.addElement(string, String.valueOf(bl));
    }

    @Override
    public String toString() {
        return this.sb.toString();
    }

    public static String replaceXMLCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            c = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }
}

