/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;

public class BooleanByte
extends AbstractDataType {
    int bitPosition = -1;

    public BooleanByte(String string, AbstractTagFrameBody abstractTagFrameBody, int n) {
        super(string, abstractTagFrameBody);
        if (n < 0 || n > 7) {
            throw new IndexOutOfBoundsException("Bit position needs to be from 0 - 7 : " + n);
        }
        this.bitPosition = n;
    }

    public BooleanByte(BooleanByte booleanByte) {
        super(booleanByte);
        this.bitPosition = booleanByte.bitPosition;
    }

    public int getBitPosition() {
        return this.bitPosition;
    }

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof BooleanByte)) {
            return false;
        }
        BooleanByte booleanByte = (BooleanByte)object;
        return this.bitPosition == booleanByte.bitPosition && super.equals(object);
    }

    @Override
    public void readByteArray(byte[] byArray, int n) throws InvalidDataTypeException {
        if (byArray == null) {
            throw new NullPointerException("Byte array is null");
        }
        if (n < 0 || n >= byArray.length) {
            throw new IndexOutOfBoundsException("Offset to byte array is out of bounds: offset = " + n + ", array.length = " + byArray.length);
        }
        byte by = byArray[n];
        by = (byte)(by >> this.bitPosition);
        this.value = (by = (byte)(by & 1)) == 1;
    }

    public String toString() {
        return "" + this.value;
    }

    @Override
    public byte[] writeByteArray() {
        byte[] byArray = new byte[1];
        if (this.value != null) {
            byArray[0] = (byte)((Boolean)this.value != false ? 1 : 0);
            byArray[0] = (byte)(byArray[0] << this.bitPosition);
        }
        return byArray;
    }
}

