/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;

public class ByteArraySizeTerminated
extends AbstractDataType {
    public ByteArraySizeTerminated(String string, AbstractTagFrameBody abstractTagFrameBody) {
        super(string, abstractTagFrameBody);
    }

    public ByteArraySizeTerminated(ByteArraySizeTerminated byteArraySizeTerminated) {
        super(byteArraySizeTerminated);
    }

    @Override
    public int getSize() {
        int n = 0;
        if (this.value != null) {
            n = ((byte[])this.value).length;
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ByteArraySizeTerminated && super.equals(object);
    }

    @Override
    public void readByteArray(byte[] byArray, int n) throws InvalidDataTypeException {
        if (byArray == null) {
            throw new NullPointerException("Byte array is null");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Offset to byte array is out of bounds: offset = " + n + ", array.length = " + byArray.length);
        }
        if (n >= byArray.length) {
            this.value = null;
            return;
        }
        int n2 = byArray.length - n;
        this.value = new byte[n2];
        System.arraycopy(byArray, n, this.value, 0, n2);
    }

    public String toString() {
        return this.getSize() + " bytes";
    }

    @Override
    public byte[] writeByteArray() {
        logger.config("Writing byte array" + this.getIdentifier());
        return (byte[])this.value;
    }
}

