/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;

public class Lyrics3TimeStamp
extends AbstractDataType {
    private long minute = 0L;
    private long second = 0L;

    public void readString(String string) {
    }

    public Lyrics3TimeStamp(String string, AbstractTagFrameBody abstractTagFrameBody) {
        super(string, abstractTagFrameBody);
    }

    public Lyrics3TimeStamp(String string) {
        super(string, null);
    }

    public Lyrics3TimeStamp(Lyrics3TimeStamp lyrics3TimeStamp) {
        super(lyrics3TimeStamp);
        this.minute = lyrics3TimeStamp.minute;
        this.second = lyrics3TimeStamp.second;
    }

    public void setMinute(long l) {
        this.minute = l;
    }

    public long getMinute() {
        return this.minute;
    }

    public void setSecond(long l) {
        this.second = l;
    }

    public long getSecond() {
        return this.second;
    }

    @Override
    public int getSize() {
        return 7;
    }

    public void setTimeStamp(long l, byte by) {
        this.minute = (l /= 1000L) / 60L;
        this.second = l % 60L;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Lyrics3TimeStamp)) {
            return false;
        }
        Lyrics3TimeStamp lyrics3TimeStamp = (Lyrics3TimeStamp)object;
        if (this.minute != lyrics3TimeStamp.minute) {
            return false;
        }
        return this.second == lyrics3TimeStamp.second && super.equals(object);
    }

    public void readString(String string, int n) {
        if (string == null) {
            throw new NullPointerException("Image is null");
        }
        if (n < 0 || n >= string.length()) {
            throw new IndexOutOfBoundsException("Offset to timeStamp is out of bounds: offset = " + n + ", timeStamp.length()" + string.length());
        }
        if ((string = string.substring(n)).length() == 7) {
            this.minute = Integer.parseInt(string.substring(1, 3));
            this.second = Integer.parseInt(string.substring(4, 6));
        } else {
            this.minute = 0L;
            this.second = 0L;
        }
    }

    public String toString() {
        return this.writeString();
    }

    public String writeString() {
        String string = "[";
        if (this.minute < 0L) {
            string = string + "00";
        } else {
            if (this.minute < 10L) {
                string = string + '0';
            }
            string = string + Long.toString(this.minute);
        }
        string = string + ':';
        if (this.second < 0L) {
            string = string + "00";
        } else {
            if (this.second < 10L) {
                string = string + '0';
            }
            string = string + Long.toString(this.second);
        }
        string = string + ']';
        return string;
    }

    @Override
    public void readByteArray(byte[] byArray, int n) throws InvalidDataTypeException {
        this.readString(byArray.toString(), n);
    }

    @Override
    public byte[] writeByteArray() {
        return Utils.getDefaultBytes(this.writeString(), "ISO8859-1");
    }
}

