/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.flac;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPicture;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.images.Artwork;
import org.jaudiotagger.tag.images.ArtworkFactory;
import org.jaudiotagger.tag.reference.PictureTypes;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentFieldKey;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;

public class FlacTag
implements Tag {
    private VorbisCommentTag tag = null;
    private List<MetadataBlockDataPicture> images = new ArrayList<MetadataBlockDataPicture>();

    public FlacTag() {
        this(VorbisCommentTag.createNewTag(), new ArrayList<MetadataBlockDataPicture>());
    }

    public FlacTag(VorbisCommentTag vorbisCommentTag, List<MetadataBlockDataPicture> list) {
        this.tag = vorbisCommentTag;
        this.images = list;
    }

    public List<MetadataBlockDataPicture> getImages() {
        return this.images;
    }

    public VorbisCommentTag getVorbisCommentTag() {
        return this.tag;
    }

    @Override
    public void addField(TagField tagField) throws FieldDataInvalidException {
        if (tagField instanceof MetadataBlockDataPicture) {
            this.images.add((MetadataBlockDataPicture)tagField);
        } else {
            this.tag.addField(tagField);
        }
    }

    @Override
    public List<TagField> getFields(String string) {
        if (string.equals(FieldKey.COVER_ART.name())) {
            ArrayList<TagField> arrayList = new ArrayList<TagField>();
            for (MetadataBlockDataPicture metadataBlockDataPicture : this.images) {
                arrayList.add(metadataBlockDataPicture);
            }
            return arrayList;
        }
        return this.tag.getFields(string);
    }

    @Override
    public List<String> getAll(FieldKey fieldKey) throws KeyNotFoundException {
        if (fieldKey == FieldKey.COVER_ART) {
            throw new UnsupportedOperationException(ErrorMessage.ARTWORK_CANNOT_BE_CREATED_WITH_THIS_METHOD.getMsg());
        }
        return this.tag.getAll(fieldKey);
    }

    @Override
    public boolean hasCommonFields() {
        return this.tag.hasCommonFields();
    }

    @Override
    public boolean isEmpty() {
        return (this.tag == null || this.tag.isEmpty()) && this.images.size() == 0;
    }

    @Override
    public void setField(FieldKey fieldKey, String string) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagField = this.createField(fieldKey, string);
        this.setField(tagField);
    }

    @Override
    public void addField(FieldKey fieldKey, String string) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagField = this.createField(fieldKey, string);
        this.addField(tagField);
    }

    public void setField(String string, String string2) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagField = this.createField(string, string2);
        this.setField(tagField);
    }

    public void addField(String string, String string2) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagField = this.createField(string, string2);
        this.addField(tagField);
    }

    @Override
    public void setField(TagField tagField) throws FieldDataInvalidException {
        if (tagField instanceof MetadataBlockDataPicture) {
            if (this.images.size() == 0) {
                this.images.add(0, (MetadataBlockDataPicture)tagField);
            } else {
                this.images.set(0, (MetadataBlockDataPicture)tagField);
            }
        } else {
            this.tag.setField(tagField);
        }
    }

    @Override
    public TagField createField(FieldKey fieldKey, String string) throws KeyNotFoundException, FieldDataInvalidException {
        if (fieldKey.equals((Object)FieldKey.COVER_ART)) {
            throw new UnsupportedOperationException(ErrorMessage.ARTWORK_CANNOT_BE_CREATED_WITH_THIS_METHOD.getMsg());
        }
        return this.tag.createField(fieldKey, string);
    }

    public TagField createField(VorbisCommentFieldKey vorbisCommentFieldKey, String string) throws KeyNotFoundException, FieldDataInvalidException {
        if (vorbisCommentFieldKey.equals((Object)VorbisCommentFieldKey.COVERART)) {
            throw new UnsupportedOperationException(ErrorMessage.ARTWORK_CANNOT_BE_CREATED_WITH_THIS_METHOD.getMsg());
        }
        return this.tag.createField(vorbisCommentFieldKey, string);
    }

    public TagField createField(String string, String string2) {
        if (string.equals(VorbisCommentFieldKey.COVERART.getFieldName())) {
            throw new UnsupportedOperationException(ErrorMessage.ARTWORK_CANNOT_BE_CREATED_WITH_THIS_METHOD.getMsg());
        }
        return this.tag.createField(string, string2);
    }

    @Override
    public String getFirst(String string) {
        if (string.equals(FieldKey.COVER_ART.name())) {
            throw new UnsupportedOperationException(ErrorMessage.ARTWORK_CANNOT_BE_CREATED_WITH_THIS_METHOD.getMsg());
        }
        return this.tag.getFirst(string);
    }

    @Override
    public String getValue(FieldKey fieldKey, int n) throws KeyNotFoundException {
        if (fieldKey.equals((Object)FieldKey.COVER_ART)) {
            throw new UnsupportedOperationException(ErrorMessage.ARTWORK_CANNOT_BE_RETRIEVED_WITH_THIS_METHOD.getMsg());
        }
        return this.tag.getValue(fieldKey, n);
    }

    @Override
    public String getFirst(FieldKey fieldKey) throws KeyNotFoundException {
        return this.getValue(fieldKey, 0);
    }

    @Override
    public TagField getFirstField(String string) {
        if (string.equals(FieldKey.COVER_ART.name())) {
            if (this.images.size() > 0) {
                return this.images.get(0);
            }
            return null;
        }
        return this.tag.getFirstField(string);
    }

    @Override
    public TagField getFirstField(FieldKey fieldKey) throws KeyNotFoundException {
        if (fieldKey == null) {
            throw new KeyNotFoundException();
        }
        if (fieldKey == FieldKey.COVER_ART) {
            return this.getFirstField(FieldKey.COVER_ART.name());
        }
        return this.tag.getFirstField(fieldKey);
    }

    @Override
    public void deleteField(FieldKey fieldKey) throws KeyNotFoundException {
        if (fieldKey.equals((Object)FieldKey.COVER_ART)) {
            this.images.clear();
        } else {
            this.tag.deleteField(fieldKey);
        }
    }

    @Override
    public void deleteField(String string) throws KeyNotFoundException {
        if (string.equals(FieldKey.COVER_ART.name())) {
            this.images.clear();
        } else {
            this.tag.deleteField(string);
        }
    }

    @Override
    public Iterator<TagField> getFields() {
        return this.tag.getFields();
    }

    @Override
    public int getFieldCount() {
        return this.tag.getFieldCount() + this.images.size();
    }

    @Override
    public int getFieldCountIncludingSubValues() {
        return this.getFieldCount();
    }

    @Override
    public boolean setEncoding(String string) throws FieldDataInvalidException {
        return this.tag.setEncoding(string);
    }

    @Override
    public List<TagField> getFields(FieldKey fieldKey) throws KeyNotFoundException {
        if (fieldKey.equals((Object)FieldKey.COVER_ART)) {
            ArrayList<TagField> arrayList = new ArrayList<TagField>();
            for (MetadataBlockDataPicture metadataBlockDataPicture : this.images) {
                arrayList.add(metadataBlockDataPicture);
            }
            return arrayList;
        }
        return this.tag.getFields(fieldKey);
    }

    public TagField createArtworkField(byte[] byArray, int n, String string, String string2, int n2, int n3, int n4, int n5) throws FieldDataInvalidException {
        return new MetadataBlockDataPicture(byArray, n, string, string2, n2, n3, n4, n5);
    }

    public TagField createLinkedArtworkField(String string) {
        return new MetadataBlockDataPicture(Utils.getDefaultBytes(string, "ISO-8859-1"), PictureTypes.DEFAULT_ID, "-->", "", 0, 0, 0, 0);
    }

    @Override
    public TagField createField(Artwork artwork) throws FieldDataInvalidException {
        if (artwork.isLinked()) {
            return new MetadataBlockDataPicture(Utils.getDefaultBytes(artwork.getImageUrl(), "ISO-8859-1"), artwork.getPictureType(), "-->", "", 0, 0, 0, 0);
        }
        if (!artwork.setImageFromData()) {
            throw new FieldDataInvalidException("Unable to createField buffered image from the image");
        }
        return new MetadataBlockDataPicture(artwork.getBinaryData(), artwork.getPictureType(), artwork.getMimeType(), artwork.getDescription(), artwork.getWidth(), artwork.getHeight(), 0, 0);
    }

    @Override
    public void setField(Artwork artwork) throws FieldDataInvalidException {
        this.setField(this.createField(artwork));
    }

    @Override
    public void addField(Artwork artwork) throws FieldDataInvalidException {
        this.addField(this.createField(artwork));
    }

    @Override
    public List<Artwork> getArtworkList() {
        ArrayList<Artwork> arrayList = new ArrayList<Artwork>(this.images.size());
        for (MetadataBlockDataPicture metadataBlockDataPicture : this.images) {
            Artwork artwork = ArtworkFactory.createArtworkFromMetadataBlockDataPicture(metadataBlockDataPicture);
            arrayList.add(artwork);
        }
        return arrayList;
    }

    @Override
    public Artwork getFirstArtwork() {
        List<Artwork> list = this.getArtworkList();
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public void deleteArtworkField() throws KeyNotFoundException {
        this.deleteField(FieldKey.COVER_ART);
    }

    @Override
    public boolean hasField(FieldKey fieldKey) {
        if (fieldKey == FieldKey.COVER_ART) {
            return this.images.size() > 0;
        }
        return this.tag.hasField(fieldKey);
    }

    public boolean hasField(VorbisCommentFieldKey vorbisCommentFieldKey) {
        return this.tag.hasField(vorbisCommentFieldKey);
    }

    @Override
    public boolean hasField(String string) {
        if (string.equals(FieldKey.COVER_ART.name())) {
            return this.images.size() > 0;
        }
        return this.tag.hasField(string);
    }
}

