/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ID3Unsynchronization {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.tag.id3");

    public static boolean requiresUnsynchronization(byte[] byArray) {
        for (int i = 0; i < byArray.length - 1; ++i) {
            if ((byArray[i] & 0xFF) != 255 || (byArray[i + 1] & 0xE0) != 224) continue;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Unsynchronisation required found bit at:" + i);
            }
            return true;
        }
        return false;
    }

    public static byte[] unsynchronize(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        int n = 0;
        while (byteArrayInputStream.available() > 0) {
            int n2 = byteArrayInputStream.read();
            ++n;
            byteArrayOutputStream.write(n2);
            if ((n2 & 0xFF) != 255 || byteArrayInputStream.available() <= 0) continue;
            byteArrayInputStream.mark(1);
            int n3 = byteArrayInputStream.read();
            if ((n3 & 0xE0) == 224) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Writing unsynchronisation bit at:" + n);
                }
                byteArrayOutputStream.write(0);
            } else if (n3 == 0) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Inserting zero unsynchronisation bit at:" + n);
                }
                byteArrayOutputStream.write(0);
            }
            byteArrayInputStream.reset();
        }
        if ((byArray[byArray.length - 1] & 0xFF) == 255) {
            logger.finest("Adding unsynchronisation bit at end of stream");
            byteArrayOutputStream.write(0);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static ByteBuffer synchronize(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        byte[] byArray = new byte[n + 1];
        byteBuffer.get(byArray, 0, n);
        int n2 = 0;
        int n3 = 0;
        boolean bl = true;
        while (n2 < n) {
            byte by = byArray[n2++];
            if (bl || by != 0) {
                byArray[n3++] = by;
            }
            bl = (by & 0xFF) != 255;
        }
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray, 0, n3);
        return byteBuffer2;
    }
}

