/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.logging.Hex;
import org.jaudiotagger.tag.EmptyFrameException;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.InvalidFrameException;
import org.jaudiotagger.tag.InvalidFrameIdentifierException;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.datatype.Lyrics3Line;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.AbstractTagItem;
import org.jaudiotagger.tag.id3.ID3Compression;
import org.jaudiotagger.tag.id3.ID3SyncSafeInteger;
import org.jaudiotagger.tag.id3.ID3Tags;
import org.jaudiotagger.tag.id3.ID3Unsynchronization;
import org.jaudiotagger.tag.id3.ID3v22Frame;
import org.jaudiotagger.tag.id3.ID3v23Frame;
import org.jaudiotagger.tag.id3.ID3v24Frames;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.FrameBodyCOMM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyDeprecated;
import org.jaudiotagger.tag.id3.framebody.FrameBodySYLT;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTALB;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTCOM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTIT2;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTMOO;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTPE1;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTXXX;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUSLT;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUnsupported;
import org.jaudiotagger.tag.id3.framebody.ID3v24FrameBody;
import org.jaudiotagger.tag.id3.valuepair.TextEncoding;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyAUT;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyEAL;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyEAR;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyETT;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyINF;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyLYR;
import org.jaudiotagger.tag.lyrics3.Lyrics3v2Field;
import org.jaudiotagger.utils.EqualsUtil;

public class ID3v24Frame
extends AbstractID3v2Frame {
    private static Pattern validFrameIdentifier = Pattern.compile("[A-Z][0-9A-Z]{3}");
    protected static final int FRAME_DATA_LENGTH_SIZE = 4;
    protected static final int FRAME_ID_SIZE = 4;
    protected static final int FRAME_FLAGS_SIZE = 2;
    protected static final int FRAME_SIZE_SIZE = 4;
    protected static final int FRAME_ENCRYPTION_INDICATOR_SIZE = 1;
    protected static final int FRAME_GROUPING_INDICATOR_SIZE = 1;
    protected static final int FRAME_HEADER_SIZE = 10;
    private int encryptionMethod;
    private int groupIdentifier;

    @Override
    protected int getFrameIdSize() {
        return 4;
    }

    @Override
    protected int getFrameSizeSize() {
        return 4;
    }

    protected int getFrameFlagsSize() {
        return 2;
    }

    @Override
    protected int getFrameHeaderSize() {
        return 10;
    }

    public ID3v24Frame() {
    }

    public ID3v24Frame(String string) {
        super(string);
        this.statusFlags = new StatusFlags();
        this.encodingFlags = new EncodingFlags();
    }

    public ID3v24Frame(ID3v24Frame iD3v24Frame) {
        super(iD3v24Frame);
        this.statusFlags = new StatusFlags(iD3v24Frame.getStatusFlags().getOriginalFlags());
        this.encodingFlags = new EncodingFlags(iD3v24Frame.getEncodingFlags().getFlags());
    }

    private void createV24FrameFromV23Frame(ID3v23Frame iD3v23Frame) throws InvalidFrameException {
        this.identifier = ID3Tags.convertFrameID23To24(iD3v23Frame.getIdentifier());
        logger.finer("Creating V24frame from v23:" + iD3v23Frame.getIdentifier() + ":" + this.identifier);
        if (iD3v23Frame.getBody() instanceof FrameBodyUnsupported) {
            this.frameBody = new FrameBodyUnsupported((FrameBodyUnsupported)iD3v23Frame.getBody());
            this.frameBody.setHeader(this);
            this.identifier = iD3v23Frame.getIdentifier();
            logger.finer("V3:UnsupportedBody:Orig id is:" + iD3v23Frame.getIdentifier() + ":New id is:" + this.identifier);
        } else if (this.identifier != null) {
            if (iD3v23Frame.getIdentifier().equals("TXXX") && ((FrameBodyTXXX)iD3v23Frame.getBody()).getDescription().equals("MOOD")) {
                this.frameBody = new FrameBodyTMOO((FrameBodyTXXX)iD3v23Frame.getBody());
                this.frameBody.setHeader(this);
                this.identifier = this.frameBody.getIdentifier();
            } else {
                logger.finer("V3:Orig id is:" + iD3v23Frame.getIdentifier() + ":New id is:" + this.identifier);
                this.frameBody = (AbstractTagFrameBody)ID3Tags.copyObject(iD3v23Frame.getBody());
                this.frameBody.setHeader(this);
            }
        } else if (ID3Tags.isID3v23FrameIdentifier(iD3v23Frame.getIdentifier())) {
            this.identifier = ID3Tags.forceFrameID23To24(iD3v23Frame.getIdentifier());
            if (this.identifier != null) {
                logger.config("V3:Orig id is:" + iD3v23Frame.getIdentifier() + ":New id is:" + this.identifier);
                this.frameBody = this.readBody(this.identifier, (AbstractID3v2FrameBody)iD3v23Frame.getBody());
                this.frameBody.setHeader(this);
            } else {
                this.frameBody = new FrameBodyDeprecated((AbstractID3v2FrameBody)iD3v23Frame.getBody());
                this.frameBody.setHeader(this);
                this.identifier = iD3v23Frame.getIdentifier();
                logger.finer("V3:Deprecated:Orig id is:" + iD3v23Frame.getIdentifier() + ":New id is:" + this.identifier);
            }
        } else {
            this.frameBody = new FrameBodyUnsupported((FrameBodyUnsupported)iD3v23Frame.getBody());
            this.frameBody.setHeader(this);
            this.identifier = iD3v23Frame.getIdentifier();
            logger.finer("V3:Unknown:Orig id is:" + iD3v23Frame.getIdentifier() + ":New id is:" + this.identifier);
        }
    }

    public ID3v24Frame(AbstractID3v2Frame abstractID3v2Frame) throws InvalidFrameException {
        if (abstractID3v2Frame instanceof ID3v24Frame) {
            throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
        }
        if (abstractID3v2Frame instanceof ID3v23Frame) {
            this.statusFlags = new StatusFlags((ID3v23Frame.StatusFlags)abstractID3v2Frame.getStatusFlags());
            this.encodingFlags = new EncodingFlags(abstractID3v2Frame.getEncodingFlags().getFlags());
        } else {
            this.statusFlags = new StatusFlags();
            this.encodingFlags = new EncodingFlags();
        }
        if (abstractID3v2Frame instanceof ID3v23Frame) {
            this.createV24FrameFromV23Frame((ID3v23Frame)abstractID3v2Frame);
        } else if (abstractID3v2Frame instanceof ID3v22Frame) {
            ID3v23Frame iD3v23Frame = new ID3v23Frame(abstractID3v2Frame);
            this.createV24FrameFromV23Frame(iD3v23Frame);
        }
        this.frameBody.setHeader(this);
    }

    public ID3v24Frame(Lyrics3v2Field lyrics3v2Field) throws InvalidTagException {
        String string = lyrics3v2Field.getIdentifier();
        if (string.equals("IND")) {
            throw new InvalidTagException("Cannot create ID3v2.40 frame from Lyrics3 indications field.");
        }
        if (string.equals("LYR")) {
            FieldFrameBodyLYR fieldFrameBodyLYR = (FieldFrameBodyLYR)lyrics3v2Field.getBody();
            Iterator<Lyrics3Line> iterator = fieldFrameBodyLYR.iterator();
            boolean bl = fieldFrameBodyLYR.hasTimeStamp();
            FrameBodySYLT frameBodySYLT = new FrameBodySYLT(0, "ENG", 2, 1, "", new byte[0]);
            FrameBodyUSLT frameBodyUSLT = new FrameBodyUSLT(0, "ENG", "", "");
            while (iterator.hasNext()) {
                Lyrics3Line lyrics3Line = iterator.next();
                if (bl) continue;
                frameBodyUSLT.addLyric(lyrics3Line);
            }
            if (bl) {
                this.frameBody = frameBodySYLT;
                this.frameBody.setHeader(this);
            } else {
                this.frameBody = frameBodyUSLT;
                this.frameBody.setHeader(this);
            }
        } else if (string.equals("INF")) {
            String string2 = ((FieldFrameBodyINF)lyrics3v2Field.getBody()).getAdditionalInformation();
            this.frameBody = new FrameBodyCOMM(0, "ENG", "", string2);
            this.frameBody.setHeader(this);
        } else if (string.equals("AUT")) {
            String string3 = ((FieldFrameBodyAUT)lyrics3v2Field.getBody()).getAuthor();
            this.frameBody = new FrameBodyTCOM(0, string3);
            this.frameBody.setHeader(this);
        } else if (string.equals("EAL")) {
            String string4 = ((FieldFrameBodyEAL)lyrics3v2Field.getBody()).getAlbum();
            this.frameBody = new FrameBodyTALB(0, string4);
            this.frameBody.setHeader(this);
        } else if (string.equals("EAR")) {
            String string5 = ((FieldFrameBodyEAR)lyrics3v2Field.getBody()).getArtist();
            this.frameBody = new FrameBodyTPE1(0, string5);
            this.frameBody.setHeader(this);
        } else if (string.equals("ETT")) {
            String string6 = ((FieldFrameBodyETT)lyrics3v2Field.getBody()).getTitle();
            this.frameBody = new FrameBodyTIT2(0, string6);
            this.frameBody.setHeader(this);
        } else {
            if (string.equals("IMG")) {
                throw new InvalidTagException("Cannot create ID3v2.40 frame from Lyrics3 image field.");
            }
            throw new InvalidTagException("Cannot caret ID3v2.40 frame from " + string + " Lyrics3 field");
        }
    }

    public ID3v24Frame(ByteBuffer byteBuffer, String string) throws InvalidFrameException, InvalidDataTypeException {
        this.setLoggingFilename(string);
        this.read(byteBuffer);
    }

    public ID3v24Frame(ByteBuffer byteBuffer) throws InvalidFrameException, InvalidDataTypeException {
        this(byteBuffer, "");
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ID3v24Frame)) {
            return false;
        }
        ID3v24Frame iD3v24Frame = (ID3v24Frame)object;
        return EqualsUtil.areEqual(this.statusFlags, iD3v24Frame.statusFlags) && EqualsUtil.areEqual(this.encodingFlags, iD3v24Frame.encodingFlags) && super.equals(iD3v24Frame);
    }

    @Override
    public int getSize() {
        return this.frameBody.getSize() + 10;
    }

    private void checkIfFrameSizeThatIsNotSyncSafe(ByteBuffer byteBuffer) throws InvalidFrameException {
        if (this.frameSize > 127) {
            int n = byteBuffer.position();
            byteBuffer.position(n - this.getFrameIdSize());
            int n2 = byteBuffer.getInt();
            byteBuffer.position(n - this.getFrameIdSize());
            boolean bl = ID3SyncSafeInteger.isBufferNotSyncSafe(byteBuffer);
            byteBuffer.position(n);
            if (bl) {
                logger.warning(this.getLoggingFilename() + ":" + "Frame size is NOT stored as a sync safe integer:" + this.identifier);
                if (n2 > byteBuffer.remaining() - -this.getFrameFlagsSize()) {
                    logger.warning(this.getLoggingFilename() + ":" + "Invalid Frame size larger than size before mp3 audio:" + this.identifier);
                    throw new InvalidFrameException(this.identifier + " is invalid frame");
                }
                this.frameSize = n2;
            } else {
                byte[] byArray = new byte[this.getFrameIdSize()];
                byteBuffer.position(n + this.frameSize + this.getFrameFlagsSize());
                if (byteBuffer.remaining() < this.getFrameIdSize()) {
                    byteBuffer.position(n);
                } else {
                    byteBuffer.get(byArray, 0, this.getFrameIdSize());
                    byteBuffer.position(n);
                    String string = new String(byArray);
                    if (!this.isValidID3v2FrameIdentifier(string) && !ID3SyncSafeInteger.isBufferEmpty(byArray)) {
                        if (n2 > byteBuffer.remaining() - this.getFrameFlagsSize()) {
                            byteBuffer.position(n);
                        } else {
                            byArray = new byte[this.getFrameIdSize()];
                            byteBuffer.position(n + n2 + this.getFrameFlagsSize());
                            if (byteBuffer.remaining() >= this.getFrameIdSize()) {
                                byteBuffer.get(byArray, 0, this.getFrameIdSize());
                                string = new String(byArray);
                                byteBuffer.position(n);
                                if (this.isValidID3v2FrameIdentifier(string)) {
                                    this.frameSize = n2;
                                    logger.warning(this.getLoggingFilename() + ":" + "Assuming frame size is NOT stored as a sync safe integer:" + this.identifier);
                                } else if (ID3SyncSafeInteger.isBufferEmpty(byArray)) {
                                    this.frameSize = n2;
                                    logger.warning(this.getLoggingFilename() + ":" + "Assuming frame size is NOT stored as a sync safe integer:" + this.identifier);
                                }
                            } else {
                                byteBuffer.position(n);
                                if (byteBuffer.remaining() == 0) {
                                    this.frameSize = n2;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void getFrameSize(ByteBuffer byteBuffer) throws InvalidFrameException {
        this.frameSize = ID3SyncSafeInteger.bufferToValue(byteBuffer);
        if (this.frameSize < 0) {
            logger.warning(this.getLoggingFilename() + ":" + "Invalid Frame size:" + this.identifier);
            throw new InvalidFrameException(this.identifier + " is invalid frame");
        }
        if (this.frameSize == 0) {
            logger.warning(this.getLoggingFilename() + ":" + "Empty Frame:" + this.identifier);
            byteBuffer.get();
            byteBuffer.get();
            throw new EmptyFrameException(this.identifier + " is empty frame");
        }
        if (this.frameSize > byteBuffer.remaining() - 2) {
            logger.warning(this.getLoggingFilename() + ":" + "Invalid Frame size larger than size before mp3 audio:" + this.identifier);
            throw new InvalidFrameException(this.identifier + " is invalid frame");
        }
        this.checkIfFrameSizeThatIsNotSyncSafe(byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(ByteBuffer byteBuffer) throws InvalidFrameException, InvalidDataTypeException {
        String string = this.readIdentifier(byteBuffer);
        if (!this.isValidID3v2FrameIdentifier(string)) {
            logger.config(this.getLoggingFilename() + ":" + "Invalid identifier:" + string);
            byteBuffer.position(byteBuffer.position() - (this.getFrameIdSize() - 1));
            throw new InvalidFrameIdentifierException(this.getLoggingFilename() + ":" + string + ":is not a valid ID3v2.30 frame");
        }
        this.getFrameSize(byteBuffer);
        this.statusFlags = new StatusFlags(byteBuffer.get());
        this.encodingFlags = new EncodingFlags(byteBuffer.get());
        int n = 0;
        int n2 = -1;
        if (((EncodingFlags)this.encodingFlags).isGrouping()) {
            n = 1;
            this.groupIdentifier = byteBuffer.get();
        }
        if (((EncodingFlags)this.encodingFlags).isEncryption()) {
            ++n;
            this.encryptionMethod = byteBuffer.get();
        }
        if (((EncodingFlags)this.encodingFlags).isDataLengthIndicator()) {
            n2 = ID3SyncSafeInteger.bufferToValue(byteBuffer);
            n += 4;
            logger.config(this.getLoggingFilename() + ":" + "Frame Size Is:" + this.frameSize + " Data Length Size:" + n2);
        }
        int n3 = this.frameSize - n;
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer2.limit(n3);
        int n4 = n3;
        if (((EncodingFlags)this.encodingFlags).isUnsynchronised()) {
            byteBuffer2 = ID3Unsynchronization.synchronize(byteBuffer2);
            n4 = byteBuffer2.limit();
            logger.config(this.getLoggingFilename() + ":" + "Frame Size After Syncing is:" + n4);
        }
        try {
            if (((EncodingFlags)this.encodingFlags).isCompression()) {
                byteBuffer2 = ID3Compression.uncompress(string, this.getLoggingFilename(), byteBuffer, n2, n3);
                this.frameBody = this.readBody(string, byteBuffer2, n2);
            } else if (((EncodingFlags)this.encodingFlags).isEncryption()) {
                byteBuffer2 = byteBuffer.slice();
                byteBuffer2.limit(n3);
                this.frameBody = this.readEncryptedBody(string, byteBuffer, this.frameSize);
            } else {
                this.frameBody = this.readBody(string, byteBuffer2, n4);
            }
            if (!(this.frameBody instanceof ID3v24FrameBody)) {
                logger.config(this.getLoggingFilename() + ":" + "Converted frame body with:" + string + " to deprecated framebody");
                this.frameBody = new FrameBodyDeprecated((AbstractID3v2FrameBody)this.frameBody);
            }
        }
        finally {
            byteBuffer.position(byteBuffer.position() + n3);
        }
    }

    @Override
    public void write(ByteArrayOutputStream byteArrayOutputStream) {
        boolean bl;
        logger.config("Writing frame to file:" + this.getIdentifier());
        ByteBuffer byteBuffer = ByteBuffer.allocate(10);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        ((AbstractID3v2FrameBody)this.frameBody).write(byteArrayOutputStream2);
        byte[] byArray = byteArrayOutputStream2.toByteArray();
        boolean bl2 = bl = TagOptionSingleton.getInstance().isUnsyncTags() && ID3Unsynchronization.requiresUnsynchronization(byArray);
        if (bl) {
            byArray = ID3Unsynchronization.unsynchronize(byArray);
            logger.config("bodybytebuffer:sizeafterunsynchronisation:" + byArray.length);
        }
        if (this.getIdentifier().length() == 3) {
            this.identifier = this.identifier + ' ';
        }
        byteBuffer.put(Utils.getDefaultBytes(this.getIdentifier(), "ISO-8859-1"), 0, 4);
        int n = byArray.length;
        logger.fine("Frame Size Is:" + n);
        byteBuffer.put(ID3SyncSafeInteger.valueToBuffer(n));
        byteBuffer.put(this.statusFlags.getWriteFlags());
        ((EncodingFlags)this.encodingFlags).unsetNonStandardFlags();
        if (bl) {
            ((EncodingFlags)this.encodingFlags).setUnsynchronised();
        } else {
            ((EncodingFlags)this.encodingFlags).unsetUnsynchronised();
        }
        ((EncodingFlags)this.encodingFlags).unsetCompression();
        ((EncodingFlags)this.encodingFlags).unsetDataLengthIndicator();
        byteBuffer.put(this.encodingFlags.getFlags());
        try {
            byteArrayOutputStream.write(byteBuffer.array());
            if (((EncodingFlags)this.encodingFlags).isEncryption()) {
                byteArrayOutputStream.write(this.encryptionMethod);
            }
            if (((EncodingFlags)this.encodingFlags).isGrouping()) {
                byteArrayOutputStream.write(this.groupIdentifier);
            }
            byteArrayOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public AbstractID3v2Frame.StatusFlags getStatusFlags() {
        return this.statusFlags;
    }

    @Override
    public AbstractID3v2Frame.EncodingFlags getEncodingFlags() {
        return this.encodingFlags;
    }

    public int getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public int getGroupIdentifier() {
        return this.groupIdentifier;
    }

    public boolean isValidID3v2FrameIdentifier(String string) {
        Matcher matcher = validFrameIdentifier.matcher(string);
        return matcher.matches();
    }

    @Override
    public void createStructure() {
        MP3File.getStructureFormatter().openHeadingElement("frame", this.getIdentifier());
        MP3File.getStructureFormatter().addElement("frameSize", this.frameSize);
        this.statusFlags.createStructure();
        this.encodingFlags.createStructure();
        this.frameBody.createStructure();
        MP3File.getStructureFormatter().closeHeadingElement("frame");
    }

    @Override
    public boolean isCommon() {
        return ID3v24Frames.getInstanceOf().isCommon(this.getId());
    }

    @Override
    public boolean isBinary() {
        return ID3v24Frames.getInstanceOf().isBinary(this.getId());
    }

    @Override
    public void setEncoding(String string) {
        Integer n = TextEncoding.getInstanceOf().getIdForValue(string);
        if (string != null && n < 4) {
            this.getBody().setTextEncoding(n.byteValue());
        }
    }

    class EncodingFlags
    extends AbstractID3v2Frame.EncodingFlags {
        public static final String TYPE_COMPRESSION = "compression";
        public static final String TYPE_ENCRYPTION = "encryption";
        public static final String TYPE_GROUPIDENTITY = "groupidentity";
        public static final String TYPE_FRAMEUNSYNCHRONIZATION = "frameUnsynchronisation";
        public static final String TYPE_DATALENGTHINDICATOR = "dataLengthIndicator";
        public static final int MASK_GROUPING_IDENTITY = 64;
        public static final int MASK_COMPRESSION = 8;
        public static final int MASK_ENCRYPTION = 4;
        public static final int MASK_FRAME_UNSYNCHRONIZATION = 2;
        public static final int MASK_DATA_LENGTH_INDICATOR = 1;

        EncodingFlags() {
        }

        EncodingFlags(byte by) {
            super(by);
            this.logEnabledFlags();
        }

        public void logEnabledFlags() {
            if (this.isNonStandardFlags()) {
                AbstractTagItem.logger.warning(ID3v24Frame.this.getLoggingFilename() + ":" + ID3v24Frame.this.identifier + ":Unknown Encoding Flags:" + Hex.asHex(this.flags));
            }
            if (this.isCompression()) {
                AbstractTagItem.logger.warning(ErrorMessage.MP3_FRAME_IS_COMPRESSED.getMsg(ID3v24Frame.this.getLoggingFilename(), ID3v24Frame.this.identifier));
            }
            if (this.isEncryption()) {
                AbstractTagItem.logger.warning(ErrorMessage.MP3_FRAME_IS_ENCRYPTED.getMsg(ID3v24Frame.this.getLoggingFilename(), ID3v24Frame.this.identifier));
            }
            if (this.isGrouping()) {
                AbstractTagItem.logger.config(ErrorMessage.MP3_FRAME_IS_GROUPED.getMsg(ID3v24Frame.this.getLoggingFilename(), ID3v24Frame.this.identifier));
            }
            if (this.isUnsynchronised()) {
                AbstractTagItem.logger.config(ErrorMessage.MP3_FRAME_IS_UNSYNCHRONISED.getMsg(ID3v24Frame.this.getLoggingFilename(), ID3v24Frame.this.identifier));
            }
            if (this.isDataLengthIndicator()) {
                AbstractTagItem.logger.config(ErrorMessage.MP3_FRAME_IS_DATA_LENGTH_INDICATOR.getMsg(ID3v24Frame.this.getLoggingFilename(), ID3v24Frame.this.identifier));
            }
        }

        @Override
        public byte getFlags() {
            return this.flags;
        }

        public boolean isCompression() {
            return (this.flags & 8) > 0;
        }

        public boolean isEncryption() {
            return (this.flags & 4) > 0;
        }

        public boolean isGrouping() {
            return (this.flags & 0x40) > 0;
        }

        public boolean isUnsynchronised() {
            return (this.flags & 2) > 0;
        }

        public boolean isDataLengthIndicator() {
            return (this.flags & 1) > 0;
        }

        public void setCompression() {
            this.flags = (byte)(this.flags | 8);
        }

        public void setEncryption() {
            this.flags = (byte)(this.flags | 4);
        }

        public void setGrouping() {
            this.flags = (byte)(this.flags | 0x40);
        }

        public void setUnsynchronised() {
            this.flags = (byte)(this.flags | 2);
        }

        public void setDataLengthIndicator() {
            this.flags = (byte)(this.flags | 1);
        }

        public void unsetCompression() {
            this.flags = (byte)(this.flags & 0xFFFFFFF7);
        }

        public void unsetEncryption() {
            this.flags = (byte)(this.flags & 0xFFFFFFFB);
        }

        public void unsetGrouping() {
            this.flags = (byte)(this.flags & 0xFFFFFFBF);
        }

        public void unsetUnsynchronised() {
            this.flags = (byte)(this.flags & 0xFFFFFFFD);
        }

        public void unsetDataLengthIndicator() {
            this.flags = (byte)(this.flags & 0xFFFFFFFE);
        }

        public boolean isNonStandardFlags() {
            return (this.flags & 0x80) > 0 || (this.flags & 0x20) > 0 || (this.flags & 0x10) > 0;
        }

        public void unsetNonStandardFlags() {
            if (this.isNonStandardFlags()) {
                AbstractTagItem.logger.warning(ID3v24Frame.this.getLoggingFilename() + ":" + ID3v24Frame.this.getIdentifier() + ":Unsetting Unknown Encoding Flags:" + Hex.asHex(this.flags));
                this.flags = (byte)(this.flags & 0x7F);
                this.flags = (byte)(this.flags & 0xFFFFFFDF);
                this.flags = (byte)(this.flags & 0xFFFFFFEF);
            }
        }

        @Override
        public void createStructure() {
            MP3File.getStructureFormatter().openHeadingElement("encodingFlags", "");
            MP3File.getStructureFormatter().addElement(TYPE_COMPRESSION, this.flags & 8);
            MP3File.getStructureFormatter().addElement(TYPE_ENCRYPTION, this.flags & 4);
            MP3File.getStructureFormatter().addElement(TYPE_GROUPIDENTITY, this.flags & 0x40);
            MP3File.getStructureFormatter().addElement(TYPE_FRAMEUNSYNCHRONIZATION, this.flags & 2);
            MP3File.getStructureFormatter().addElement(TYPE_DATALENGTHINDICATOR, this.flags & 1);
            MP3File.getStructureFormatter().closeHeadingElement("encodingFlags");
        }
    }

    class StatusFlags
    extends AbstractID3v2Frame.StatusFlags {
        public static final String TYPE_TAGALTERPRESERVATION = "typeTagAlterPreservation";
        public static final String TYPE_FILEALTERPRESERVATION = "typeFileAlterPreservation";
        public static final String TYPE_READONLY = "typeReadOnly";
        public static final int MASK_TAG_ALTER_PRESERVATION = 64;
        public static final int MASK_FILE_ALTER_PRESERVATION = 32;
        public static final int MASK_READ_ONLY = 16;

        StatusFlags() {
        }

        StatusFlags(byte by) {
            this.originalFlags = by;
            this.writeFlags = by;
            this.modifyFlags();
        }

        StatusFlags(ID3v23Frame.StatusFlags statusFlags) {
            this.writeFlags = this.originalFlags = this.convertV3ToV4Flags(statusFlags.getOriginalFlags());
            this.modifyFlags();
        }

        private byte convertV3ToV4Flags(byte by) {
            byte by2 = 0;
            if ((by & 0x40) != 0) {
                by2 = (byte)(by2 | 0x20);
            }
            if ((by & 0x80) != 0) {
                by2 = (byte)(by2 | 0x40);
            }
            return by2;
        }

        protected void modifyFlags() {
            String string = ID3v24Frame.this.getIdentifier();
            if (ID3v24Frames.getInstanceOf().isDiscardIfFileAltered(string)) {
                this.writeFlags = (byte)(this.writeFlags | 0x20);
                this.writeFlags = (byte)(this.writeFlags & 0xFFFFFFBF);
            } else {
                this.writeFlags = (byte)(this.writeFlags & 0xFFFFFFDF);
                this.writeFlags = (byte)(this.writeFlags & 0xFFFFFFBF);
            }
        }

        @Override
        public void createStructure() {
            MP3File.getStructureFormatter().openHeadingElement("statusFlags", "");
            MP3File.getStructureFormatter().addElement(TYPE_TAGALTERPRESERVATION, this.originalFlags & 0x40);
            MP3File.getStructureFormatter().addElement(TYPE_FILEALTERPRESERVATION, this.originalFlags & 0x20);
            MP3File.getStructureFormatter().addElement(TYPE_READONLY, this.originalFlags & 0x10);
            MP3File.getStructureFormatter().closeHeadingElement("statusFlags");
        }
    }
}

