/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.framebody;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.datatype.NumberHashMap;
import org.jaudiotagger.tag.datatype.TextEncodedStringSizeTerminated;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.ID3TextEncodingConversion;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;

public abstract class AbstractFrameBodyTextInfo
extends AbstractID3v2FrameBody {
    protected AbstractFrameBodyTextInfo() {
        this.setObjectValue("TextEncoding", (byte)0);
        this.setObjectValue("Text", "");
    }

    protected AbstractFrameBodyTextInfo(AbstractFrameBodyTextInfo abstractFrameBodyTextInfo) {
        super(abstractFrameBodyTextInfo);
    }

    protected AbstractFrameBodyTextInfo(byte by, String string) {
        this.setObjectValue("TextEncoding", by);
        this.setObjectValue("Text", string);
    }

    protected AbstractFrameBodyTextInfo(ByteBuffer byteBuffer, int n) throws InvalidTagException {
        super(byteBuffer, n);
    }

    public void setText(String string) {
        if (string == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.setObjectValue("Text", string);
    }

    @Override
    public String getUserFriendlyValue() {
        return this.getTextWithoutTrailingNulls();
    }

    public String getText() {
        return (String)this.getObjectValue("Text");
    }

    public String getTextWithoutTrailingNulls() {
        TextEncodedStringSizeTerminated textEncodedStringSizeTerminated = (TextEncodedStringSizeTerminated)this.getObject("Text");
        return textEncodedStringSizeTerminated.getValueWithoutTrailingNull();
    }

    public String getFirstTextValue() {
        TextEncodedStringSizeTerminated textEncodedStringSizeTerminated = (TextEncodedStringSizeTerminated)this.getObject("Text");
        return textEncodedStringSizeTerminated.getValueAtIndex(0);
    }

    public String getValueAtIndex(int n) {
        TextEncodedStringSizeTerminated textEncodedStringSizeTerminated = (TextEncodedStringSizeTerminated)this.getObject("Text");
        return textEncodedStringSizeTerminated.getValueAtIndex(n);
    }

    public List<String> getValues() {
        TextEncodedStringSizeTerminated textEncodedStringSizeTerminated = (TextEncodedStringSizeTerminated)this.getObject("Text");
        return textEncodedStringSizeTerminated.getValues();
    }

    public void addTextValue(String string) {
        TextEncodedStringSizeTerminated textEncodedStringSizeTerminated = (TextEncodedStringSizeTerminated)this.getObject("Text");
        textEncodedStringSizeTerminated.addValue(string);
    }

    public int getNumberOfValues() {
        TextEncodedStringSizeTerminated textEncodedStringSizeTerminated = (TextEncodedStringSizeTerminated)this.getObject("Text");
        return textEncodedStringSizeTerminated.getNumberOfValues();
    }

    @Override
    public void write(ByteArrayOutputStream byteArrayOutputStream) {
        this.setTextEncoding(ID3TextEncodingConversion.getTextEncoding(this.getHeader(), this.getTextEncoding()));
        if (!((TextEncodedStringSizeTerminated)this.getObject("Text")).canBeEncoded()) {
            this.setTextEncoding(ID3TextEncodingConversion.getUnicodeTextEncoding(this.getHeader()));
        }
        super.write(byteArrayOutputStream);
    }

    @Override
    protected void setupObjectList() {
        this.objectList.add(new NumberHashMap("TextEncoding", (AbstractTagFrameBody)this, 1));
        this.objectList.add(new TextEncodedStringSizeTerminated("Text", this));
    }
}

