/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.framebody;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.datatype.StringSizeTerminated;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;

public abstract class AbstractFrameBodyUrlLink
extends AbstractID3v2FrameBody {
    protected AbstractFrameBodyUrlLink() {
    }

    protected AbstractFrameBodyUrlLink(AbstractFrameBodyUrlLink abstractFrameBodyUrlLink) {
        super(abstractFrameBodyUrlLink);
    }

    public AbstractFrameBodyUrlLink(String string) {
        this.setObjectValue("URLLink", string);
    }

    protected AbstractFrameBodyUrlLink(ByteBuffer byteBuffer, int n) throws InvalidTagException {
        super(byteBuffer, n);
    }

    @Override
    public String getUserFriendlyValue() {
        return this.getUrlLink();
    }

    public void setUrlLink(String string) {
        if (string == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.setObjectValue("URLLink", string);
    }

    public String getUrlLink() {
        return (String)this.getObjectValue("URLLink");
    }

    @Override
    public void write(ByteArrayOutputStream byteArrayOutputStream) {
        String string;
        CharsetEncoder charsetEncoder = Charset.forName("ISO-8859-1").newEncoder();
        if (!charsetEncoder.canEncode(string = this.getUrlLink())) {
            this.setUrlLink(this.encodeURL(string));
            if (!charsetEncoder.canEncode(this.getUrlLink())) {
                logger.warning(ErrorMessage.MP3_UNABLE_TO_ENCODE_URL.getMsg(string));
                this.setUrlLink("");
            } else {
                logger.warning(ErrorMessage.MP3_URL_SAVED_ENCODED.getMsg(string, this.getUrlLink()));
            }
        }
        super.write(byteArrayOutputStream);
    }

    @Override
    protected void setupObjectList() {
        this.objectList.add(new StringSizeTerminated("URLLink", this));
    }

    private String encodeURL(String string) {
        try {
            String[] stringArray = string.split("(?<!/)/(?!/)", -1);
            StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuffer.append("/").append(URLEncoder.encode(stringArray[i], "utf-8"));
            }
            return stringBuffer.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.warning("Uable to url encode because utf-8 charset not available:" + unsupportedEncodingException.getMessage());
            return string;
        }
    }
}

