/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.framebody;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.InvalidFrameException;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;

public abstract class AbstractID3v2FrameBody
extends AbstractTagFrameBody {
    protected static final String TYPE_BODY = "body";
    private int size;

    protected AbstractID3v2FrameBody() {
    }

    protected AbstractID3v2FrameBody(AbstractID3v2FrameBody abstractID3v2FrameBody) {
        super(abstractID3v2FrameBody);
    }

    protected AbstractID3v2FrameBody(ByteBuffer byteBuffer, int n) throws InvalidTagException {
        this.setSize(n);
        this.read(byteBuffer);
    }

    @Override
    public abstract String getIdentifier();

    @Override
    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public void setSize() {
        this.size = 0;
        for (AbstractDataType abstractDataType : this.objectList) {
            this.size += abstractDataType.getSize();
        }
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof AbstractID3v2FrameBody && super.equals(object);
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws InvalidTagException {
        int n = this.getSize();
        logger.config("Reading body for" + this.getIdentifier() + ":" + n);
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        int n2 = 0;
        for (AbstractDataType abstractDataType : this.objectList) {
            logger.finest("offset:" + n2);
            if (n2 > n) {
                logger.warning("Invalid Size for FrameBody");
                throw new InvalidFrameException("Invalid size for Frame Body");
            }
            try {
                abstractDataType.readByteArray(byArray, n2);
            }
            catch (InvalidDataTypeException invalidDataTypeException) {
                logger.warning("Problem reading datatype within Frame Body:" + invalidDataTypeException.getMessage());
                throw invalidDataTypeException;
            }
            n2 += abstractDataType.getSize();
        }
    }

    public void write(ByteArrayOutputStream byteArrayOutputStream) {
        logger.config("Writing frame body for" + this.getIdentifier() + ":Est Size:" + this.size);
        for (AbstractDataType abstractDataType : this.objectList) {
            byte[] byArray = abstractDataType.writeByteArray();
            if (byArray == null) continue;
            try {
                byteArrayOutputStream.write(byArray);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.setSize();
        logger.config("Written frame body for" + this.getIdentifier() + ":Real Size:" + this.size);
    }

    @Override
    public void createStructure() {
        MP3File.getStructureFormatter().openHeadingElement(TYPE_BODY, "");
        for (AbstractDataType abstractDataType : this.objectList) {
            abstractDataType.createStructure();
        }
        MP3File.getStructureFormatter().closeHeadingElement(TYPE_BODY);
    }
}

