/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.framebody;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.StringTokenizer;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.datatype.NumberHashMap;
import org.jaudiotagger.tag.datatype.Pair;
import org.jaudiotagger.tag.datatype.PairedTextEncodedStringNullTerminated;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTIPL;
import org.jaudiotagger.tag.id3.framebody.ID3v23FrameBody;

public class FrameBodyIPLS
extends AbstractID3v2FrameBody
implements ID3v23FrameBody {
    public FrameBodyIPLS() {
        this.setObjectValue("TextEncoding", (byte)0);
    }

    public FrameBodyIPLS(ByteBuffer byteBuffer, int n) throws InvalidTagException {
        super(byteBuffer, n);
    }

    @Override
    public String getIdentifier() {
        return "IPLS";
    }

    public FrameBodyIPLS(FrameBodyIPLS frameBodyIPLS) {
        super(frameBodyIPLS);
    }

    public FrameBodyIPLS(byte by, String string) {
        this.setObjectValue("TextEncoding", by);
        this.setText(string);
    }

    public FrameBodyIPLS(FrameBodyTIPL frameBodyTIPL) {
        this.setObjectValue("TextEncoding", frameBodyTIPL.getTextEncoding());
        this.setText(frameBodyTIPL.getText());
    }

    public void setText(String string) {
        PairedTextEncodedStringNullTerminated.ValuePairs valuePairs = new PairedTextEncodedStringNullTerminated.ValuePairs();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\u0000");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) continue;
            valuePairs.add(string2, stringTokenizer.nextToken());
        }
        this.setObjectValue("Text", valuePairs);
    }

    public void addPair(String string) {
        PairedTextEncodedStringNullTerminated.ValuePairs valuePairs = ((PairedTextEncodedStringNullTerminated)this.getObject("Text")).getValue();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\u0000");
        if (stringTokenizer.hasMoreTokens()) {
            valuePairs.add(stringTokenizer.nextToken(), stringTokenizer.nextToken());
        }
    }

    @Override
    public void write(ByteArrayOutputStream byteArrayOutputStream) {
        if (!((PairedTextEncodedStringNullTerminated)this.getObject("Text")).canBeEncoded()) {
            this.setTextEncoding((byte)1);
        }
        super.write(byteArrayOutputStream);
    }

    @Override
    protected void setupObjectList() {
        this.objectList.add(new NumberHashMap("TextEncoding", (AbstractTagFrameBody)this, 1));
        this.objectList.add(new PairedTextEncodedStringNullTerminated("Text", this));
    }

    public PairedTextEncodedStringNullTerminated.ValuePairs getPairing() {
        return (PairedTextEncodedStringNullTerminated.ValuePairs)this.getObject("Text").getValue();
    }

    public String getKeyAtIndex(int n) {
        PairedTextEncodedStringNullTerminated pairedTextEncodedStringNullTerminated = (PairedTextEncodedStringNullTerminated)this.getObject("Text");
        return pairedTextEncodedStringNullTerminated.getValue().getMapping().get(n).getKey();
    }

    public String getValueAtIndex(int n) {
        PairedTextEncodedStringNullTerminated pairedTextEncodedStringNullTerminated = (PairedTextEncodedStringNullTerminated)this.getObject("Text");
        return pairedTextEncodedStringNullTerminated.getValue().getMapping().get(n).getValue();
    }

    public int getNumberOfPairs() {
        PairedTextEncodedStringNullTerminated pairedTextEncodedStringNullTerminated = (PairedTextEncodedStringNullTerminated)this.getObject("Text");
        return pairedTextEncodedStringNullTerminated.getValue().getNumberOfPairs();
    }

    public String getText() {
        PairedTextEncodedStringNullTerminated pairedTextEncodedStringNullTerminated = (PairedTextEncodedStringNullTerminated)this.getObject("Text");
        StringBuilder stringBuilder = new StringBuilder();
        int n = 1;
        for (Pair pair : pairedTextEncodedStringNullTerminated.getValue().getMapping()) {
            stringBuilder.append(pair.getKey() + '\u0000' + pair.getValue());
            if (n != this.getNumberOfPairs()) {
                stringBuilder.append('\u0000');
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    @Override
    public String getUserFriendlyValue() {
        return this.getText();
    }
}

