/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.valuepair;

import java.util.HashMap;
import java.util.Map;

public class ImageFormats {
    public static final String V22_JPG_FORMAT = "JPG";
    public static final String V22_PNG_FORMAT = "PNG";
    public static final String V22_GIF_FORMAT = "GIF";
    public static final String V22_BMP_FORMAT = "BMP";
    public static final String V22_TIF_FORMAT = "TIF";
    public static final String V22_PDF_FORMAT = "PDF";
    public static final String V22_PIC_FORMAT = "PIC";
    public static final String MIME_TYPE_JPEG = "image/jpeg";
    public static final String MIME_TYPE_PNG = "image/png";
    public static final String MIME_TYPE_GIF = "image/gif";
    public static final String MIME_TYPE_BMP = "image/bmp";
    public static final String MIME_TYPE_TIFF = "image/tiff";
    public static final String MIME_TYPE_PDF = "image/pdf";
    public static final String MIME_TYPE_PICT = "image/x-pict";
    public static final String MIME_TYPE_JPG = "image/jpg";
    private static Map<String, String> imageFormatsToMimeType = new HashMap<String, String>();
    private static Map<String, String> imageMimeTypeToFormat = new HashMap<String, String>();

    public static String getMimeTypeForFormat(String string) {
        return imageFormatsToMimeType.get(string);
    }

    public static String getFormatForMimeType(String string) {
        return imageMimeTypeToFormat.get(string);
    }

    public static boolean binaryDataIsPngFormat(byte[] byArray) {
        if (byArray.length < 4) {
            return false;
        }
        return 137 == (byArray[0] & 0xFF) && 80 == (byArray[1] & 0xFF) && 78 == (byArray[2] & 0xFF) && 71 == (byArray[3] & 0xFF);
    }

    public static boolean binaryDataIsJpgFormat(byte[] byArray) {
        if (byArray.length < 4) {
            return false;
        }
        return 255 == (byArray[0] & 0xFF) && 216 == (byArray[1] & 0xFF) && 255 == (byArray[2] & 0xFF) && 224 <= (byArray[3] & 0xFF);
    }

    public static boolean binaryDataIsGifFormat(byte[] byArray) {
        if (byArray.length < 3) {
            return false;
        }
        return 71 == (byArray[0] & 0xFF) && 73 == (byArray[1] & 0xFF) && 70 == (byArray[2] & 0xFF);
    }

    public static boolean binaryDataIsBmpFormat(byte[] byArray) {
        if (byArray.length < 2) {
            return false;
        }
        return 66 == (byArray[0] & 0xFF) && 77 == (byArray[1] & 0xFF);
    }

    public static boolean binaryDataIsPdfFormat(byte[] byArray) {
        if (byArray.length < 4) {
            return false;
        }
        return 37 == (byArray[0] & 0xFF) && 80 == (byArray[1] & 0xFF) && 68 == (byArray[2] & 0xFF) && 70 == (byArray[3] & 0xFF);
    }

    public static boolean binaryDataIsTiffFormat(byte[] byArray) {
        if (byArray.length < 4) {
            return false;
        }
        return 73 == (byArray[0] & 0xFF) && 73 == (byArray[1] & 0xFF) && 42 == (byArray[2] & 0xFF) && 0 == (byArray[3] & 0xFF) || 77 == (byArray[0] & 0xFF) && 77 == (byArray[1] & 0xFF) && 0 == (byArray[2] & 0xFF) && 42 == (byArray[3] & 0xFF);
    }

    public static boolean isPortableFormat(byte[] byArray) {
        return ImageFormats.binaryDataIsPngFormat(byArray) || ImageFormats.binaryDataIsJpgFormat(byArray) || ImageFormats.binaryDataIsGifFormat(byArray);
    }

    public static String getMimeTypeForBinarySignature(byte[] byArray) {
        if (ImageFormats.binaryDataIsPngFormat(byArray)) {
            return MIME_TYPE_PNG;
        }
        if (ImageFormats.binaryDataIsJpgFormat(byArray)) {
            return MIME_TYPE_JPEG;
        }
        if (ImageFormats.binaryDataIsGifFormat(byArray)) {
            return MIME_TYPE_GIF;
        }
        if (ImageFormats.binaryDataIsBmpFormat(byArray)) {
            return MIME_TYPE_BMP;
        }
        if (ImageFormats.binaryDataIsPdfFormat(byArray)) {
            return MIME_TYPE_PDF;
        }
        if (ImageFormats.binaryDataIsTiffFormat(byArray)) {
            return MIME_TYPE_TIFF;
        }
        return null;
    }

    static {
        imageFormatsToMimeType.put(V22_JPG_FORMAT, MIME_TYPE_JPEG);
        imageFormatsToMimeType.put(V22_PNG_FORMAT, MIME_TYPE_PNG);
        imageFormatsToMimeType.put(V22_GIF_FORMAT, MIME_TYPE_GIF);
        imageFormatsToMimeType.put(V22_BMP_FORMAT, MIME_TYPE_BMP);
        imageFormatsToMimeType.put(V22_TIF_FORMAT, MIME_TYPE_TIFF);
        imageFormatsToMimeType.put(V22_PDF_FORMAT, MIME_TYPE_PDF);
        imageFormatsToMimeType.put(V22_PIC_FORMAT, MIME_TYPE_PICT);
        for (String string : imageFormatsToMimeType.keySet()) {
            String string2 = imageFormatsToMimeType.get(string);
            imageMimeTypeToFormat.put(string2, string);
        }
        imageMimeTypeToFormat.put(MIME_TYPE_JPG, V22_JPG_FORMAT);
    }
}

