/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.lyrics3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.TagNotFoundException;
import org.jaudiotagger.tag.id3.AbstractTag;
import org.jaudiotagger.tag.id3.ID3Tags;
import org.jaudiotagger.tag.id3.ID3v1Tag;
import org.jaudiotagger.tag.lyrics3.AbstractLyrics3;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyLYR;
import org.jaudiotagger.tag.lyrics3.Lyrics3v2;

public class Lyrics3v1
extends AbstractLyrics3 {
    private String lyric = "";

    public Lyrics3v1() {
    }

    public Lyrics3v1(Lyrics3v1 lyrics3v1) {
        super(lyrics3v1);
        this.lyric = lyrics3v1.lyric;
    }

    public Lyrics3v1(AbstractTag abstractTag) {
        if (abstractTag != null) {
            if (abstractTag instanceof Lyrics3v1) {
                throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
            }
            Lyrics3v2 lyrics3v2 = abstractTag instanceof Lyrics3v2 ? (Lyrics3v2)abstractTag : new Lyrics3v2(abstractTag);
            FieldFrameBodyLYR fieldFrameBodyLYR = (FieldFrameBodyLYR)lyrics3v2.getField("LYR").getBody();
            this.lyric = fieldFrameBodyLYR.getLyric();
        }
    }

    public Lyrics3v1(ByteBuffer byteBuffer) throws TagNotFoundException, IOException {
        try {
            this.read(byteBuffer);
        }
        catch (TagException tagException) {
            tagException.printStackTrace();
        }
    }

    @Override
    public String getIdentifier() {
        return "Lyrics3v1.00";
    }

    public void setLyric(String string) {
        this.lyric = ID3Tags.truncate(string, 5100);
    }

    public String getLyric() {
        return this.lyric;
    }

    @Override
    public int getSize() {
        return "LYRICSBEGIN".length() + this.lyric.length() + "LYRICSEND".length();
    }

    @Override
    public boolean isSubsetOf(Object object) {
        return object instanceof Lyrics3v1 && ((Lyrics3v1)object).lyric.contains(this.lyric);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Lyrics3v1)) {
            return false;
        }
        Lyrics3v1 lyrics3v1 = (Lyrics3v1)object;
        return this.lyric.equals(lyrics3v1.lyric) && super.equals(object);
    }

    @Override
    public Iterator iterator() {
        throw new UnsupportedOperationException("Method iterator() not yet implemented.");
    }

    @Override
    public boolean seek(ByteBuffer byteBuffer) {
        return false;
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws TagException {
        byte[] byArray = new byte[5120];
        if (!this.seek(byteBuffer)) {
            throw new TagNotFoundException("ID3v1 tag not found");
        }
        byteBuffer.get(byArray);
        String string = new String(byArray);
        this.lyric = string.substring(0, string.indexOf("LYRICSEND"));
    }

    public boolean seek(RandomAccessFile randomAccessFile) throws IOException {
        long l;
        byte[] byArray = new byte[5120];
        randomAccessFile.seek(randomAccessFile.length() - 128L - 9L);
        randomAccessFile.read(byArray, 0, 9);
        String string = new String(byArray, 0, 9);
        if (string.equals("LYRICSEND")) {
            l = randomAccessFile.getFilePointer();
        } else {
            randomAccessFile.seek(randomAccessFile.length() - 9L);
            randomAccessFile.read(byArray, 0, 9);
            string = new String(byArray, 0, 9);
            if (string.equals("LYRICSEND")) {
                l = randomAccessFile.getFilePointer();
            } else {
                return false;
            }
        }
        randomAccessFile.seek(l -= 5120L);
        randomAccessFile.read(byArray);
        String string2 = new String(byArray);
        int n = string2.indexOf("LYRICSBEGIN");
        if (n == -1) {
            return false;
        }
        randomAccessFile.seek(l + (long)n + 11L);
        return true;
    }

    public String toString() {
        String string = this.getIdentifier() + " " + this.getSize() + "\n";
        return string + this.lyric;
    }

    @Override
    public void write(RandomAccessFile randomAccessFile) throws IOException {
        int n;
        ID3v1Tag iD3v1Tag = null;
        this.delete(randomAccessFile);
        randomAccessFile.seek(randomAccessFile.length());
        byte[] byArray = new byte[this.lyric.length() + 11 + 9];
        String string = "LYRICSBEGIN";
        for (n = 0; n < string.length(); ++n) {
            byArray[n] = (byte)string.charAt(n);
        }
        int n2 = string.length();
        string = ID3Tags.truncate(this.lyric, 5100);
        for (n = 0; n < string.length(); ++n) {
            byArray[n + n2] = (byte)string.charAt(n);
        }
        n2 += string.length();
        string = "LYRICSEND";
        for (n = 0; n < string.length(); ++n) {
            byArray[n + n2] = (byte)string.charAt(n);
        }
        randomAccessFile.write(byArray, 0, n2 += string.length());
        if (iD3v1Tag != null) {
            iD3v1Tag.write(randomAccessFile);
        }
    }
}

