/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.mp4.field;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.mp4.Mp4TagField;
import org.jaudiotagger.tag.mp4.field.Mp4FieldType;

public class Mp4TagRawBinaryField
extends Mp4TagField {
    protected int dataSize;
    protected byte[] dataBytes;

    public Mp4TagRawBinaryField(Mp4BoxHeader mp4BoxHeader, ByteBuffer byteBuffer) throws UnsupportedEncodingException {
        super(mp4BoxHeader.getId());
        this.dataSize = mp4BoxHeader.getDataLength();
        this.build(byteBuffer);
    }

    @Override
    public Mp4FieldType getFieldType() {
        return Mp4FieldType.IMPLICIT;
    }

    @Override
    protected byte[] getDataBytes() throws UnsupportedEncodingException {
        return this.dataBytes;
    }

    @Override
    protected void build(ByteBuffer byteBuffer) {
        this.dataBytes = new byte[this.dataSize];
        for (int i = 0; i < this.dataBytes.length; ++i) {
            this.dataBytes[i] = byteBuffer.get();
        }
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.dataBytes.length == 0;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public byte[] getData() {
        return this.dataBytes;
    }

    public void setData(byte[] byArray) {
        this.dataBytes = byArray;
    }

    @Override
    public void copyContent(TagField tagField) {
        throw new UnsupportedOperationException("not done");
    }

    @Override
    public byte[] getRawContent() throws UnsupportedEncodingException {
        logger.fine("Getting Raw data for:" + this.getId());
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(Utils.getSizeBEInt32(8 + this.dataSize));
            byteArrayOutputStream.write(Utils.getDefaultBytes(this.getId(), "ISO-8859-1"));
            byteArrayOutputStream.write(this.dataBytes);
            System.out.println("SIZE" + byteArrayOutputStream.size());
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

