/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.mp4.field;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagTextField;
import org.jaudiotagger.tag.mp4.Mp4FieldKey;
import org.jaudiotagger.tag.mp4.Mp4TagField;
import org.jaudiotagger.tag.mp4.atom.Mp4DataBox;
import org.jaudiotagger.tag.mp4.atom.Mp4MeanBox;
import org.jaudiotagger.tag.mp4.atom.Mp4NameBox;
import org.jaudiotagger.tag.mp4.field.Mp4FieldType;

public class Mp4TagReverseDnsField
extends Mp4TagField
implements TagTextField {
    public static final String IDENTIFIER = "----";
    protected int dataSize;
    private String issuer;
    private String descriptor;
    protected String content;

    public Mp4TagReverseDnsField(Mp4BoxHeader mp4BoxHeader, ByteBuffer byteBuffer) throws UnsupportedEncodingException {
        super(mp4BoxHeader, byteBuffer);
    }

    public Mp4TagReverseDnsField(Mp4FieldKey mp4FieldKey, String string) {
        super(mp4FieldKey.getFieldName());
        this.issuer = mp4FieldKey.getIssuer();
        this.descriptor = mp4FieldKey.getIdentifier();
        this.content = string;
    }

    public Mp4TagReverseDnsField(String string, String string2, String string3, String string4) {
        super(string);
        this.issuer = string2;
        this.descriptor = string3;
        this.content = string4;
    }

    @Override
    public Mp4FieldType getFieldType() {
        return Mp4FieldType.TEXT;
    }

    @Override
    protected void build(ByteBuffer byteBuffer) throws UnsupportedEncodingException {
        Mp4BoxHeader mp4BoxHeader = new Mp4BoxHeader(byteBuffer);
        Mp4MeanBox mp4MeanBox = new Mp4MeanBox(mp4BoxHeader, byteBuffer);
        this.setIssuer(mp4MeanBox.getIssuer());
        byteBuffer.position(byteBuffer.position() + mp4BoxHeader.getDataLength());
        Mp4BoxHeader mp4BoxHeader2 = new Mp4BoxHeader(byteBuffer);
        Mp4NameBox mp4NameBox = new Mp4NameBox(mp4BoxHeader2, byteBuffer);
        this.setDescriptor(mp4NameBox.getName());
        byteBuffer.position(byteBuffer.position() + mp4BoxHeader2.getDataLength());
        if (this.parentHeader.getDataLength() == mp4BoxHeader.getLength() + mp4BoxHeader2.getLength()) {
            this.id = "----:" + this.issuer + ":" + this.descriptor;
            this.setContent("");
            logger.warning(ErrorMessage.MP4_REVERSE_DNS_FIELD_HAS_NO_DATA.getMsg(this.id));
        } else {
            Mp4BoxHeader mp4BoxHeader3 = new Mp4BoxHeader(byteBuffer);
            Mp4DataBox mp4DataBox = new Mp4DataBox(mp4BoxHeader3, byteBuffer);
            this.setContent(mp4DataBox.getContent());
            byteBuffer.position(byteBuffer.position() + mp4BoxHeader3.getDataLength());
            this.id = "----:" + this.issuer + ":" + this.descriptor;
        }
    }

    @Override
    public void copyContent(TagField tagField) {
        if (tagField instanceof Mp4TagReverseDnsField) {
            this.issuer = ((Mp4TagReverseDnsField)tagField).getIssuer();
            this.descriptor = ((Mp4TagReverseDnsField)tagField).getDescriptor();
            this.content = ((Mp4TagReverseDnsField)tagField).getContent();
        }
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    protected byte[] getDataBytes() throws UnsupportedEncodingException {
        return this.content.getBytes(this.getEncoding());
    }

    @Override
    public String getEncoding() {
        return "UTF-8";
    }

    @Override
    public byte[] getRawContent() throws UnsupportedEncodingException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = this.issuer.getBytes(this.getEncoding());
            byteArrayOutputStream.write(Utils.getSizeBEInt32(12 + byArray.length));
            byteArrayOutputStream.write(Utils.getDefaultBytes("mean", "ISO-8859-1"));
            byteArrayOutputStream.write(new byte[]{0, 0, 0, 0});
            byteArrayOutputStream.write(byArray);
            byte[] byArray2 = this.descriptor.getBytes(this.getEncoding());
            byteArrayOutputStream.write(Utils.getSizeBEInt32(12 + byArray2.length));
            byteArrayOutputStream.write(Utils.getDefaultBytes("name", "ISO-8859-1"));
            byteArrayOutputStream.write(new byte[]{0, 0, 0, 0});
            byteArrayOutputStream.write(byArray2);
            if (this.content.length() > 0) {
                byteArrayOutputStream.write(this.getRawContentDataOnly());
            }
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            byteArrayOutputStream2.write(Utils.getSizeBEInt32(8 + byteArrayOutputStream.size()));
            byteArrayOutputStream2.write(Utils.getDefaultBytes(IDENTIFIER, "ISO-8859-1"));
            byteArrayOutputStream2.write(byteArrayOutputStream.toByteArray());
            return byteArrayOutputStream2.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public byte[] getRawContentDataOnly() throws UnsupportedEncodingException {
        logger.fine("Getting Raw data for:" + this.getId());
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = this.content.getBytes(this.getEncoding());
            byteArrayOutputStream.write(Utils.getSizeBEInt32(16 + byArray.length));
            byteArrayOutputStream.write(Utils.getDefaultBytes("data", "ISO-8859-1"));
            byteArrayOutputStream.write(new byte[]{0});
            byteArrayOutputStream.write(new byte[]{0, 0, (byte)this.getFieldType().getFileClassId()});
            byteArrayOutputStream.write(new byte[]{0, 0, 0, 0});
            byteArrayOutputStream.write(byArray);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.content.trim().equals("");
    }

    @Override
    public void setContent(String string) {
        this.content = string;
    }

    @Override
    public void setEncoding(String string) {
    }

    @Override
    public String toString() {
        return this.content;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setIssuer(String string) {
        this.issuer = string;
    }

    public void setDescriptor(String string) {
        this.descriptor = string;
    }
}

