/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.mp4.field;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagTextField;
import org.jaudiotagger.tag.mp4.Mp4TagField;
import org.jaudiotagger.tag.mp4.atom.Mp4DataBox;
import org.jaudiotagger.tag.mp4.field.Mp4FieldType;

public class Mp4TagTextField
extends Mp4TagField
implements TagTextField {
    protected int dataSize;
    protected String content;

    public Mp4TagTextField(String string, ByteBuffer byteBuffer) throws UnsupportedEncodingException {
        super(string, byteBuffer);
    }

    public Mp4TagTextField(String string, String string2) {
        super(string);
        this.content = string2;
    }

    @Override
    protected void build(ByteBuffer byteBuffer) throws UnsupportedEncodingException {
        Mp4BoxHeader mp4BoxHeader = new Mp4BoxHeader(byteBuffer);
        Mp4DataBox mp4DataBox = new Mp4DataBox(mp4BoxHeader, byteBuffer);
        this.dataSize = mp4BoxHeader.getDataLength();
        this.content = mp4DataBox.getContent();
    }

    @Override
    public void copyContent(TagField tagField) {
        if (tagField instanceof Mp4TagTextField) {
            this.content = ((Mp4TagTextField)tagField).getContent();
        }
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    protected byte[] getDataBytes() throws UnsupportedEncodingException {
        return this.content.getBytes(this.getEncoding());
    }

    @Override
    public Mp4FieldType getFieldType() {
        return Mp4FieldType.TEXT;
    }

    @Override
    public String getEncoding() {
        return "UTF-8";
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.content.trim().equals("");
    }

    @Override
    public void setContent(String string) {
        this.content = string;
    }

    @Override
    public void setEncoding(String string) {
    }

    @Override
    public String toString() {
        return this.content;
    }
}

