/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.content;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.content.ContentException;
import com.aelitis.azureus.core.content.RelatedContent;
import com.aelitis.azureus.core.content.RelatedContentLookupListener;
import com.aelitis.azureus.core.content.RelatedContentManagerListener;
import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.FeatureAvailability;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import com.aelitis.azureus.plugins.dht.DHTPluginContact;
import com.aelitis.azureus.plugins.dht.DHTPluginOperationListener;
import com.aelitis.azureus.plugins.dht.DHTPluginValue;
import com.aelitis.azureus.util.ImportExportUtils;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.StringInterner;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabase;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseContact;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseException;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseKey;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseProgressListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseTransferHandler;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseTransferType;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseValue;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.utils.search.SearchException;
import org.gudy.azureus2.plugins.utils.search.SearchInstance;
import org.gudy.azureus2.plugins.utils.search.SearchObserver;
import org.gudy.azureus2.plugins.utils.search.SearchResult;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

public class RelatedContentManager
implements DistributedDatabaseTransferHandler {
    private static final boolean TRACE = false;
    public static final boolean DISABLE_ALL_UI = !Constants.isCVSVersion() && COConfigurationManager.getStringParameter("ui", "az3").equals("az3");
    private static final int MAX_HISTORY = 16;
    private static final int MAX_TITLE_LENGTH = 80;
    private static final int MAX_CONCURRENT_PUBLISH = 2;
    private static final int MAX_REMOTE_SEARCH_RESULTS = 30;
    private static final int MAX_REMOTE_SEARCH_CONTACTS = 50;
    private static final int MAX_REMOTE_SEARCH_MILLIS = 25000;
    private static final int TEMPORARY_SPACE_DELTA = 50;
    private static final int MAX_RANK = 100;
    private static final String CONFIG_FILE = "rcm.config";
    private static final String PERSIST_DEL_FILE = "rcmx.config";
    private static final String CONFIG_TOTAL_UNREAD = "rcm.numunread.cache";
    private static RelatedContentManager singleton;
    private static AzureusCore core;
    private PluginInterface plugin_interface;
    private TorrentAttribute ta_networks;
    private DHTPlugin dht_plugin;
    private long global_random_id = -1L;
    private LinkedList<DownloadInfo> download_infos1 = new LinkedList();
    private LinkedList<DownloadInfo> download_infos2 = new LinkedList();
    private ByteArrayHashMapEx<DownloadInfo> download_info_map = new ByteArrayHashMapEx();
    private Set<String> download_priv_set = new HashSet<String>();
    private final boolean enabled;
    private int max_search_level;
    private int max_results;
    private AtomicInteger temporary_space = new AtomicInteger();
    private int publishing_count = 0;
    private CopyOnWriteList<RelatedContentManagerListener> listeners = new CopyOnWriteList();
    private AESemaphore initialisation_complete_sem = new AESemaphore("RCM:init");
    private static final int TIMER_PERIOD = 30000;
    private static final int CONFIG_SAVE_PERIOD = 60000;
    private static final int CONFIG_SAVE_TICKS = 2;
    private static final int PUBLISH_CHECK_PERIOD = 30000;
    private static final int PUBLISH_CHECK_TICKS = 1;
    private static final int SECONDARY_LOOKUP_PERIOD = 900000;
    private static final int SECONDARY_LOOKUP_TICKS = 30;
    private static final int REPUBLISH_PERIOD = 28800000;
    private static final int REPUBLISH_TICKS = 960;
    private static final int INITIAL_PUBLISH_DELAY = 180000;
    private static final int INITIAL_PUBLISH_TICKS = 6;
    private static final int CONFIG_DISCARD_MILLIS = 60000;
    private ContentCache content_cache_ref;
    private WeakReference<ContentCache> content_cache;
    private boolean content_dirty;
    private long last_config_access;
    private int content_discard_ticks;
    private AtomicInteger total_unread = new AtomicInteger(COConfigurationManager.getIntParameter("rcm.numunread.cache", 0));
    private AsyncDispatcher content_change_dispatcher = new AsyncDispatcher();
    private static final int SECONDARY_LOOKUP_CACHE_MAX = 10;
    private LinkedList<SecondaryLookup> secondary_lookups = new LinkedList();
    private boolean secondary_lookup_in_progress;
    private long secondary_lookup_complete_time;
    private DistributedDatabase ddb;
    private RCMSearchXFer transfer_type = new RCMSearchXFer();
    private boolean persist;
    private static final int PD_BLOOM_INITIAL_SIZE = 1000;
    private static final int PD_BLOOM_INCREMENT_SIZE = 1000;
    private BloomFilter persist_del_bloom;

    public static synchronized void preInitialise(AzureusCore azureusCore) {
        core = azureusCore;
    }

    public static synchronized RelatedContentManager getSingleton() throws ContentException {
        if (singleton == null) {
            singleton = new RelatedContentManager();
        }
        return singleton;
    }

    protected RelatedContentManager() throws ContentException {
        COConfigurationManager.addAndFireParameterListener("rcm.persist", new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                RelatedContentManager.this.persist = COConfigurationManager.getBooleanParameter("rcm.persist");
            }
        });
        if (!FeatureAvailability.isRCMEnabled()) {
            this.enabled = false;
            return;
        }
        this.enabled = true;
        try {
            if (core == null) {
                throw new ContentException("getSingleton called before pre-initialisation");
            }
            while (this.global_random_id == -1L) {
                this.global_random_id = COConfigurationManager.getLongParameter("rcm.random.id", -1L);
                if (this.global_random_id != -1L) continue;
                this.global_random_id = RandomUtils.nextLong();
                COConfigurationManager.setParameter("rcm.random.id", this.global_random_id);
            }
            this.plugin_interface = core.getPluginManager().getDefaultPluginInterface();
            this.ta_networks = this.plugin_interface.getTorrentManager().getAttribute("Networks");
            COConfigurationManager.addAndFireParameterListeners(new String[]{"rcm.ui.enabled", "rcm.max_search_level", "rcm.max_results"}, new ParameterListener(){

                @Override
                public void parameterChanged(String string) {
                    RelatedContentManager.this.max_search_level = COConfigurationManager.getIntParameter("rcm.max_search_level", 3);
                    RelatedContentManager.this.max_results = COConfigurationManager.getIntParameter("rcm.max_results", 500);
                }
            });
            this.plugin_interface.getUtilities().createDelayedTask(new AERunnable(){

                @Override
                public void runSupport() {
                    SimpleTimer.addEvent("rcm.delay.init", SystemTime.getOffsetTime(15000L), new TimerEventPerformer(){

                        @Override
                        public void perform(TimerEvent timerEvent2) {
                            RelatedContentManager.this.delayedInit();
                        }
                    });
                }
            }).queue();
        }
        catch (Throwable throwable) {
            this.initialisation_complete_sem.releaseForever();
            if (throwable instanceof ContentException) {
                throw (ContentException)throwable;
            }
            throw new ContentException("Initialisation failed", throwable);
        }
    }

    private void delayedInit() {
        this.plugin_interface.addListener(new PluginListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initializationComplete() {
                if (!RelatedContentManager.this.persist) {
                    RelatedContentManager.this.deleteRelatedContent();
                }
                try {
                    PluginInterface pluginInterface = RelatedContentManager.this.plugin_interface.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
                    if (pluginInterface != null) {
                        RelatedContentManager.this.dht_plugin = (DHTPlugin)pluginInterface.getPlugin();
                        if (!RelatedContentManager.this.dht_plugin.isEnabled()) {
                            return;
                        }
                        DownloadManager downloadManager = RelatedContentManager.this.plugin_interface.getDownloadManager();
                        Download[] downloadArray = downloadManager.getDownloads();
                        RelatedContentManager.this.addDownloads(downloadArray, true);
                        downloadManager.addListener(new DownloadManagerListener(){

                            @Override
                            public void downloadAdded(Download download) {
                                RelatedContentManager.this.addDownloads(new Download[]{download}, false);
                            }

                            @Override
                            public void downloadRemoved(Download download) {
                            }
                        }, false);
                        SimpleTimer.addPeriodicEvent("RCM:publisher", 30000L, new TimerEventPerformer(){
                            private int tick_count;

                            @Override
                            public void perform(TimerEvent timerEvent2) {
                                ++this.tick_count;
                                if (this.tick_count == 1) {
                                    try {
                                        RelatedContentManager.this.ddb = RelatedContentManager.this.plugin_interface.getDistributedDatabase();
                                        RelatedContentManager.this.ddb.addTransferHandler(RelatedContentManager.this.transfer_type, RelatedContentManager.this);
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                                if (RelatedContentManager.this.enabled && this.tick_count >= 6) {
                                    if (this.tick_count % 1 == 0) {
                                        RelatedContentManager.this.publish();
                                    }
                                    if (this.tick_count % 30 == 0) {
                                        RelatedContentManager.this.secondaryLookup();
                                    }
                                    if (this.tick_count % 960 == 0) {
                                        RelatedContentManager.this.republish();
                                    }
                                    if (this.tick_count % 2 == 0) {
                                        RelatedContentManager.this.saveRelatedContent();
                                    }
                                }
                            }
                        });
                    }
                }
                finally {
                    RelatedContentManager.this.initialisation_complete_sem.releaseForever();
                }
            }

            @Override
            public void closedownInitiated() {
                RelatedContentManager.this.saveRelatedContent();
            }

            @Override
            public void closedownComplete() {
            }
        });
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getMaxSearchLevel() {
        return this.max_search_level;
    }

    public void setMaxSearchLevel(int n) {
        COConfigurationManager.setParameter("rcm.max_search_level", n);
    }

    public int getMaxResults() {
        return this.max_results;
    }

    public void setMaxResults(int n) {
        COConfigurationManager.setParameter("rcm.max_results", n);
        this.enforceMaxResults(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDownloads(Download[] downloadArray, boolean bl) {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            ArrayList<DownloadInfo> arrayList = new ArrayList<DownloadInfo>(downloadArray.length);
            for (Download map2 : downloadArray) {
                try {
                    int n;
                    DownloadManagerState downloadManagerState;
                    String[] stringArray;
                    byte[] byArray;
                    Torrent torrent;
                    if (!map2.isPersistent() || (torrent = map2.getTorrent()) == null || this.download_info_map.containsKey(byArray = torrent.getHash()) || (stringArray = map2.getListAttribute(this.ta_networks)) == null) continue;
                    boolean bl2 = false;
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!stringArray[i].equalsIgnoreCase("Public")) continue;
                        bl2 = true;
                        break;
                    }
                    TOTorrent tOTorrent = PluginCoreUtils.unwrap(torrent);
                    if (!bl2 || TorrentUtils.isReallyPrivate(tOTorrent) || (downloadManagerState = PluginCoreUtils.unwrap(map2).getDownloadState()).getFlag(16L)) continue;
                    long l = this.global_random_id ^ downloadManagerState.getLongParameter("rand");
                    long l2 = downloadManagerState.getLongAttribute("scrapecache");
                    if (l2 == -1L) {
                        n = -1;
                    } else {
                        int n2 = (int)(l2 >> 32 & 0xFFFFFFL);
                        int n3 = (int)(l2 & 0xFFFFFFL);
                        n = n2 << 16 | n3 & 0xFFFF;
                    }
                    DownloadInfo downloadInfo = new DownloadInfo(byArray, byArray, map2.getName(), (int)l, torrent.isPrivate() ? StringInterner.intern(torrent.getAnnounceURL().getHost()) : null, 0, false, torrent.getSize(), (int)(tOTorrent.getCreationDate() / 3600L), n, (byte)PlatformTorrentUtils.getContentNetworkID(tOTorrent));
                    arrayList.add(downloadInfo);
                    if (bl || this.download_infos1.size() == 0) {
                        this.download_infos1.add(downloadInfo);
                    } else {
                        this.download_infos1.add(RandomUtils.nextInt(this.download_infos1.size()), downloadInfo);
                    }
                    this.download_infos2.add(downloadInfo);
                    this.download_info_map.put(byArray, downloadInfo);
                    if (downloadInfo.getTracker() == null) continue;
                    this.download_priv_set.add(this.getPrivateInfoKey(downloadInfo));
                }
                catch (Throwable throwable) {
                    Debug.out(throwable);
                }
            }
            List list = COConfigurationManager.getListParameter("rcm.dlinfo.history", new ArrayList());
            if (bl) {
                int n = 16 - this.download_info_map.size();
                for (int i = 0; i < list.size() && n > 0; ++i) {
                    try {
                        DownloadInfo downloadInfo = this.deserialiseDI((Map)list.get(i), null);
                        if (downloadInfo == null || this.download_info_map.containsKey(downloadInfo.getHash())) continue;
                        this.download_info_map.put(downloadInfo.getHash(), downloadInfo);
                        if (downloadInfo.getTracker() != null) {
                            this.download_priv_set.add(this.getPrivateInfoKey(downloadInfo));
                        }
                        this.download_infos1.add(downloadInfo);
                        this.download_infos2.add(downloadInfo);
                        --n;
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                Collections.shuffle(this.download_infos1);
            } else if (arrayList.size() > 0) {
                for (DownloadInfo downloadInfo : arrayList) {
                    Map<String, Object> map = this.serialiseDI(downloadInfo, null);
                    if (map == null) continue;
                    list.add(map);
                }
                while (list.size() > 16) {
                    list.remove(0);
                }
                COConfigurationManager.setParameter("rcm.dlinfo.history", list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void republish() {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            if (this.publishing_count > 0) {
                return;
            }
            if (this.download_infos1.isEmpty()) {
                List list = this.download_info_map.values();
                this.download_infos1.addAll(list);
                this.download_infos2.addAll(list);
                Collections.shuffle(this.download_infos1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publish() {
        while (true) {
            Object object;
            DownloadInfo downloadInfo = null;
            DownloadInfo downloadInfo2 = null;
            RelatedContentManager relatedContentManager = this;
            synchronized (relatedContentManager) {
                if (this.publishing_count >= 2) {
                    return;
                }
                if (this.download_infos1.isEmpty() || this.download_info_map.size() == 1) {
                    return;
                }
                downloadInfo = this.download_infos1.removeFirst();
                object = this.download_infos2.iterator();
                while (object.hasNext()) {
                    downloadInfo2 = (DownloadInfo)object.next();
                    if (downloadInfo == downloadInfo2 && this.download_infos2.size() != 1) continue;
                    object.remove();
                    break;
                }
                if (downloadInfo == downloadInfo2 && ((downloadInfo2 = this.download_info_map.getRandomValueExcluding(downloadInfo)) == null || downloadInfo == downloadInfo2)) {
                    return;
                }
                ++this.publishing_count;
            }
            try {
                this.publish(downloadInfo, downloadInfo2);
                continue;
            }
            catch (Throwable throwable) {
                object = this;
                synchronized (object) {
                    --this.publishing_count;
                }
                Debug.out(throwable);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishNext() {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            --this.publishing_count;
            if (this.publishing_count < 0) {
                this.publishing_count = 0;
            }
        }
        this.publish();
    }

    protected void publish(final DownloadInfo downloadInfo, DownloadInfo downloadInfo2) throws Exception {
        long l;
        final String string = ByteFormatter.encodeString(downloadInfo.getHash());
        final String string2 = ByteFormatter.encodeString(downloadInfo2.getHash());
        final byte[] byArray = ("az:rcm:assoc:" + string).getBytes("UTF-8");
        String string3 = downloadInfo2.getTitle();
        if (string3.length() > 80) {
            string3 = string3.substring(0, 80);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("d", string3);
        hashMap.put("r", new Long(Math.abs(downloadInfo2.getRand() % 1000)));
        String string4 = downloadInfo2.getTracker();
        if (string4 == null) {
            hashMap.put("h", downloadInfo2.getHash());
        } else {
            hashMap.put("t", string4);
        }
        if (downloadInfo2.getLevel() == 0) {
            try {
                Download download = downloadInfo2.getRelatedToDownload();
                if (download != null) {
                    long l2;
                    Torrent torrent = download.getTorrent();
                    if (torrent != null) {
                        long l3;
                        long l4 = PlatformTorrentUtils.getContentNetworkID(PluginCoreUtils.unwrap(torrent));
                        if (l4 != -1L) {
                            hashMap.put("c", new Long(l4));
                        }
                        if ((l3 = (l2 = torrent.getCreationDate()) / 3600L) > 0L) {
                            hashMap.put("p", new Long(l3));
                        }
                    }
                    int n = -1;
                    int n2 = -1;
                    l2 = PluginCoreUtils.unwrap(download).getDownloadState().getLongAttribute("scrapecache");
                    if (l2 != -1L) {
                        n2 = (int)(l2 >> 32 & 0xFFFFFFL);
                        n = (int)(l2 & 0xFFFFFFL);
                    }
                    if (n > 0) {
                        hashMap.put("l", new Long(n));
                    }
                    if (n2 > 0) {
                        hashMap.put("z", new Long(n2));
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((l = downloadInfo2.getSize()) != 0L) {
            hashMap.put("s", new Long(l));
        }
        final byte[] byArray2 = BEncoder.encode(hashMap);
        this.dht_plugin.get(byArray, "Content relationship read: " + string, (byte)0, 30, 30000L, false, false, new DHTPluginOperationListener(){
            private boolean diversified;
            private int hits;
            private Set<String> entries = new HashSet<String>();

            @Override
            public void starts(byte[] byArray3) {
            }

            @Override
            public void diversified() {
                this.diversified = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueRead(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                try {
                    Map map = BDecoder.decode(dHTPluginValue.getValue());
                    String string4 = new String((byte[])map.get("d"), "UTF-8");
                    String string22 = null;
                    byte[] byArray3 = (byte[])map.get("h");
                    if (byArray3 == null) {
                        string22 = new String((byte[])map.get("t"), "UTF-8");
                    }
                    int n = ((Long)map.get("r")).intValue();
                    String string3 = string4 + " % " + n;
                    Object object = this.entries;
                    synchronized (object) {
                        if (this.entries.contains(string3)) {
                            return;
                        }
                        this.entries.add(string3);
                    }
                    object = (Long)map.get("s");
                    long l = object == null ? 0L : (Long)object;
                    Long l2 = (Long)map.get("c");
                    Long l3 = (Long)map.get("p");
                    Long l4 = (Long)map.get("l");
                    Long l5 = (Long)map.get("z");
                    int n2 = l4 == null && l5 == null ? -1 : (l4 == null ? l5.intValue() << 16 : (l5 == null ? l4.intValue() & 0xFFFF : l5.intValue() << 16 | l4.intValue() & 0xFFFF));
                    RelatedContentManager.this.analyseResponse(new DownloadInfo(downloadInfo.getHash(), byArray3, string4, n, string22, 1, false, l, l3 == null ? 0 : l3.intValue(), n2, (byte)(l2 == null ? -1L : (long)l2.byteValue())), null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++this.hits;
            }

            @Override
            public void valueWritten(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
            }

            @Override
            public void complete(byte[] byArray3, boolean bl) {
                boolean bl2;
                if (this.diversified || this.hits >= 10) {
                    bl2 = false;
                } else if (this.hits <= 5) {
                    bl2 = true;
                } else {
                    boolean bl3 = bl2 = RandomUtils.nextInt(this.hits - 5 + 1) == 0;
                }
                if (bl2) {
                    try {
                        RelatedContentManager.this.dht_plugin.put(byArray, "Content relationship: " + string + " -> " + string2, byArray2, (byte)16, new DHTPluginOperationListener(){

                            @Override
                            public void diversified() {
                            }

                            @Override
                            public void starts(byte[] byArray) {
                            }

                            @Override
                            public void valueRead(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                            }

                            @Override
                            public void valueWritten(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                            }

                            @Override
                            public void complete(byte[] byArray, boolean bl) {
                                RelatedContentManager.this.publishNext();
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                        RelatedContentManager.this.publishNext();
                    }
                } else {
                    RelatedContentManager.this.publishNext();
                }
            }
        });
    }

    public void lookupContent(final byte[] byArray, final RelatedContentLookupListener relatedContentLookupListener) throws ContentException {
        if (byArray == null) {
            throw new ContentException("hash is null");
        }
        if (!this.initialisation_complete_sem.isReleasedForever() || this.dht_plugin != null && this.dht_plugin.isInitialising()) {
            AsyncDispatcher asyncDispatcher = new AsyncDispatcher();
            asyncDispatcher.dispatch(new AERunnable(){

                @Override
                public void runSupport() {
                    try {
                        RelatedContentManager.this.initialisation_complete_sem.reserve();
                        RelatedContentManager.this.lookupContentSupport(byArray, 0, true, relatedContentLookupListener);
                    }
                    catch (ContentException contentException) {
                        Debug.out(contentException);
                    }
                }
            });
        } else {
            this.lookupContentSupport(byArray, 0, true, relatedContentLookupListener);
        }
    }

    private void lookupContentSupport(final byte[] byArray, final int n, final boolean bl, final RelatedContentLookupListener relatedContentLookupListener) throws ContentException {
        try {
            if (this.dht_plugin == null) {
                throw new ContentException("DHT plugin unavailable");
            }
            String string = ByteFormatter.encodeString(byArray);
            byte[] byArray2 = ("az:rcm:assoc:" + string).getBytes("UTF-8");
            this.dht_plugin.get(byArray2, "Content relationship read: " + string, (byte)0, 30, 60000L, false, true, new DHTPluginOperationListener(){
                private Set<String> entries = new HashSet<String>();
                private RelatedContentManagerListener manager_listener = new RelatedContentManagerListener(){
                    private Set<RelatedContent> content_list = new HashSet<RelatedContent>();

                    @Override
                    public void contentFound(RelatedContent[] relatedContentArray) {
                        this.handle(relatedContentArray);
                    }

                    @Override
                    public void contentChanged(RelatedContent[] relatedContentArray) {
                        this.handle(relatedContentArray);
                    }

                    @Override
                    public void contentRemoved(RelatedContent[] relatedContentArray) {
                    }

                    @Override
                    public void contentChanged() {
                    }

                    @Override
                    public void contentReset() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private void handle(RelatedContent[] relatedContentArray) {
                        Set<RelatedContent> set = this.content_list;
                        synchronized (set) {
                            if (this.content_list.contains(relatedContentArray)) {
                                return;
                            }
                            for (RelatedContent relatedContent : relatedContentArray) {
                                this.content_list.add(relatedContent);
                            }
                        }
                        relatedContentLookupListener.contentFound(relatedContentArray);
                    }
                };

                @Override
                public void starts(byte[] byArray2) {
                    if (relatedContentLookupListener != null) {
                        try {
                            relatedContentLookupListener.lookupStart();
                        }
                        catch (Throwable throwable) {
                            Debug.out(throwable);
                        }
                    }
                }

                @Override
                public void diversified() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void valueRead(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                    try {
                        Map map = BDecoder.decode(dHTPluginValue.getValue());
                        String string = new String((byte[])map.get("d"), "UTF-8");
                        String string2 = null;
                        byte[] byArray2 = (byte[])map.get("h");
                        if (byArray2 == null) {
                            string2 = new String((byte[])map.get("t"), "UTF-8");
                        }
                        int n3 = ((Long)map.get("r")).intValue();
                        String string3 = string + " % " + n3;
                        Object object = this.entries;
                        synchronized (object) {
                            if (this.entries.contains(string3)) {
                                return;
                            }
                            this.entries.add(string3);
                        }
                        object = (Long)map.get("s");
                        long l = object == null ? 0L : (Long)object;
                        Long l2 = (Long)map.get("c");
                        Long l3 = (Long)map.get("p");
                        Long l4 = (Long)map.get("l");
                        Long l5 = (Long)map.get("z");
                        int n2 = l4 == null && l5 == null ? -1 : (l4 == null ? l5.intValue() << 16 : (l5 == null ? l4.intValue() & 0xFFFF : l5.intValue() << 16 | l4.intValue() & 0xFFFF));
                        RelatedContentManager.this.analyseResponse(new DownloadInfo(byArray, byArray2, string, n3, string2, n + 1, bl, l, l3 == null ? 0 : l3.intValue(), n2, (byte)(l2 == null ? -1L : (long)l2.byteValue())), relatedContentLookupListener == null ? null : this.manager_listener);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }

                @Override
                public void valueWritten(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                }

                @Override
                public void complete(byte[] byArray2, boolean bl2) {
                    if (relatedContentLookupListener != null) {
                        try {
                            relatedContentLookupListener.lookupComplete();
                        }
                        catch (Throwable throwable) {
                            Debug.out(throwable);
                        }
                    }
                }
            });
        }
        catch (Throwable throwable) {
            ContentException contentException = throwable instanceof ContentException ? (ContentException)throwable : new ContentException("Lookup failed", throwable);
            if (relatedContentLookupListener != null) {
                try {
                    relatedContentLookupListener.lookupFailed(contentException);
                }
                catch (Throwable throwable2) {
                    Debug.out(throwable2);
                }
            }
            throw contentException;
        }
    }

    protected void popuplateSecondaryLookups(ContentCache contentCache) {
        Object object;
        Object object2;
        Random random = new Random();
        this.secondary_lookups.clear();
        List list = this.download_info_map.values();
        int n = list.size();
        int n2 = n < 2 ? 0 : (n < 5 ? (random.nextInt(4) == 0 ? 1 : 0) : (n < 10 ? 1 : 2));
        if (n2 > 0) {
            object2 = new HashSet();
            for (int i = 0; i < n2; ++i) {
                object = (DownloadInfo)list.get(random.nextInt(list.size()));
                if (object2.contains(object)) continue;
                object2.add(object);
                this.secondary_lookups.addLast(new SecondaryLookup(((RelatedContent)object).getHash(), ((DownloadInfo)object).getLevel()));
            }
        }
        object2 = contentCache.related_content;
        Iterator iterator = object2.values().iterator();
        object = new ArrayList(object2.size());
        while (iterator.hasNext()) {
            DownloadInfo downloadInfo = (DownloadInfo)iterator.next();
            if (downloadInfo.getHash() == null || downloadInfo.getLevel() >= this.max_search_level) continue;
            object.add(downloadInfo);
        }
        int n3 = Math.min(object.size(), 10 - this.secondary_lookups.size());
        if (n3 > 0) {
            int n4;
            for (n4 = 0; n4 < n3; ++n4) {
                int n5 = random.nextInt(object.size());
                DownloadInfo downloadInfo = (DownloadInfo)object.get(n5);
                object.set(n5, object.get(n4));
                object.set(n4, downloadInfo);
            }
            for (n4 = 0; n4 < n3; ++n4) {
                DownloadInfo downloadInfo = (DownloadInfo)object.get(n4);
                this.secondary_lookups.addLast(new SecondaryLookup(downloadInfo.getHash(), downloadInfo.getLevel()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void secondaryLookup() {
        SecondaryLookup secondaryLookup;
        Object object;
        long l = SystemTime.getMonotonousTime();
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            if (this.secondary_lookup_in_progress) {
                return;
            }
            if (l - this.secondary_lookup_complete_time < 900000L) {
                return;
            }
            if (this.secondary_lookups.size() == 0) {
                Object object2 = object = this.content_cache == null ? null : (ContentCache)this.content_cache.get();
                if (object == null) {
                    object = this.loadRelatedContent();
                } else {
                    this.popuplateSecondaryLookups((ContentCache)object);
                }
            }
            if (this.secondary_lookups.size() == 0) {
                return;
            }
            secondaryLookup = this.secondary_lookups.removeFirst();
            this.secondary_lookup_in_progress = true;
        }
        try {
            this.lookupContentSupport(secondaryLookup.getHash(), secondaryLookup.getLevel(), false, new RelatedContentLookupListener(){

                @Override
                public void lookupStart() {
                }

                @Override
                public void contentFound(RelatedContent[] relatedContentArray) {
                }

                @Override
                public void lookupComplete() {
                    this.next();
                }

                @Override
                public void lookupFailed(ContentException contentException) {
                    this.next();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void next() {
                    SecondaryLookup secondaryLookup;
                    Object object = RelatedContentManager.this;
                    synchronized (object) {
                        if (RelatedContentManager.this.secondary_lookups.size() == 0) {
                            RelatedContentManager.this.secondary_lookup_in_progress = false;
                            RelatedContentManager.this.secondary_lookup_complete_time = SystemTime.getMonotonousTime();
                            return;
                        }
                        secondaryLookup = (SecondaryLookup)RelatedContentManager.this.secondary_lookups.removeFirst();
                    }
                    object = this;
                    SimpleTimer.addEvent("RCM:SLDelay", SystemTime.getOffsetTime(30000L), new TimerEventPerformer((RelatedContentLookupListener)object){
                        final /* synthetic */ RelatedContentLookupListener val$listener;
                        {
                            this.val$listener = relatedContentLookupListener;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void perform(TimerEvent timerEvent2) {
                            try {
                                RelatedContentManager.this.lookupContentSupport(secondaryLookup.getHash(), secondaryLookup.getLevel(), false, this.val$listener);
                            }
                            catch (Throwable throwable) {
                                Debug.out(throwable);
                                RelatedContentManager relatedContentManager = RelatedContentManager.this;
                                synchronized (relatedContentManager) {
                                    RelatedContentManager.this.secondary_lookup_in_progress = false;
                                    RelatedContentManager.this.secondary_lookup_complete_time = SystemTime.getMonotonousTime();
                                }
                            }
                        }
                    });
                }
            });
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            object = this;
            synchronized (object) {
                this.secondary_lookup_in_progress = false;
                this.secondary_lookup_complete_time = l;
            }
        }
    }

    protected void contentChanged(final DownloadInfo downloadInfo) {
        this.setConfigDirty();
        this.content_change_dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                for (RelatedContentManagerListener relatedContentManagerListener : RelatedContentManager.this.listeners) {
                    try {
                        relatedContentManagerListener.contentChanged(new RelatedContent[]{downloadInfo});
                    }
                    catch (Throwable throwable) {
                        Debug.out(throwable);
                    }
                }
            }
        });
    }

    protected void contentChanged(boolean bl) {
        if (bl) {
            this.setConfigDirty();
        }
        this.content_change_dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                for (RelatedContentManagerListener relatedContentManagerListener : RelatedContentManager.this.listeners) {
                    try {
                        relatedContentManagerListener.contentChanged();
                    }
                    catch (Throwable throwable) {
                        Debug.out(throwable);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(RelatedContent[] relatedContentArray) {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            ContentCache contentCache = this.loadRelatedContent();
            this.delete(relatedContentArray, contentCache, true);
        }
    }

    protected void delete(final RelatedContent[] relatedContentArray, ContentCache contentCache, boolean bl) {
        Object object;
        if (bl) {
            this.addPersistentlyDeleted(relatedContentArray);
        }
        Map map = contentCache.related_content;
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            object = (DownloadInfo)iterator.next();
            for (RelatedContent object2 : relatedContentArray) {
                if (object2 != object) continue;
                iterator.remove();
                if (!((DownloadInfo)object).isUnread()) continue;
                this.decrementUnread();
            }
        }
        object = contentCache.related_content_map;
        ArrayList arrayList = new ArrayList();
        block2: for (byte[] byArray : ((ByteArrayHashMap)object).keys()) {
            ArrayList arrayList2 = (ArrayList)((ByteArrayHashMap)object).get(byArray);
            for (RelatedContent relatedContent : relatedContentArray) {
                if (!arrayList2.remove(relatedContent) || arrayList2.size() != 0) continue;
                arrayList.add(byArray);
                continue block2;
            }
        }
        Iterator<Object> iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            byte[] byArray = (byte[])iterator2.next();
            ((ByteArrayHashMap)object).remove(byArray);
        }
        this.setConfigDirty();
        this.content_change_dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                for (RelatedContentManagerListener relatedContentManagerListener : RelatedContentManager.this.listeners) {
                    try {
                        relatedContentManagerListener.contentRemoved(relatedContentArray);
                    }
                    catch (Throwable throwable) {
                        Debug.out(throwable);
                    }
                }
            }
        });
    }

    protected String getPrivateInfoKey(RelatedContent relatedContent) {
        return relatedContent.getTitle() + ":" + relatedContent.getTracker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void analyseResponse(DownloadInfo downloadInfo, final RelatedContentManagerListener relatedContentManagerListener) {
        try {
            RelatedContentManager relatedContentManager = this;
            synchronized (relatedContentManager) {
                RelatedContent[] relatedContentArray;
                String string;
                byte[] byArray = downloadInfo.getHash();
                if (byArray != null) {
                    if (this.download_info_map.containsKey(byArray)) {
                        return;
                    }
                    string = Base32.encode(byArray);
                } else {
                    string = this.getPrivateInfoKey(downloadInfo);
                    if (this.download_priv_set.contains(string)) {
                        return;
                    }
                }
                if (this.isPersistentlyDeleted(downloadInfo)) {
                    return;
                }
                ContentCache contentCache = this.loadRelatedContent();
                DownloadInfo downloadInfo2 = null;
                boolean bl = false;
                boolean bl2 = false;
                downloadInfo2 = (DownloadInfo)contentCache.related_content.get(string);
                if (downloadInfo2 == null) {
                    if (this.enoughSpaceFor(contentCache, downloadInfo)) {
                        downloadInfo2 = downloadInfo;
                        contentCache.related_content.put(string, downloadInfo2);
                        relatedContentArray = (RelatedContent[])downloadInfo.getRelatedToHash();
                        ArrayList<DownloadInfo> arrayList = (ArrayList<DownloadInfo>)contentCache.related_content_map.get((byte[])relatedContentArray);
                        if (arrayList == null) {
                            arrayList = new ArrayList<DownloadInfo>(1);
                            contentCache.related_content_map.put((byte[])relatedContentArray, arrayList);
                        }
                        arrayList.add(downloadInfo2);
                        arrayList.trimToSize();
                        downloadInfo2.setPublic(contentCache);
                        if (this.secondary_lookups.size() < 10) {
                            byte[] byArray2 = downloadInfo2.getHash();
                            int n = downloadInfo2.getLevel();
                            if (byArray2 != null && n < this.max_search_level) {
                                this.secondary_lookups.add(new SecondaryLookup(byArray2, n));
                            }
                        }
                        bl2 = true;
                    }
                } else {
                    bl = downloadInfo2.addInfo(downloadInfo);
                }
                if (downloadInfo2 != null) {
                    boolean bl3;
                    relatedContentArray = new RelatedContent[]{downloadInfo2};
                    final boolean bl4 = bl;
                    boolean bl5 = bl3 = bl || bl2;
                    if (bl3) {
                        this.setConfigDirty();
                    }
                    this.content_change_dispatcher.dispatch(new AERunnable(){

                        @Override
                        public void runSupport() {
                            if (bl3) {
                                for (RelatedContentManagerListener relatedContentManagerListener2 : RelatedContentManager.this.listeners) {
                                    try {
                                        if (bl4) {
                                            relatedContentManagerListener2.contentChanged(relatedContentArray);
                                            continue;
                                        }
                                        relatedContentManagerListener2.contentFound(relatedContentArray);
                                    }
                                    catch (Throwable throwable) {
                                        Debug.out(throwable);
                                    }
                                }
                            }
                            if (relatedContentManagerListener != null) {
                                try {
                                    if (bl4) {
                                        relatedContentManagerListener.contentChanged(relatedContentArray);
                                    } else {
                                        relatedContentManagerListener.contentFound(relatedContentArray);
                                    }
                                }
                                catch (Throwable throwable) {
                                    Debug.out(throwable);
                                }
                            }
                        }
                    });
                }
            }
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
        }
    }

    protected boolean enoughSpaceFor(ContentCache contentCache, DownloadInfo downloadInfo) {
        Object object;
        Map map = contentCache.related_content;
        if (map.size() < this.max_results + this.temporary_space.get()) {
            return true;
        }
        Iterator iterator = map.entrySet().iterator();
        int n = downloadInfo.getLevel();
        HashMap<Integer, DownloadInfo> hashMap = new HashMap<Integer, DownloadInfo>();
        int n2 = Integer.MAX_VALUE;
        while (iterator.hasNext()) {
            DownloadInfo downloadInfo2;
            int n3;
            int n4;
            object = iterator.next();
            DownloadInfo downloadInfo3 = (DownloadInfo)object.getValue();
            if (downloadInfo3.isExplicit() || (n4 = downloadInfo3.getLevel()) < n) continue;
            if (n4 > n) {
                n = n4;
                n2 = Integer.MAX_VALUE;
                hashMap.clear();
            }
            if ((n3 = downloadInfo3.getRank()) < n2) {
                n2 = n3;
            }
            if ((downloadInfo2 = (DownloadInfo)hashMap.get(n3)) == null) {
                hashMap.put(n3, downloadInfo3);
                continue;
            }
            if (downloadInfo3.getLastSeenSecs() >= downloadInfo2.getLastSeenSecs()) continue;
            hashMap.put(n3, downloadInfo3);
        }
        object = (DownloadInfo)hashMap.get(n2);
        if (object != null) {
            this.delete(new RelatedContent[]{object}, contentCache, false);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelatedContent[] getRelatedContent() {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            ContentCache contentCache = this.loadRelatedContent();
            return contentCache.related_content.values().toArray(new DownloadInfo[contentCache.related_content.size()]);
        }
    }

    public void reset() {
        this.reset(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset(boolean bl) {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            ContentCache contentCache;
            ContentCache contentCache2 = contentCache = this.content_cache == null ? null : (ContentCache)this.content_cache.get();
            if (contentCache == null) {
                FileUtil.deleteResilientConfigFile(CONFIG_FILE);
            } else {
                contentCache.related_content = new HashMap();
                contentCache.related_content_map = new ByteArrayHashMapEx();
            }
            this.download_infos1.clear();
            this.download_infos2.clear();
            List list = this.download_info_map.values();
            this.download_infos1.addAll(list);
            this.download_infos2.addAll(list);
            Collections.shuffle(this.download_infos1);
            this.total_unread.set(0);
            if (bl) {
                this.resetPersistentlyDeleted();
            }
            this.setConfigDirty();
        }
        this.content_change_dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                for (RelatedContentManagerListener relatedContentManagerListener : RelatedContentManager.this.listeners) {
                    relatedContentManagerListener.contentReset();
                }
            }
        });
    }

    protected List<RelatedContent> matchContent(String string) {
        ArrayList<RelatedContent> arrayList = new ArrayList<RelatedContent>();
        RelatedContent[] relatedContentArray = this.getRelatedContent();
        String[] stringArray = string.toLowerCase().split(" ");
        int[] nArray = new int[stringArray.length];
        Pattern[] patternArray = new Pattern[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
            String string2 = stringArray[i];
            if (string2.length() <= 0) continue;
            int n = string2.charAt(0);
            if (n == 43) {
                nArray[i] = 1;
                string2 = stringArray[i] = string2.substring(1);
            } else if (n == 45) {
                nArray[i] = 2;
                string2 = stringArray[i] = string2.substring(1);
            }
            if (string2.startsWith("(") && string2.endsWith(")")) {
                string2 = string2.substring(1, string2.length() - 1);
                try {
                    patternArray[i] = Pattern.compile(string2, 2);
                }
                catch (Throwable throwable) {}
                continue;
            }
            if (!string2.contains("|")) continue;
            try {
                patternArray[i] = Pattern.compile(string2, 2);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        for (RelatedContent relatedContent : relatedContentArray) {
            String string3 = relatedContent.getTitle().toLowerCase();
            boolean bl = true;
            boolean bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                if (string4.length() <= 0) continue;
                boolean bl3 = patternArray[i] == null ? string3.contains(string4) : patternArray[i].matcher(string3).find();
                int n = nArray[i];
                if (bl3) {
                    if (n == 2) {
                        bl = false;
                        break;
                    }
                    bl2 = true;
                    continue;
                }
                if (n == 2) {
                    bl2 = true;
                    continue;
                }
                bl = false;
                break;
            }
            if (!bl || !bl2) continue;
            arrayList.add(relatedContent);
        }
        return arrayList;
    }

    public SearchInstance searchRCM(Map<String, Object> map, final SearchObserver searchObserver) throws SearchException {
        this.initialisation_complete_sem.reserve();
        final String string = (String)map.get("s");
        final SearchInstance searchInstance = new SearchInstance(){

            @Override
            public void cancel() {
                Debug.out("Cancelled");
            }
        };
        if (string == null) {
            searchObserver.complete();
        } else {
            new AEThread2("RCM:search", true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    HashSet<String> hashSet = new HashSet<String>();
                    DHT[] dHTArray = RelatedContentManager.this.matchContent(string);
                    for (final RelatedContent relatedContent : dHTArray) {
                        final byte[] byArray = relatedContent.getHash();
                        if (byArray == null) continue;
                        hashSet.add(Base32.encode(byArray));
                        SearchResult searchResult = new SearchResult(){

                            @Override
                            public Object getProperty(int n) {
                                byte[] byArray2;
                                if (n == 1) {
                                    return relatedContent.getTitle();
                                }
                                if (n == 3) {
                                    return relatedContent.getSize();
                                }
                                if (n == 21) {
                                    return byArray;
                                }
                                if (n == 17) {
                                    return new Long(relatedContent.getRank() / 4);
                                }
                                if (n == 5) {
                                    return new Long(relatedContent.getSeeds());
                                }
                                if (n == 4) {
                                    return new Long(relatedContent.getLeechers());
                                }
                                if (n == 6) {
                                    if (relatedContent.getContentNetwork() != -1L) {
                                        return new Long(1L);
                                    }
                                    return new Long(0L);
                                }
                                if (n == 2) {
                                    long l = relatedContent.getPublishDate();
                                    if (l <= 0L) {
                                        return null;
                                    }
                                    return new Date(l);
                                }
                                if ((n == 12 || n == 16) && (byArray2 = relatedContent.getHash()) != null) {
                                    return UrlUtils.getMagnetURI(byArray2);
                                }
                                return null;
                            }
                        };
                        searchObserver.resultReceived(searchInstance, searchResult);
                    }
                    try {
                        int n;
                        DHTTransportContact[] dHTTransportContactArray;
                        DHT dHT;
                        int n2;
                        dHTArray = RelatedContentManager.this.dht_plugin.getDHTs();
                        HashSet hashSet2 = new HashSet();
                        DHT[] dHTArray2 = dHTArray;
                        int n3 = dHTArray2.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            dHT = dHTArray2[n2];
                            for (DHTTransportContact dHTTransportContact : dHTTransportContactArray = dHT.getTransport().getReachableContacts()) {
                                if (dHTTransportContact.getProtocolVersion() < 24) continue;
                                hashSet2.add(dHTTransportContact.getAddress());
                            }
                        }
                        if (hashSet2.size() < 50) {
                            DHT[] dHTArray3 = dHTArray;
                            n3 = dHTArray3.length;
                            for (n2 = 0; n2 < n3; ++n2) {
                                dHT = dHTArray3[n2];
                                for (DHTTransportContact dHTTransportContact : dHTTransportContactArray = dHT.getTransport().getRecentContacts()) {
                                    if (dHTTransportContact.getProtocolVersion() < 24) continue;
                                    hashSet2.add(dHTTransportContact.getAddress());
                                    if (hashSet2.size() >= 50) break;
                                }
                                if (hashSet2.size() >= 50) break;
                            }
                        }
                        ArrayList arrayList = new ArrayList(hashSet2);
                        Collections.shuffle(arrayList);
                        ArrayList<DistributedDatabaseContact> arrayList2 = new ArrayList<DistributedDatabaseContact>();
                        for (n2 = 0; n2 < Math.min(arrayList.size(), 50); ++n2) {
                            try {
                                arrayList2.add(RelatedContentManager.this.ddb.importContact((InetSocketAddress)arrayList.get(n2), (byte)24));
                                continue;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        long l = SystemTime.getMonotonousTime();
                        long l2 = 25000L;
                        AESemaphore aESemaphore = new AESemaphore("RCM:rems");
                        int n4 = 0;
                        int[] nArray = new int[]{0};
                        for (n = 0; n < arrayList2.size(); ++n) {
                            DistributedDatabaseContact distributedDatabaseContact = (DistributedDatabaseContact)arrayList2.get(n);
                            new AEThread2("RCM:rems", true, hashSet, distributedDatabaseContact, nArray, aESemaphore){
                                final /* synthetic */ Set val$hashes;
                                final /* synthetic */ DistributedDatabaseContact val$c;
                                final /* synthetic */ int[] val$done;
                                final /* synthetic */ AESemaphore val$sem;
                                {
                                    this.val$hashes = set;
                                    this.val$c = distributedDatabaseContact;
                                    this.val$done = nArray;
                                    this.val$sem = aESemaphore;
                                    super(string, bl);
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    try {
                                        RelatedContentManager.this.sendRemoteSearch(searchInstance, this.val$hashes, this.val$c, string, searchObserver);
                                    }
                                    finally {
                                        int[] nArray = this.val$done;
                                        synchronized (this.val$done) {
                                            this.val$done[0] = this.val$done[0] + 1;
                                            // ** MonitorExit[var1_1] (shouldn't be in output)
                                            this.val$sem.release();
                                        }
                                    }
                                }
                            }.start();
                            ++n4;
                            int[] nArray2 = nArray;
                            // MONITORENTER : nArray
                            if (nArray[0] >= arrayList2.size() / 2) {
                                l = SystemTime.getMonotonousTime();
                                l2 = 5000L;
                                // MONITOREXIT : nArray2
                                break;
                            }
                            // MONITOREXIT : nArray2
                            if (n <= 10) continue;
                            try {
                                Thread.sleep(250L);
                                continue;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        n = 0;
                        while (n < n4) {
                            if (nArray[0] > n4 * 4 / 5) {
                                return;
                            }
                            long l3 = SystemTime.getMonotonousTime() - l;
                            if (l3 >= l2) return;
                            aESemaphore.reserve(l2 - l3);
                            ++n;
                        }
                        return;
                    }
                    finally {
                        searchObserver.complete();
                    }
                    catch (Throwable throwable) {
                        try {
                            int n;
                            DHTTransportContact[] dHTTransportContactArray;
                            DHT[] dHTArray4 = RelatedContentManager.this.dht_plugin.getDHTs();
                            HashSet<InetSocketAddress> hashSet3 = new HashSet<InetSocketAddress>();
                            for (DHT dHT : dHTArray4) {
                                for (DHTTransportContact dHTTransportContact : dHTTransportContactArray = dHT.getTransport().getReachableContacts()) {
                                    if (dHTTransportContact.getProtocolVersion() < 24) continue;
                                    hashSet3.add(dHTTransportContact.getAddress());
                                }
                            }
                            if (hashSet3.size() < 50) {
                                for (DHT dHT : dHTArray4) {
                                    for (DHTTransportContact dHTTransportContact : dHTTransportContactArray = dHT.getTransport().getRecentContacts()) {
                                        if (dHTTransportContact.getProtocolVersion() < 24) continue;
                                        hashSet3.add(dHTTransportContact.getAddress());
                                        if (hashSet3.size() >= 50) break;
                                    }
                                    if (hashSet3.size() >= 50) break;
                                }
                            }
                            ArrayList arrayList = new ArrayList(hashSet3);
                            Collections.shuffle(arrayList);
                            ArrayList<DistributedDatabaseContact> arrayList3 = new ArrayList<DistributedDatabaseContact>();
                            for (int i = 0; i < Math.min(arrayList.size(), 50); ++i) {
                                try {
                                    arrayList3.add(RelatedContentManager.this.ddb.importContact((InetSocketAddress)arrayList.get(i), (byte)24));
                                    continue;
                                }
                                catch (Throwable throwable2) {
                                    // empty catch block
                                }
                            }
                            long l = SystemTime.getMonotonousTime();
                            long l4 = 25000L;
                            AESemaphore aESemaphore = new AESemaphore("RCM:rems");
                            int n5 = 0;
                            int[] nArray = new int[]{0};
                            for (n = 0; n < arrayList3.size(); ++n) {
                                DistributedDatabaseContact distributedDatabaseContact = (DistributedDatabaseContact)arrayList3.get(n);
                                new /* invalid duplicate definition of identical inner class */.start();
                                ++n5;
                                int[] nArray3 = nArray;
                                // MONITORENTER : nArray
                                if (nArray[0] >= arrayList3.size() / 2) {
                                    l = SystemTime.getMonotonousTime();
                                    l4 = 5000L;
                                    // MONITOREXIT : nArray3
                                    break;
                                }
                                // MONITOREXIT : nArray3
                                if (n <= 10) continue;
                                try {
                                    Thread.sleep(250L);
                                    continue;
                                }
                                catch (Throwable throwable3) {
                                    // empty catch block
                                }
                            }
                            n = 0;
                            while (n < n5) {
                                if (nArray[0] > n5 * 4 / 5) {
                                    throw throwable;
                                }
                                long l5 = SystemTime.getMonotonousTime() - l;
                                if (l5 >= l4) throw throwable;
                                aESemaphore.reserve(l4 - l5);
                                ++n;
                            }
                            throw throwable;
                        }
                        finally {
                            searchObserver.complete();
                        }
                    }
                }
            }.start();
        }
        return searchInstance;
    }

    protected void sendRemoteSearch(SearchInstance searchInstance, Set<String> set, DistributedDatabaseContact distributedDatabaseContact, String string, SearchObserver searchObserver) {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("t", string);
            DistributedDatabaseKey distributedDatabaseKey = this.ddb.createKey(BEncoder.encode(hashMap));
            DistributedDatabaseValue distributedDatabaseValue = distributedDatabaseContact.read(new DistributedDatabaseProgressListener(){

                @Override
                public void reportSize(long l) {
                }

                @Override
                public void reportActivity(String string) {
                }

                @Override
                public void reportCompleteness(int n) {
                }
            }, this.transfer_type, distributedDatabaseKey, 10000L);
            if (distributedDatabaseValue == null) {
                return;
            }
            Map map = BDecoder.decode((byte[])distributedDatabaseValue.getValue(byte[].class));
            List list = (List)map.get("l");
            for (final Map map2 : list) {
                String string2;
                final String string3 = ImportExportUtils.importString(map2, "n");
                final byte[] byArray = (byte[])map2.get("h");
                if (byArray == null || set.contains(string2 = Base32.encode(byArray))) continue;
                set.add(string2);
                SearchResult searchResult = new SearchResult(){

                    @Override
                    public Object getProperty(int n) {
                        try {
                            byte[] byArray2;
                            if (n == 1) {
                                return string3;
                            }
                            if (n == 3) {
                                return ImportExportUtils.importLong(map2, "s");
                            }
                            if (n == 21) {
                                return byArray;
                            }
                            if (n == 17) {
                                return ImportExportUtils.importLong(map2, "r") / 4L;
                            }
                            if (n == 6) {
                                long l = ImportExportUtils.importLong(map2, "c", -1L);
                                if (l == -1L) {
                                    return 0L;
                                }
                                return 1L;
                            }
                            if (n == 5) {
                                return ImportExportUtils.importLong(map2, "z");
                            }
                            if (n == 4) {
                                return ImportExportUtils.importLong(map2, "l");
                            }
                            if (n == 2) {
                                long l = ImportExportUtils.importLong(map2, "p", 0L) * 60L * 60L * 1000L;
                                if (l <= 0L) {
                                    return null;
                                }
                                return new Date(l);
                            }
                            if ((n == 12 || n == 16) && (byArray2 = (byte[])map2.get("h")) != null) {
                                return UrlUtils.getMagnetURI(byArray2);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        return null;
                    }
                };
                searchObserver.resultReceived(searchInstance, searchResult);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected Map<String, Object> receiveRemoteSearch(Map<String, Object> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            String string = ImportExportUtils.importString(map, "t");
            if (string != null) {
                List<RelatedContent> list = this.matchContent(string);
                if (list.size() > 30) {
                    Collections.sort(list, new Comparator<RelatedContent>(){

                        @Override
                        public int compare(RelatedContent relatedContent, RelatedContent relatedContent2) {
                            return relatedContent2.getRank() - relatedContent.getRank();
                        }
                    });
                }
                ArrayList arrayList = new ArrayList();
                for (int i = 0; i < Math.min(list.size(), 30); ++i) {
                    RelatedContent relatedContent = list.get(i);
                    HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
                    arrayList.add(hashMap2);
                    ImportExportUtils.exportString(hashMap2, "n", relatedContent.getTitle());
                    ImportExportUtils.exportLong(hashMap2, "s", relatedContent.getSize());
                    ImportExportUtils.exportLong(hashMap2, "r", relatedContent.getRank());
                    ImportExportUtils.exportLong(hashMap2, "d", relatedContent.getLastSeenSecs());
                    ImportExportUtils.exportLong(hashMap2, "p", relatedContent.getPublishDate() / 3600000L);
                    ImportExportUtils.exportLong(hashMap2, "l", relatedContent.getLeechers());
                    ImportExportUtils.exportLong(hashMap2, "z", relatedContent.getSeeds());
                    ImportExportUtils.exportLong(hashMap2, "c", relatedContent.getContentNetwork());
                    byte[] byArray = relatedContent.getHash();
                    if (byArray == null) continue;
                    hashMap2.put("h", byArray);
                }
                hashMap.put("l", arrayList);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return hashMap;
    }

    @Override
    public DistributedDatabaseValue read(DistributedDatabaseContact distributedDatabaseContact, DistributedDatabaseTransferType distributedDatabaseTransferType, DistributedDatabaseKey distributedDatabaseKey) throws DistributedDatabaseException {
        Object object = distributedDatabaseKey.getKey();
        try {
            byte[] byArray = (byte[])object;
            Map map = BDecoder.decode(byArray);
            Map<String, Object> map2 = this.receiveRemoteSearch(map);
            return this.ddb.createValue(BEncoder.encode(map2));
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            return null;
        }
    }

    @Override
    public void write(DistributedDatabaseContact distributedDatabaseContact, DistributedDatabaseTransferType distributedDatabaseTransferType, DistributedDatabaseKey distributedDatabaseKey, DistributedDatabaseValue distributedDatabaseValue) throws DistributedDatabaseException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConfigDirty() {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            this.content_dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContentCache loadRelatedContent() {
        boolean bl = false;
        try {
            RelatedContentManager relatedContentManager = this;
            synchronized (relatedContentManager) {
                ContentCache contentCache;
                this.last_config_access = SystemTime.getMonotonousTime();
                ContentCache contentCache2 = contentCache = this.content_cache == null ? null : (ContentCache)this.content_cache.get();
                if (contentCache == null) {
                    bl = true;
                    contentCache = new ContentCache();
                    this.content_cache = new WeakReference<ContentCache>(contentCache);
                    try {
                        int n = 0;
                        if (FileUtil.resilientConfigFileExists(CONFIG_FILE)) {
                            Map map = FileUtil.readResilientConfigFile(CONFIG_FILE);
                            Map map2 = contentCache.related_content;
                            ByteArrayHashMapEx byteArrayHashMapEx = contentCache.related_content_map;
                            Map map3 = (Map)map.get("rcm");
                            Object v = map.get("rc");
                            if (v != null && map3 != null) {
                                Object object42;
                                ArrayList<DownloadInfo> arrayList;
                                Object object;
                                Iterator<Object> iterator;
                                HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
                                if (v instanceof Map) {
                                    iterator = (Map)v;
                                    for (Map.Entry object32 : iterator.entrySet()) {
                                        try {
                                            object = (String)object32.getKey();
                                            arrayList = (Map)object32.getValue();
                                            DownloadInfo downloadInfo = this.deserialiseDI((Map<String, Object>)((Object)arrayList), contentCache);
                                            if (downloadInfo.isUnread()) {
                                                ++n;
                                            }
                                            map2.put(object, downloadInfo);
                                            int n2 = ((Long)arrayList.get("_i")).intValue();
                                            hashMap.put(n2, downloadInfo);
                                        }
                                        catch (Throwable throwable) {
                                            Debug.out(throwable);
                                        }
                                    }
                                } else {
                                    iterator = (List)v;
                                    object42 = iterator.iterator();
                                    while (object42.hasNext()) {
                                        Map throwable = (Map)object42.next();
                                        try {
                                            object = new String((byte[])throwable.get("_k"), "UTF-8");
                                            arrayList = this.deserialiseDI(throwable, contentCache);
                                            if (((DownloadInfo)((Object)arrayList)).isUnread()) {
                                                ++n;
                                            }
                                            map2.put(object, arrayList);
                                            int n3 = ((Long)throwable.get("_i")).intValue();
                                            hashMap.put(n3, arrayList);
                                        }
                                        catch (Throwable throwable2) {
                                            Debug.out(throwable2);
                                        }
                                    }
                                }
                                if (map3.size() != 0 && hashMap.size() != 0) {
                                    for (Object object42 : map3.keySet()) {
                                        try {
                                            byte[] byArray = Base32.decode((String)object42);
                                            object = ImportExportUtils.importIntArray(map3, (String)object42);
                                            if (object == null || ((Object)object).length == 0) continue;
                                            arrayList = new ArrayList<DownloadInfo>(((Object)object).length);
                                            for (Object object2 : object) {
                                                DownloadInfo downloadInfo = (DownloadInfo)hashMap.get((int)object2);
                                                if (downloadInfo == null) continue;
                                                downloadInfo.setRelatedToHash(byArray);
                                                arrayList.add(downloadInfo);
                                            }
                                            if (arrayList.size() <= 0) continue;
                                            byteArrayHashMapEx.put(byArray, arrayList);
                                        }
                                        catch (Throwable throwable) {
                                            Debug.out(throwable);
                                        }
                                    }
                                }
                                iterator = map2.values().iterator();
                                while (iterator.hasNext()) {
                                    object42 = (DownloadInfo)iterator.next();
                                    if (((RelatedContent)object42).getRelatedToHash() != null) continue;
                                    if (((DownloadInfo)object42).isUnread()) {
                                        --n;
                                    }
                                    iterator.remove();
                                }
                                this.popuplateSecondaryLookups(contentCache);
                            }
                        }
                        if (this.total_unread.get() != n) {
                            this.total_unread.set(n);
                            COConfigurationManager.setParameter(CONFIG_TOTAL_UNREAD, n);
                        }
                    }
                    catch (Throwable throwable) {
                        Debug.out(throwable);
                    }
                    this.enforceMaxResults(contentCache, false);
                }
                this.content_cache_ref = contentCache;
                ContentCache contentCache3 = contentCache;
                return contentCache3;
            }
        }
        finally {
            if (bl) {
                this.contentChanged(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveRelatedContent() {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            ContentCache contentCache;
            COConfigurationManager.setParameter(CONFIG_TOTAL_UNREAD, this.total_unread.get());
            long l = SystemTime.getMonotonousTime();
            ContentCache contentCache2 = contentCache = this.content_cache == null ? null : (ContentCache)this.content_cache.get();
            if (!this.content_dirty) {
                if (contentCache != null && l - this.last_config_access > 60000L) {
                    if (this.content_cache_ref != null) {
                        this.content_discard_ticks = 0;
                    }
                    this.content_cache_ref = null;
                }
                return;
            }
            this.last_config_access = l;
            this.content_dirty = false;
            if (contentCache != null) {
                if (this.persist) {
                    Map map = contentCache.related_content;
                    ByteArrayHashMapEx byteArrayHashMapEx = contentCache.related_content_map;
                    if (map.size() == 0) {
                        FileUtil.deleteResilientConfigFile(CONFIG_FILE);
                    } else {
                        Map<String, Object> map2;
                        Object object;
                        Map.Entry entry2;
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        Set set = map.entrySet();
                        ArrayList<Object> arrayList = new ArrayList<Object>(set.size());
                        hashMap.put("rc", arrayList);
                        int n = 0;
                        HashMap<DownloadInfo, Integer> hashMap2 = new HashMap<DownloadInfo, Integer>();
                        for (Map.Entry entry2 : set) {
                            object = (DownloadInfo)entry2.getValue();
                            map2 = this.serialiseDI((DownloadInfo)object, contentCache);
                            if (map2 == null) continue;
                            hashMap2.put((DownloadInfo)object, n);
                            map2.put("_i", new Long(n));
                            map2.put("_k", entry2.getKey());
                            if (arrayList.add(map2)) {
                                // empty if block
                            }
                            ++n;
                        }
                        HashMap hashMap3 = new HashMap();
                        hashMap.put("rcm", hashMap3);
                        entry2 = byteArrayHashMapEx.keys().iterator();
                        while (entry2.hasNext()) {
                            DownloadInfo downloadInfo;
                            Integer n2;
                            object = (byte[])entry2.next();
                            map2 = (List)byteArrayHashMapEx.get((byte[])object);
                            int[] nArray = new int[map2.size()];
                            int n3 = 0;
                            Iterator iterator = map2.iterator();
                            while (iterator.hasNext() && (n2 = (Integer)hashMap2.get(downloadInfo = (DownloadInfo)iterator.next())) != null) {
                                nArray[n3++] = n2;
                            }
                            if (n3 != nArray.length) continue;
                            ImportExportUtils.exportIntArray(hashMap3, Base32.encode((byte[])object), nArray);
                        }
                        FileUtil.writeResilientConfigFile(CONFIG_FILE, hashMap);
                    }
                } else {
                    this.deleteRelatedContent();
                }
            }
        }
    }

    private void deleteRelatedContent() {
        FileUtil.deleteResilientConfigFile(CONFIG_FILE);
        FileUtil.deleteResilientConfigFile(PERSIST_DEL_FILE);
    }

    public int getNumUnread() {
        return this.total_unread.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllRead() {
        boolean bl = false;
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            DownloadInfo[] downloadInfoArray;
            for (DownloadInfo downloadInfo : downloadInfoArray = (DownloadInfo[])this.getRelatedContent()) {
                if (!downloadInfo.isUnread()) continue;
                bl = true;
                downloadInfo.setUnreadInternal(false);
            }
            this.total_unread.set(0);
        }
        if (bl) {
            this.contentChanged(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            ContentCache contentCache = this.loadRelatedContent();
            this.addPersistentlyDeleted(contentCache.related_content.values().toArray(new DownloadInfo[contentCache.related_content.size()]));
            this.reset(false);
        }
    }

    protected void incrementUnread() {
        this.total_unread.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementUnread() {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            int n = this.total_unread.decrementAndGet();
            if (n < 0) {
                this.total_unread.set(0);
            }
        }
    }

    protected Download getDownload(byte[] byArray) {
        try {
            return this.plugin_interface.getDownloadManager().getDownload(byArray);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected byte[] getPermDelKey(RelatedContent relatedContent) {
        byte[] byArray = relatedContent.getHash();
        if (byArray == null) {
            try {
                byArray = new SHA1Simple().calculateHash(this.getPrivateInfoKey(relatedContent).getBytes("ISO-8859-1"));
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
                return null;
            }
        }
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, 0, byArray2, 0, 8);
        return byArray2;
    }

    protected List<byte[]> loadPersistentlyDeleted() {
        List list = null;
        if (FileUtil.resilientConfigFileExists(PERSIST_DEL_FILE)) {
            Map map = FileUtil.readResilientConfigFile(PERSIST_DEL_FILE);
            list = (List)map.get("entries");
        }
        if (list == null) {
            list = new ArrayList(0);
        }
        return list;
    }

    protected void addPersistentlyDeleted(RelatedContent[] relatedContentArray) {
        block6: {
            if (relatedContentArray.length == 0) {
                return;
            }
            List<byte[]> list = this.loadPersistentlyDeleted();
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>(relatedContentArray.length);
            for (RelatedContent relatedContent : relatedContentArray) {
                byte[] byArray = this.getPermDelKey(relatedContent);
                arrayList.add(byArray);
                list.add(byArray);
            }
            HashMap hashMap = new HashMap();
            hashMap.put("entries", list);
            FileUtil.writeResilientConfigFile(PERSIST_DEL_FILE, hashMap);
            if (this.persist_del_bloom == null) break block6;
            if (this.persist_del_bloom.getSize() / (this.persist_del_bloom.getEntryCount() + relatedContentArray.length) < 10) {
                this.persist_del_bloom = BloomFilterFactory.createAddOnly(Math.max(1000, this.persist_del_bloom.getSize() * 10 + 1000 + relatedContentArray.length));
                for (byte[] byArray : list) {
                    this.persist_del_bloom.add(byArray);
                }
            } else {
                for (byte[] byArray : arrayList) {
                    this.persist_del_bloom.add(byArray);
                }
            }
        }
    }

    protected boolean isPersistentlyDeleted(RelatedContent relatedContent) {
        Object object;
        if (this.persist_del_bloom == null) {
            object = this.loadPersistentlyDeleted();
            this.persist_del_bloom = BloomFilterFactory.createAddOnly(Math.max(1000, object.size() * 10 + 1000));
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                byte[] byArray = (byte[])iterator.next();
                this.persist_del_bloom.add(byArray);
            }
        }
        object = this.getPermDelKey(relatedContent);
        return this.persist_del_bloom.contains((byte[])object);
    }

    protected void resetPersistentlyDeleted() {
        FileUtil.deleteResilientConfigFile(PERSIST_DEL_FILE);
        this.persist_del_bloom = BloomFilterFactory.createAddOnly(1000);
    }

    public void reserveTemporarySpace() {
        this.temporary_space.addAndGet(50);
    }

    public void releaseTemporarySpace() {
        boolean bl = this.temporary_space.addAndGet(-50) == 0;
        this.enforceMaxResults(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enforceMaxResults(boolean bl) {
        RelatedContentManager relatedContentManager = this;
        synchronized (relatedContentManager) {
            ContentCache contentCache = this.loadRelatedContent();
            this.enforceMaxResults(contentCache, bl);
        }
    }

    protected void enforceMaxResults(ContentCache contentCache, boolean bl) {
        Map map = contentCache.related_content;
        int n = map.size() - (this.max_results + this.temporary_space.get());
        if (n > 0) {
            ArrayList arrayList = new ArrayList(map.values());
            if (bl) {
                for (DownloadInfo downloadInfo : arrayList) {
                    if (!downloadInfo.isExplicit()) continue;
                    downloadInfo.setExplicit(false);
                }
            }
            Collections.sort(arrayList, new Comparator<DownloadInfo>(){

                @Override
                public int compare(DownloadInfo downloadInfo, DownloadInfo downloadInfo2) {
                    int n = downloadInfo2.getLevel() - downloadInfo.getLevel();
                    if (n != 0) {
                        return n;
                    }
                    n = downloadInfo.getRank() - downloadInfo2.getRank();
                    if (n != 0) {
                        return n;
                    }
                    return downloadInfo.getLastSeenSecs() - downloadInfo2.getLastSeenSecs();
                }
            });
            ArrayList arrayList2 = new ArrayList();
            for (int i = 0; i < Math.min(n, arrayList.size()); ++i) {
                arrayList2.add(arrayList.get(i));
            }
            if (arrayList2.size() > 0) {
                this.delete(arrayList2.toArray(new RelatedContent[arrayList2.size()]), contentCache, false);
            }
        }
    }

    public void addListener(RelatedContentManagerListener relatedContentManagerListener) {
        this.listeners.add(relatedContentManagerListener);
    }

    public void removeListener(RelatedContentManagerListener relatedContentManagerListener) {
        this.listeners.remove(relatedContentManagerListener);
    }

    private Map<String, Object> serialiseDI(DownloadInfo downloadInfo, ContentCache contentCache) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("h", downloadInfo.getHash());
            ImportExportUtils.exportString(hashMap, "d", downloadInfo.getTitle());
            ImportExportUtils.exportInt(hashMap, "r", downloadInfo.getRand());
            ImportExportUtils.exportString(hashMap, "t", downloadInfo.getTracker());
            ImportExportUtils.exportLong(hashMap, "z", downloadInfo.getSize());
            ImportExportUtils.exportInt(hashMap, "p", (int)(downloadInfo.getPublishDate() / 3600000L));
            ImportExportUtils.exportInt(hashMap, "q", downloadInfo.getSeeds() << 16 | downloadInfo.getLeechers() & 0xFFFF);
            ImportExportUtils.exportInt(hashMap, "c", (int)downloadInfo.getContentNetwork());
            if (contentCache != null) {
                ImportExportUtils.exportBoolean(hashMap, "u", downloadInfo.isUnread());
                ImportExportUtils.exportIntArray(hashMap, "l", downloadInfo.getRandList());
                ImportExportUtils.exportInt(hashMap, "s", downloadInfo.getLastSeenSecs());
                ImportExportUtils.exportInt(hashMap, "e", downloadInfo.getLevel());
            }
            return hashMap;
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            return null;
        }
    }

    private DownloadInfo deserialiseDI(Map<String, Object> map, ContentCache contentCache) {
        try {
            byte[] byArray = (byte[])map.get("h");
            String string = ImportExportUtils.importString(map, "d");
            int n = ImportExportUtils.importInt(map, "r");
            String string2 = ImportExportUtils.importString(map, "t");
            long l = ImportExportUtils.importLong(map, "z");
            int n2 = ImportExportUtils.importInt(map, "p", 0);
            int n3 = ImportExportUtils.importInt(map, "q", -1);
            byte by = (byte)ImportExportUtils.importInt(map, "c", -1);
            if (contentCache == null) {
                return new DownloadInfo(byArray, byArray, string, n, string2, 0, false, l, n2, n3, by);
            }
            boolean bl = ImportExportUtils.importBoolean(map, "u");
            int[] nArray = ImportExportUtils.importIntArray(map, "l");
            int n4 = ImportExportUtils.importInt(map, "s");
            int n5 = ImportExportUtils.importInt(map, "e");
            return new DownloadInfo(byArray, string, n, string2, bl, nArray, n4, n5, l, n2, n3, by, contentCache);
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            return null;
        }
    }

    protected class RCMSearchXFer
    implements DistributedDatabaseTransferType {
        protected RCMSearchXFer() {
        }
    }

    private static class SecondaryLookup {
        private final byte[] hash;
        private final int level;

        protected SecondaryLookup(byte[] byArray, int n) {
            this.hash = byArray;
            this.level = n;
        }

        protected byte[] getHash() {
            return this.hash;
        }

        protected int getLevel() {
            return this.level;
        }
    }

    private static class ContentCache {
        private Map<String, DownloadInfo> related_content = new HashMap<String, DownloadInfo>();
        private ByteArrayHashMapEx<ArrayList<DownloadInfo>> related_content_map = new ByteArrayHashMapEx();

        private ContentCache() {
        }
    }

    protected class DownloadInfo
    extends RelatedContent {
        private final int rand;
        private boolean unread;
        private int[] rand_list;
        private int last_seen;
        private int level;
        private boolean explicit;
        private ContentCache cc;

        protected DownloadInfo(byte[] byArray, byte[] byArray2, String string, int n, String string2, int n2, boolean bl, long l, int n3, int n4, byte by) {
            super(byArray, string, byArray2, string2, l, n3, n4, by);
            this.unread = true;
            this.rand = n;
            this.level = n2;
            this.explicit = bl;
            this.updateLastSeen();
        }

        protected DownloadInfo(byte[] byArray, String string, int n, String string2, boolean bl, int[] nArray, int n2, int n3, long l, int n4, int n5, byte by, ContentCache contentCache) {
            super(string, byArray, string2, l, n4, n5, by);
            this.unread = true;
            this.rand = n;
            this.unread = bl;
            this.rand_list = nArray;
            this.last_seen = n2;
            this.level = n3;
            this.cc = contentCache;
            if (this.rand_list != null && this.rand_list.length > 100) {
                int[] nArray2 = new int[100];
                System.arraycopy(this.rand_list, 0, nArray2, 0, 100);
                this.rand_list = nArray2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean addInfo(DownloadInfo downloadInfo) {
            boolean bl = false;
            DownloadInfo downloadInfo2 = this;
            synchronized (downloadInfo2) {
                int n;
                int n2;
                long l;
                this.updateLastSeen();
                int n3 = downloadInfo.getRand();
                if (this.rand_list == null) {
                    this.rand_list = new int[]{n3};
                    bl = true;
                } else {
                    int n4;
                    boolean bl2 = false;
                    for (n4 = 0; n4 < this.rand_list.length; ++n4) {
                        if (this.rand_list[n4] != n3) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2 && this.rand_list.length < 100) {
                        n4 = this.rand_list.length;
                        int[] nArray = new int[n4 + 1];
                        System.arraycopy(this.rand_list, 0, nArray, 0, n4);
                        nArray[n4] = n3;
                        this.rand_list = nArray;
                        bl = true;
                    }
                }
                if (downloadInfo.getLevel() < this.level) {
                    this.level = downloadInfo.getLevel();
                    bl = true;
                }
                if ((l = downloadInfo.getContentNetwork()) != -1L && this.getContentNetwork() == -1L) {
                    this.setContentNetwork(l);
                }
                if ((n2 = downloadInfo.getSeedsLeechers()) != -1 && n2 != this.getSeedsLeechers()) {
                    this.setSeedsLeechers(n2);
                    bl = true;
                }
                if ((n = downloadInfo.getDateHours()) > 0 && n != this.getDateHours()) {
                    this.setDateHours(n);
                    bl = true;
                }
            }
            return bl;
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        protected boolean isExplicit() {
            return this.explicit;
        }

        protected void setExplicit(boolean bl) {
            this.explicit = bl;
        }

        protected void updateLastSeen() {
            this.last_seen = (int)(SystemTime.getCurrentTime() / 1000L);
        }

        @Override
        public int getRank() {
            return this.rand_list == null ? 0 : this.rand_list.length;
        }

        @Override
        public boolean isUnread() {
            return this.unread;
        }

        protected void setPublic(ContentCache contentCache) {
            this.cc = contentCache;
            if (this.unread) {
                RelatedContentManager.this.incrementUnread();
            }
            this.rand_list = new int[]{this.rand};
        }

        @Override
        public int getLastSeenSecs() {
            return this.last_seen;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setUnreadInternal(boolean bl) {
            DownloadInfo downloadInfo = this;
            synchronized (downloadInfo) {
                this.unread = bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setUnread(boolean bl) {
            boolean bl2 = false;
            DownloadInfo downloadInfo = this;
            synchronized (downloadInfo) {
                if (this.unread != bl) {
                    this.unread = bl;
                    bl2 = true;
                }
            }
            if (bl2) {
                if (bl) {
                    RelatedContentManager.this.incrementUnread();
                } else {
                    RelatedContentManager.this.decrementUnread();
                }
                RelatedContentManager.this.contentChanged(this);
            }
        }

        protected int getRand() {
            return this.rand;
        }

        protected int[] getRandList() {
            return this.rand_list;
        }

        @Override
        public Download getRelatedToDownload() {
            try {
                return RelatedContentManager.this.getDownload(this.getRelatedToHash());
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
                return null;
            }
        }

        @Override
        public void delete() {
            RelatedContentManager.this.delete(new RelatedContent[]{this});
        }

        @Override
        public String getString() {
            return super.getString() + ", " + this.rand + ", rl=" + this.rand_list + ", last_seen=" + this.last_seen + ", level=" + this.level;
        }
    }

    protected static class ByteArrayHashMapEx<T>
    extends ByteArrayHashMap<T> {
        protected ByteArrayHashMapEx() {
        }

        public T getRandomValueExcluding(T t) {
            int n = RandomUtils.nextInt(this.size);
            T t2 = null;
            for (int i = 0; i < this.table.length; ++i) {
                ByteArrayHashMap.Entry entry = this.table[i];
                while (entry != null) {
                    Object s = entry.value;
                    if (s != t) {
                        t2 = (T)s;
                    }
                    if (n <= 0 && t2 != null) {
                        return t2;
                    }
                    --n;
                    entry = entry.next;
                }
            }
            return t2;
        }
    }
}

