/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacket;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import com.aelitis.net.udp.uc.PRUDPPacketReply;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;

public class DHTUDPPacketReply
extends PRUDPPacketReply
implements DHTUDPPacket {
    public static final int DHT_HEADER_SIZE = 22;
    private DHTTransportUDPImpl transport;
    private long connection_id;
    private byte protocol_version;
    private byte vendor_id = (byte)-1;
    private int network;
    private int target_instance_id;
    private long skew;
    private DHTNetworkPosition[] network_positions;

    public DHTUDPPacketReply(DHTTransportUDPImpl dHTTransportUDPImpl, int n, int n2, long l, DHTTransportContact dHTTransportContact, DHTTransportContact dHTTransportContact2) {
        super(n, n2);
        this.transport = dHTTransportUDPImpl;
        this.connection_id = l;
        this.protocol_version = dHTTransportContact2.getProtocolVersion();
        if (this.protocol_version > dHTTransportUDPImpl.getProtocolVersion()) {
            this.protocol_version = dHTTransportUDPImpl.getProtocolVersion();
        }
        this.target_instance_id = dHTTransportContact.getInstanceID();
        this.skew = dHTTransportContact2.getClockSkew();
    }

    protected DHTUDPPacketReply(DHTUDPPacketNetworkHandler dHTUDPPacketNetworkHandler, InetSocketAddress inetSocketAddress, DataInputStream dataInputStream, int n, int n2) throws IOException {
        super(n, n2);
        this.setAddress(inetSocketAddress);
        this.connection_id = dataInputStream.readLong();
        this.protocol_version = dataInputStream.readByte();
        if (this.protocol_version >= 14) {
            this.vendor_id = dataInputStream.readByte();
        }
        if (this.protocol_version >= 9) {
            this.network = dataInputStream.readInt();
        }
        if (this.protocol_version < (this.network == 1 ? (byte)50 : 22)) {
            throw new IOException("Invalid DHT protocol version, please update Azureus");
        }
        this.transport = dHTUDPPacketNetworkHandler.getTransport(this);
        this.target_instance_id = dataInputStream.readInt();
    }

    @Override
    public DHTTransportUDPImpl getTransport() {
        return this.transport;
    }

    protected int getTargetInstanceID() {
        return this.target_instance_id;
    }

    public long getConnectionId() {
        return this.connection_id;
    }

    protected long getClockSkew() {
        return this.skew;
    }

    @Override
    public byte getProtocolVersion() {
        return this.protocol_version;
    }

    protected byte getVendorID() {
        return this.vendor_id;
    }

    public int getNetwork() {
        return this.network;
    }

    public void setNetwork(int n) {
        this.network = n;
    }

    protected DHTNetworkPosition[] getNetworkPositions() {
        return this.network_positions;
    }

    protected void setNetworkPositions(DHTNetworkPosition[] dHTNetworkPositionArray) {
        this.network_positions = dHTNetworkPositionArray;
    }

    @Override
    public void serialise(DataOutputStream dataOutputStream) throws IOException {
        super.serialise(dataOutputStream);
        dataOutputStream.writeLong(this.connection_id);
        dataOutputStream.writeByte(this.protocol_version);
        if (this.protocol_version >= 14) {
            dataOutputStream.writeByte(0);
        }
        if (this.protocol_version >= 9) {
            dataOutputStream.writeInt(this.network);
        }
        dataOutputStream.writeInt(this.target_instance_id);
    }

    @Override
    public String getString() {
        return super.getString() + ",[con=" + this.connection_id + ",prot=" + this.protocol_version + ",ven=" + this.vendor_id + ",net=" + this.network + "]";
    }
}

