/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.cache.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManager;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerStats;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileOwner;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheEntry;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileManagerStatsImpl;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileWithCache;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileWithoutCache;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileWithoutCacheMT;
import com.aelitis.azureus.core.diskmanager.file.FMFile;
import com.aelitis.azureus.core.diskmanager.file.FMFileManager;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerFactory;
import com.aelitis.azureus.core.diskmanager.file.FMFileOwner;
import com.aelitis.azureus.core.util.CaseSensitiveFileMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class CacheFileManagerImpl
implements CacheFileManager,
AEDiagnosticsEvidenceGenerator {
    private static final LogIDs LOGID = LogIDs.CACHE;
    public static final boolean DEBUG = false;
    public static final int CACHE_CLEANER_TICKS = 60;
    public static final int STATS_UPDATE_FREQUENCY = 1000;
    public static final long DIRTY_CACHE_WRITE_MAX_AGE = 120000L;
    protected boolean cache_enabled;
    protected boolean cache_read_enabled;
    protected boolean cache_write_enabled;
    protected long cache_size;
    protected long cache_files_not_smaller_than;
    protected long cache_minimum_free_size;
    protected long cache_space_free;
    private long cache_file_id_next = 0L;
    protected FMFileManager file_manager;
    protected WeakHashMap cache_files = new WeakHashMap();
    protected WeakHashMap updated_cache_files = null;
    protected LinkedHashMap cache_entries = new LinkedHashMap(1024, 0.75f, true);
    protected CacheFileManagerStatsImpl stats;
    protected Map torrent_to_cache_file_map = new LightHashMap();
    protected long cache_bytes_written;
    protected long cache_bytes_read;
    protected long file_bytes_written;
    protected long file_bytes_read;
    protected long cache_read_count;
    protected long cache_write_count;
    protected long file_read_count;
    protected long file_write_count;
    protected AEMonitor this_mon = new AEMonitor("CacheFileManager");
    private long cleaner_ticks = 60L;

    protected static int convertCacheToFileType(int n) {
        if (n == 1) {
            return 1;
        }
        if (n == 2) {
            return 2;
        }
        if (n == 3) {
            return 3;
        }
        return 4;
    }

    protected static int convertFileToCacheType(int n) {
        if (n == 1) {
            return 1;
        }
        if (n == 2) {
            return 2;
        }
        if (n == 3) {
            return 3;
        }
        return 4;
    }

    public CacheFileManagerImpl() {
        AEDiagnostics.addEvidenceGenerator(this);
        this.file_manager = FMFileManagerFactory.getSingleton();
        boolean bl = COConfigurationManager.getBooleanParameter("diskmanager.perf.cache.enable");
        boolean bl2 = COConfigurationManager.getBooleanParameter("diskmanager.perf.cache.enable.read");
        boolean bl3 = COConfigurationManager.getBooleanParameter("diskmanager.perf.cache.enable.write");
        long l = 0x100000L * (long)COConfigurationManager.getIntParameter("diskmanager.perf.cache.size");
        int n = 1024 * COConfigurationManager.getIntParameter("notsmallerthan");
        if (l <= 0L) {
            Debug.out("Invalid cache size parameter (" + l + "), caching disabled");
            bl = false;
        }
        this.initialise(bl, bl2, bl3, l, n);
    }

    protected void initialise(boolean bl, boolean bl2, boolean bl3, long l, long l2) {
        this.cache_enabled = bl && (bl2 || bl3);
        this.cache_read_enabled = bl && bl2;
        this.cache_write_enabled = bl && bl3;
        this.cache_size = l;
        this.cache_files_not_smaller_than = l2;
        this.cache_minimum_free_size = this.cache_size / 4L;
        this.cache_space_free = this.cache_size;
        this.stats = new CacheFileManagerStatsImpl(this);
        this.cacheStatsAndCleaner();
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "DiskCache: enabled = " + this.cache_enabled + ", read = " + this.cache_read_enabled + ", write = " + this.cache_write_enabled + ", size = " + this.cache_size + " B"));
        }
    }

    protected boolean isWriteCacheEnabled() {
        return this.cache_write_enabled;
    }

    protected boolean isReadCacheEnabled() {
        return this.cache_read_enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheFile createFile(final CacheFileOwner cacheFileOwner, File file, int n) throws CacheFileManagerException {
        long l;
        try {
            this.this_mon.enter();
            l = this.cache_file_id_next++;
        }
        finally {
            this.this_mon.exit();
        }
        int n2 = CacheFileManagerImpl.convertCacheToFileType(n);
        try {
            CacheFile cacheFile;
            FMFile fMFile = this.file_manager.createFile(new FMFileOwner(){

                @Override
                public String getName() {
                    return cacheFileOwner.getCacheFileOwnerName() + "[" + l + "]";
                }

                @Override
                public TOTorrentFile getTorrentFile() {
                    return cacheFileOwner.getCacheFileTorrentFile();
                }

                @Override
                public File getControlFileDir() {
                    return cacheFileOwner.getCacheFileControlFileDir();
                }
            }, file, n2);
            TOTorrentFile tOTorrentFile = cacheFileOwner.getCacheFileTorrentFile();
            int n3 = cacheFileOwner.getCacheMode();
            if (n3 == 3) {
                cacheFile = new CacheFileWithoutCacheMT(this, fMFile, tOTorrentFile);
            } else if (tOTorrentFile != null && tOTorrentFile.getLength() < this.cache_files_not_smaller_than || !this.cache_enabled || n3 == 2) {
                cacheFile = new CacheFileWithoutCache(this, fMFile, tOTorrentFile);
            } else {
                cacheFile = new CacheFileWithCache(this, fMFile, tOTorrentFile);
                try {
                    this.this_mon.enter();
                    if (this.updated_cache_files == null) {
                        this.updated_cache_files = new WeakHashMap(this.cache_files);
                    }
                    this.updated_cache_files.put(cacheFile, null);
                    if (tOTorrentFile != null) {
                        this.torrent_to_cache_file_map.put(tOTorrentFile, cacheFile);
                    }
                }
                finally {
                    this.this_mon.exit();
                }
            }
            return cacheFile;
        }
        catch (FMFileManagerException fMFileManagerException) {
            this.rethrow(null, fMFileManagerException);
            return null;
        }
    }

    @Override
    public CacheFileManagerStats getStats() {
        return this.stats;
    }

    protected boolean isCacheEnabled() {
        return this.cache_enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheEntry allocateCacheSpace(int n, CacheFileWithCache cacheFileWithCache, DirectByteBuffer directByteBuffer, long l, int n2) throws CacheFileManagerException {
        CacheEntry cacheEntry;
        boolean bl = false;
        boolean bl2 = false;
        while (!bl) {
            cacheEntry = null;
            try {
                this.this_mon.enter();
                if ((long)n2 < this.cache_space_free || this.cache_space_free == this.cache_size) {
                    bl = true;
                } else {
                    cacheEntry = (CacheEntry)this.cache_entries.keySet().iterator().next();
                }
            }
            finally {
                this.this_mon.exit();
            }
            if (bl) continue;
            bl2 = true;
            long l2 = this.cache_space_free;
            CacheFileWithCache cacheFileWithCache2 = cacheEntry.getFile();
            try {
                cacheFileWithCache2.flushCache(cacheEntry.getFilePosition(), true, this.cache_minimum_free_size);
            }
            catch (CacheFileManagerException cacheFileManagerException) {
                if (cacheFileWithCache2 != cacheFileWithCache) {
                    cacheFileWithCache2.setPendingException(cacheFileManagerException);
                }
                throw cacheFileManagerException;
            }
            long l3 = this.cache_space_free - l2;
            if (Logger.isEnabled()) {
                TOTorrentFile tOTorrentFile = cacheFileWithCache.getTorrentFile();
                TOTorrent tOTorrent = tOTorrentFile == null ? null : tOTorrentFile.getTorrent();
                Logger.log(new LogEvent(tOTorrent, LOGID, "DiskCache: cache full, flushed " + l3 + " from " + cacheFileWithCache2.getName()));
            }
            if (l3 != 0L) continue;
            try {
                this.this_mon.enter();
                if (this.cache_entries.size() <= 0 || (CacheEntry)this.cache_entries.keySet().iterator().next() != cacheEntry) continue;
                throw new CacheFileManagerException(null, "Cache inconsistent: 0 flushed");
            }
            finally {
                this.this_mon.exit();
            }
        }
        cacheEntry = new CacheEntry(n, cacheFileWithCache, directByteBuffer, l, n2);
        if (bl2 && Logger.isEnabled()) {
            TOTorrentFile tOTorrentFile = cacheFileWithCache.getTorrentFile();
            TOTorrent tOTorrent = tOTorrentFile == null ? null : tOTorrentFile.getTorrent();
            Logger.log(new LogEvent(tOTorrent, LOGID, "DiskCache: cr=" + this.cache_bytes_read + ",cw=" + this.cache_bytes_written + ",fr=" + this.file_bytes_read + ",fw=" + this.file_bytes_written));
        }
        return cacheEntry;
    }

    protected void cacheStatsAndCleaner() {
        SimpleTimer.addPeriodicEvent("CacehFile:stats", 1000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(TimerEvent timerEvent2) {
                CacheFileManagerImpl.this.stats.update();
                Iterator iterator = CacheFileManagerImpl.this.cache_files.keySet().iterator();
                while (iterator.hasNext()) {
                    ((CacheFileWithCache)iterator.next()).updateStats();
                }
                if (--CacheFileManagerImpl.this.cleaner_ticks == 0L) {
                    CacheFileManagerImpl.this.cleaner_ticks = 60L;
                    HashSet<CacheFileWithCache> hashSet = new HashSet<CacheFileWithCache>();
                    long l = SystemTime.getCurrentTime() - 120000L;
                    try {
                        CacheFileManagerImpl.this.this_mon.enter();
                        if (CacheFileManagerImpl.this.updated_cache_files != null) {
                            CacheFileManagerImpl.this.cache_files = CacheFileManagerImpl.this.updated_cache_files;
                            CacheFileManagerImpl.this.updated_cache_files = null;
                        }
                        if (CacheFileManagerImpl.this.cache_entries.size() > 0) {
                            for (CacheEntry object : CacheFileManagerImpl.this.cache_entries.keySet()) {
                                if (!object.isDirty()) continue;
                                hashSet.add(object.getFile());
                            }
                        }
                    }
                    finally {
                        CacheFileManagerImpl.this.this_mon.exit();
                    }
                    for (CacheFileWithCache cacheFileWithCache : hashSet) {
                        try {
                            TOTorrentFile throwable = cacheFileWithCache.getTorrentFile();
                            long l2 = -1L;
                            if (throwable != null) {
                                l2 = throwable.getTorrent().getPieceLength();
                            }
                            cacheFileWithCache.flushOldDirtyData(l, l2);
                        }
                        catch (CacheFileManagerException cacheFileManagerException) {
                            cacheFileWithCache.setPendingException(cacheFileManagerException);
                            Debug.printStackTrace(cacheFileManagerException);
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCacheSpace(CacheEntry cacheEntry) throws CacheFileManagerException {
        try {
            this.this_mon.enter();
            this.cache_space_free -= (long)cacheEntry.getLength();
            this.cache_entries.put(cacheEntry, cacheEntry);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheEntryUsed(CacheEntry cacheEntry) throws CacheFileManagerException {
        try {
            this.this_mon.enter();
            if (this.cache_entries.get(cacheEntry) == null) {
                Debug.out("Cache inconsistency: entry missing on usage");
                throw new CacheFileManagerException(null, "Cache inconsistency: entry missing on usage");
            }
            cacheEntry.used();
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseCacheSpace(CacheEntry cacheEntry) throws CacheFileManagerException {
        cacheEntry.getBuffer().returnToPool();
        try {
            this.this_mon.enter();
            this.cache_space_free += (long)cacheEntry.getLength();
            if (this.cache_entries.remove(cacheEntry) == null) {
                Debug.out("Cache inconsistency: entry missing on removal");
                throw new CacheFileManagerException(null, "Cache inconsistency: entry missing on removal");
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected long getCacheSize() {
        return this.cache_size;
    }

    protected long getCacheUsed() {
        long l = this.cache_space_free;
        if (l < 0L) {
            l = 0L;
        }
        return this.cache_size - l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheBytesWritten(long l) {
        try {
            this.this_mon.enter();
            this.cache_bytes_written += l;
            ++this.cache_write_count;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheBytesRead(int n) {
        try {
            this.this_mon.enter();
            this.cache_bytes_read += (long)n;
            ++this.cache_read_count;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fileBytesWritten(long l) {
        try {
            this.this_mon.enter();
            this.file_bytes_written += l;
            ++this.file_write_count;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fileBytesRead(int n) {
        try {
            this.this_mon.enter();
            this.file_bytes_read += (long)n;
            ++this.file_read_count;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected long getBytesWrittenToCache() {
        return this.cache_bytes_written;
    }

    protected long getBytesWrittenToFile() {
        return this.file_bytes_written;
    }

    protected long getBytesReadFromCache() {
        return this.cache_bytes_read;
    }

    protected long getBytesReadFromFile() {
        return this.file_bytes_read;
    }

    public long getCacheReadCount() {
        return this.cache_read_count;
    }

    public long getCacheWriteCount() {
        return this.cache_write_count;
    }

    public long getFileReadCount() {
        return this.file_read_count;
    }

    public long getFileWriteCount() {
        return this.file_write_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeFile(CacheFileWithCache cacheFileWithCache) {
        TOTorrentFile tOTorrentFile = cacheFileWithCache.getTorrentFile();
        if (tOTorrentFile != null && this.torrent_to_cache_file_map.get(tOTorrentFile) != null) {
            try {
                this.this_mon.enter();
                this.torrent_to_cache_file_map.remove(tOTorrentFile);
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean[] getBytesInCache(TOTorrent tOTorrent, long[] lArray, long[] lArray2) {
        TOTorrentFile tOTorrentFile;
        int n;
        if (lArray.length != lArray2.length) {
            throw new IllegalArgumentException("Offsets/Lengths mismatch");
        }
        long l = 0L;
        for (int i = 0; i < lArray2.length; ++i) {
            if (lArray[i] < l || lArray2[i] <= 0L) {
                throw new IllegalArgumentException("Offsets/Lengths are not in ascending order");
            }
            l = lArray[i] + lArray2[i];
        }
        TOTorrentFile[] tOTorrentFileArray = tOTorrent.getFiles();
        long[] lArray3 = new long[tOTorrentFileArray.length];
        boolean[] blArray = new boolean[lArray.length];
        Arrays.fill(blArray, true);
        long l2 = lArray[0];
        long l3 = lArray[lArray.length - 1] + lArray2[lArray2.length - 1];
        long l4 = 0L;
        int n2 = -1;
        boolean bl = false;
        LightHashMap lightHashMap = new LightHashMap();
        try {
            for (n = 0; n < tOTorrentFileArray.length; ++n) {
                tOTorrentFile = tOTorrentFileArray[n];
                long l5 = tOTorrentFile.getLength();
                lArray3[n] = l4;
                if (n2 == -1 && l4 <= l2 && l2 < l4 + l5) {
                    n2 = n;
                    this.this_mon.enter();
                    bl = true;
                }
                if (l4 > l3) {
                    break;
                }
                if (bl) {
                    CacheFileWithCache cacheFileWithCache = (CacheFileWithCache)this.torrent_to_cache_file_map.get(tOTorrentFile);
                    lightHashMap.put(tOTorrentFile, cacheFileWithCache);
                }
                l4 += l5;
            }
        }
        finally {
            if (bl) {
                this.this_mon.exit();
            }
        }
        for (n = n2; -1 < n && n < tOTorrentFileArray.length; ++n) {
            tOTorrentFile = tOTorrentFileArray[n];
            CacheFileWithCache cacheFileWithCache = (CacheFileWithCache)lightHashMap.get(tOTorrentFile);
            long l6 = tOTorrentFile.getLength();
            l4 = lArray3[n];
            if (l4 > l3) break;
            if (cacheFileWithCache != null) {
                cacheFileWithCache.getBytesInCache(blArray, lArray, lArray2);
                continue;
            }
            for (int i = 0; i < blArray.length; ++i) {
                if ((lArray[i] >= l4 + l6 || lArray[i] <= l4) && (lArray[i] + lArray2[i] >= l4 + l6 || lArray[i] + lArray2[i] <= l4)) continue;
                blArray[i] = false;
            }
        }
        if (!bl) {
            Arrays.fill(blArray, false);
        }
        return blArray;
    }

    protected void rethrow(CacheFile cacheFile, FMFileManagerException fMFileManagerException) throws CacheFileManagerException {
        Throwable throwable = fMFileManagerException.getCause();
        if (throwable != null) {
            throw new CacheFileManagerException(cacheFile, fMFileManagerException.getMessage(), throwable);
        }
        throw new CacheFileManagerException(cacheFile, fMFileManagerException.getMessage(), fMFileManagerException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter indentWriter) {
        indentWriter.println("Cache Manager");
        try {
            Iterator iterator;
            indentWriter.indent();
            try {
                this.this_mon.enter();
                iterator = new ArrayList(this.cache_entries.keySet()).iterator();
            }
            finally {
                this.this_mon.exit();
            }
            indentWriter.println("Entries = " + this.cache_entries.size());
            HashSet<CacheFileWithCache> hashSet = new HashSet<CacheFileWithCache>();
            while (iterator.hasNext()) {
                String string;
                TOTorrentFile tOTorrentFile;
                CacheFileWithCache cacheFileWithCache;
                block13: {
                    CacheEntry cacheEntry = (CacheEntry)iterator.next();
                    cacheFileWithCache = cacheEntry.getFile();
                    if (hashSet.contains(cacheFileWithCache)) continue;
                    hashSet.add(cacheFileWithCache);
                    tOTorrentFile = cacheFileWithCache.getTorrentFile();
                    string = "";
                    try {
                        string = "" + cacheFileWithCache.getLength();
                    }
                    catch (Exception exception) {
                        if (tOTorrentFile == null) break block13;
                        string = "" + tOTorrentFile.getLength();
                    }
                }
                String string2 = "<unknown>";
                try {
                    if (tOTorrentFile != null) {
                        string2 = ByteFormatter.encodeString(tOTorrentFile.getTorrent().getHash());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                String string3 = cacheFileWithCache.getName();
                indentWriter.println("File: " + Debug.secretFileName(string3) + ", size " + string + ", torrent " + string2 + ", access = " + cacheFileWithCache.getAccessMode());
            }
        }
        finally {
            indentWriter.exdent();
        }
    }

    @Override
    public void setFileLinks(TOTorrent tOTorrent, CaseSensitiveFileMap caseSensitiveFileMap) {
        this.file_manager.setFileLinks(tOTorrent, caseSensitiveFileMap);
    }
}

