/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.file.impl;

import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileAccess;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileImpl;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.FileUtil;

public class FMFileAccessCompact
implements FMFileAccess {
    private static final byte SS = 4;
    private TOTorrentFile torrent_file;
    private int piece_size;
    private File controlFileDir;
    private String controlFileName;
    private FMFileAccess delegate;
    private volatile long current_length;
    private long version = 0L;
    private volatile boolean write_required;
    private long first_piece_start;
    private long first_piece_length;
    private long last_piece_start;
    private long last_piece_length;

    protected FMFileAccessCompact(TOTorrentFile tOTorrentFile, File file, String string, FMFileAccess fMFileAccess) throws FMFileManagerException {
        this.torrent_file = tOTorrentFile;
        this.controlFileDir = file;
        this.controlFileName = string;
        this.delegate = fMFileAccess;
        try {
            TOTorrentFile tOTorrentFile2;
            int n;
            this.piece_size = (int)this.torrent_file.getTorrent().getPieceLength();
            TOTorrent tOTorrent = this.torrent_file.getTorrent();
            long l = this.torrent_file.getLength();
            long l2 = 0L;
            for (n = 0; n < tOTorrent.getFiles().length && (tOTorrentFile2 = tOTorrent.getFiles()[n]) != this.torrent_file; ++n) {
                l2 += tOTorrentFile2.getLength();
            }
            n = this.piece_size - (int)(l2 % (long)this.piece_size);
            if (n == this.piece_size) {
                n = 0;
            }
            this.first_piece_length = n;
            this.first_piece_start = 0L;
            if (this.first_piece_length >= l) {
                this.first_piece_length = l;
                this.last_piece_start = l;
                this.last_piece_length = 0L;
            } else {
                this.last_piece_length = (l - (long)n) % (long)this.piece_size;
                this.last_piece_start = l - this.last_piece_length;
            }
            if (!new File(this.controlFileDir, this.controlFileName).exists()) {
                if (!this.controlFileDir.isDirectory() && !FileUtil.mkdirs(this.controlFileDir)) {
                    throw new FMFileManagerException("Directory creation failed: " + this.controlFileDir);
                }
                if (this.current_length > 0L) {
                    this.write_required = true;
                    this.writeState();
                }
            } else {
                this.readState();
            }
        }
        catch (Throwable throwable) {
            throw new FMFileManagerException("Compact file init fail", throwable);
        }
    }

    protected long getFirstPieceStart() {
        return this.first_piece_start;
    }

    protected long getFirstPieceLength() {
        return this.first_piece_length;
    }

    protected long getLastPieceStart() {
        return this.last_piece_start;
    }

    protected long getLastPieceLength() {
        return this.last_piece_length;
    }

    @Override
    public void aboutToOpen() throws FMFileManagerException {
        this.delegate.aboutToOpen();
    }

    @Override
    public long getLength(RandomAccessFile randomAccessFile) throws FMFileManagerException {
        return this.current_length;
    }

    @Override
    public void setLength(RandomAccessFile randomAccessFile, long l) throws FMFileManagerException {
        if (l != this.current_length) {
            this.current_length = l;
            this.write_required = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void read(RandomAccessFile randomAccessFile, DirectByteBuffer directByteBuffer, long l) throws FMFileManagerException {
        int n = directByteBuffer.limit((byte)4);
        try {
            int n2 = n - directByteBuffer.position((byte)4);
            if (l < this.first_piece_start + this.first_piece_length) {
                int n3 = (int)(this.first_piece_start + this.first_piece_length - l);
                if (n3 >= n2) {
                    this.delegate.read(randomAccessFile, new DirectByteBuffer[]{directByteBuffer}, l);
                    l += (long)n2;
                    n2 = 0;
                } else {
                    directByteBuffer.limit((byte)4, directByteBuffer.position((byte)4) + n3);
                    this.delegate.read(randomAccessFile, new DirectByteBuffer[]{directByteBuffer}, l);
                    directByteBuffer.limit((byte)4, n);
                    l += (long)n3;
                    n2 -= n3;
                }
            }
            if (n2 == 0) {
                return;
            }
            long l2 = this.last_piece_start - l;
            if (l2 > 0L) {
                if (l2 >= (long)n2) {
                    directByteBuffer.position((byte)4, n);
                    l += (long)n2;
                    n2 = 0;
                } else {
                    directByteBuffer.position((byte)4, directByteBuffer.position((byte)4) + (int)l2);
                    l += l2;
                    n2 = (int)((long)n2 - l2);
                }
            }
            if (n2 == 0) {
                return;
            }
            this.delegate.read(randomAccessFile, new DirectByteBuffer[]{directByteBuffer}, l - this.last_piece_start + this.first_piece_length);
        }
        finally {
            directByteBuffer.limit((byte)4, n);
        }
    }

    @Override
    public void read(RandomAccessFile randomAccessFile, DirectByteBuffer[] directByteBufferArray, long l) throws FMFileManagerException {
        for (int i = 0; i < directByteBufferArray.length; ++i) {
            DirectByteBuffer directByteBuffer = directByteBufferArray[i];
            int n = directByteBufferArray[i].limit((byte)4) - directByteBufferArray[i].position((byte)4);
            this.read(randomAccessFile, directByteBuffer, l);
            int n2 = directByteBufferArray[i].remaining((byte)4);
            l += (long)(n - n2);
            if (n2 > 0) break;
        }
        if (l > this.current_length) {
            this.setLength(randomAccessFile, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(RandomAccessFile randomAccessFile, DirectByteBuffer directByteBuffer, long l) throws FMFileManagerException {
        int n = directByteBuffer.limit((byte)4);
        try {
            int n2 = n - directByteBuffer.position((byte)4);
            if (l < this.first_piece_start + this.first_piece_length) {
                int n3 = (int)(this.first_piece_start + this.first_piece_length - l);
                if (n3 >= n2) {
                    this.delegate.write(randomAccessFile, new DirectByteBuffer[]{directByteBuffer}, l);
                    l += (long)n2;
                    n2 = 0;
                } else {
                    directByteBuffer.limit((byte)4, directByteBuffer.position((byte)4) + n3);
                    this.delegate.write(randomAccessFile, new DirectByteBuffer[]{directByteBuffer}, l);
                    directByteBuffer.limit((byte)4, n);
                    l += (long)n3;
                    n2 -= n3;
                }
            }
            if (n2 == 0) {
                return;
            }
            long l2 = this.last_piece_start - l;
            if (l2 > 0L) {
                if (l2 >= (long)n2) {
                    directByteBuffer.position((byte)4, n);
                    l += (long)n2;
                    n2 = 0;
                } else {
                    directByteBuffer.position((byte)4, directByteBuffer.position((byte)4) + (int)l2);
                    l += l2;
                    n2 = (int)((long)n2 - l2);
                }
            }
            if (n2 == 0) {
                return;
            }
            this.delegate.write(randomAccessFile, new DirectByteBuffer[]{directByteBuffer}, l - this.last_piece_start + this.first_piece_length);
        }
        finally {
            directByteBuffer.limit((byte)4, n);
        }
    }

    @Override
    public void write(RandomAccessFile randomAccessFile, DirectByteBuffer[] directByteBufferArray, long l) throws FMFileManagerException {
        for (int i = 0; i < directByteBufferArray.length; ++i) {
            DirectByteBuffer directByteBuffer = directByteBufferArray[i];
            int n = directByteBufferArray[i].limit((byte)4) - directByteBufferArray[i].position((byte)4);
            this.write(randomAccessFile, directByteBuffer, l);
            l += (long)n;
        }
        if (l > this.current_length) {
            this.setLength(randomAccessFile, l);
        }
    }

    @Override
    public void flush() throws FMFileManagerException {
        this.writeState();
    }

    @Override
    public boolean isPieceCompleteProcessingNeeded(int n) {
        return false;
    }

    @Override
    public void setPieceComplete(RandomAccessFile randomAccessFile, int n, DirectByteBuffer directByteBuffer) throws FMFileManagerException {
    }

    protected void readState() throws FMFileManagerException {
        try {
            Map map = FileUtil.readResilientFile(this.controlFileDir, this.controlFileName, false);
            if (map != null && map.size() > 0) {
                Long l = (Long)map.get("version");
                Long l2 = (Long)map.get("length");
                this.current_length = l2;
            }
        }
        catch (Throwable throwable) {
            throw new FMFileManagerException("Failed to read control file state", throwable);
        }
    }

    protected void writeState() throws FMFileManagerException {
        boolean bl = this.write_required;
        if (bl) {
            this.write_required = false;
            try {
                HashMap<String, Long> hashMap = new HashMap<String, Long>();
                hashMap.put("version", new Long(this.version));
                hashMap.put("length", new Long(this.current_length));
                FileUtil.writeResilientFile(this.controlFileDir, this.controlFileName, hashMap, false);
            }
            catch (Throwable throwable) {
                throw new FMFileManagerException("Failed to write control file state", throwable);
            }
        }
    }

    @Override
    public FMFileImpl getFile() {
        return this.delegate.getFile();
    }

    @Override
    public String getString() {
        return "compact";
    }
}

