/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreException;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.AzureusCoreLifecycleListener;
import com.aelitis.azureus.core.AzureusCoreListener;
import com.aelitis.azureus.core.AzureusCoreOperation;
import com.aelitis.azureus.core.AzureusCoreOperationListener;
import com.aelitis.azureus.core.AzureusCoreOperationTask;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.custom.CustomizationManagerFactory;
import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.instancemanager.AZInstanceManager;
import com.aelitis.azureus.core.instancemanager.AZInstanceManagerAdapter;
import com.aelitis.azureus.core.instancemanager.AZInstanceManagerFactory;
import com.aelitis.azureus.core.instancemanager.AZInstanceTracked;
import com.aelitis.azureus.core.nat.NATTraverser;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNetworkInterface;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNetworkInterfaceAddress;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminPropertyChangeListener;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.pairing.PairingManagerFactory;
import com.aelitis.azureus.core.peermanager.PeerManager;
import com.aelitis.azureus.core.peermanager.nat.PeerNATTraverser;
import com.aelitis.azureus.core.security.CryptoManager;
import com.aelitis.azureus.core.security.CryptoManagerFactory;
import com.aelitis.azureus.core.speedmanager.SpeedManager;
import com.aelitis.azureus.core.speedmanager.SpeedManagerAdapter;
import com.aelitis.azureus.core.speedmanager.SpeedManagerFactory;
import com.aelitis.azureus.core.update.AzureusRestarterFactory;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import com.aelitis.azureus.plugins.clientid.ClientIDPlugin;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import com.aelitis.azureus.plugins.tracker.dht.DHTTrackerPlugin;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManagerFactory;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.global.GlobalMangerProgressListener;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipfilter.IpFilterManager;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.host.TRHost;
import org.gudy.azureus2.core3.tracker.host.TRHostFactory;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.NonDaemonTaskRunner;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.platform.PlatformManagerListener;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginEventListener;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.PluginManagerDefaults;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

public class AzureusCoreImpl
implements AzureusCore {
    private static final LogIDs LOGID = LogIDs.CORE;
    protected static AzureusCore singleton;
    protected static AEMonitor class_mon;
    private static final String DM_ANNOUNCE_KEY = "AzureusCore:announce_key";
    private static final boolean LOAD_PLUGINS_IN_OTHER_THREAD = true;
    static List<AzureusCoreRunningListener> coreRunningListeners;
    static AEMonitor mon_coreRunningListeners;
    private PluginInitializer pi;
    private GlobalManager global_manager;
    private AZInstanceManager instance_manager;
    private SpeedManager speed_manager;
    private CryptoManager crypto_manager;
    private NATTraverser nat_traverser;
    private long create_time = SystemTime.getCurrentTime();
    private volatile boolean started;
    private volatile boolean stopped;
    private volatile boolean restarting;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private CopyOnWriteList lifecycle_listeners = new CopyOnWriteList();
    private List operation_listeners = new ArrayList();
    private AESemaphore stopping_sem = new AESemaphore("AzureusCore::stopping");
    private AEMonitor this_mon = new AEMonitor("AzureusCore");
    private AzureusCoreOperation initialisation_op = this.createOperation(1);
    public static boolean SUPPRESS_CLASSLOADER_ERRORS;
    private boolean ca_shutdown_computer_after_stop = false;
    private long ca_last_time_downloading = -1L;
    private long ca_last_time_seeding = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AzureusCore create() throws AzureusCoreException {
        try {
            class_mon.enter();
            if (singleton != null) {
                throw new AzureusCoreException("Azureus core already instantiated");
            }
            AzureusCore azureusCore = singleton = new AzureusCoreImpl();
            return azureusCore;
        }
        finally {
            class_mon.exit();
        }
    }

    public static boolean isCoreAvailable() {
        return singleton != null;
    }

    public static boolean isCoreRunning() {
        return singleton != null && singleton.isStarted();
    }

    public static AzureusCore getSingleton() throws AzureusCoreException {
        if (singleton == null) {
            throw new AzureusCoreException("core not instantiated");
        }
        return singleton;
    }

    protected AzureusCoreImpl() {
        COConfigurationManager.initialise();
        MessageText.loadBundle();
        AEDiagnostics.startup(COConfigurationManager.getBooleanParameter("diags.enable.pending.writes", false));
        COConfigurationManager.setParameter("diags.enable.pending.writes", false);
        AEDiagnostics.markDirty();
        AETemporaryFileHandler.startup();
        AEThread2.setOurThread();
        COConfigurationManager.setParameter("azureus.application.directory", SystemProperties.getApplicationPath());
        this.crypto_manager = CryptoManagerFactory.getSingleton();
        PlatformManagerFactory.getPlatformManager().addListener(new PlatformManagerListener(){

            @Override
            public void eventOccurred(int n) {
                if (n == 1) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Platform manager requested shutdown"));
                    }
                    AzureusCoreImpl.this.requestStop();
                } else if (n == 2) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Platform manager requested suspend"));
                    }
                    COConfigurationManager.save();
                } else if (n == 3) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Platform manager requested resume"));
                    }
                    AzureusCoreImpl.this.announceAll(true);
                }
            }
        });
        CustomizationManagerFactory.getSingleton();
        NetworkManager.getSingleton();
        PeerManager.getSingleton();
        ClientIDPlugin.initialize();
        this.pi = PluginInitializer.getSingleton(this, this.initialisation_op);
        this.instance_manager = AZInstanceManagerFactory.getSingleton(new AZInstanceManagerAdapter(){

            @Override
            public String getID() {
                return COConfigurationManager.getStringParameter("ID", "");
            }

            @Override
            public InetAddress getPublicAddress() {
                return PluginInitializer.getDefaultInterface().getUtilities().getPublicAddress();
            }

            @Override
            public int[] getPorts() {
                return new int[]{TCPNetworkManager.getSingleton().getTCPListeningPortNumber(), UDPNetworkManager.getSingleton().getUDPListeningPortNumber(), UDPNetworkManager.getSingleton().getUDPNonDataListeningPortNumber()};
            }

            @Override
            public AZInstanceManagerAdapter.VCPublicAddress getVCPublicAddress() {
                return new AZInstanceManagerAdapter.VCPublicAddress(){
                    private VersionCheckClient vcc = VersionCheckClient.getSingleton();

                    @Override
                    public String getAddress() {
                        return this.vcc.getExternalIpAddress(true, false);
                    }

                    @Override
                    public long getCacheTime() {
                        1 v0 = this;
                        return v0.vcc.getSingleton().getCacheTime(false);
                    }
                };
            }

            @Override
            public AZInstanceTracked.TrackTarget track(byte[] byArray) {
                Object object;
                List list = AzureusCoreImpl.this.getGlobalManager().getDownloadManagers();
                Iterator iterator = list.iterator();
                DownloadManager downloadManager = null;
                try {
                    while (iterator.hasNext()) {
                        DownloadManager downloadManager2 = (DownloadManager)iterator.next();
                        object = downloadManager2.getTorrent();
                        if (object == null) continue;
                        byte[] byArray2 = (byte[])downloadManager2.getData("AZInstanceManager::sha1_hash");
                        if (byArray2 == null) {
                            byArray2 = new SHA1Simple().calculateHash(object.getHash());
                            downloadManager2.setData("AZInstanceManager::sha1_hash", byArray2);
                        }
                        if (!Arrays.equals(byArray, byArray2)) continue;
                        downloadManager = downloadManager2;
                        break;
                    }
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
                if (downloadManager == null) {
                    return null;
                }
                if (!downloadManager.getDownloadState().isPeerSourceEnabled("Plugin")) {
                    return null;
                }
                int n = downloadManager.getState();
                if (n == 100 || n == 70) {
                    return null;
                }
                try {
                    object = DownloadManagerImpl.getDownloadStatic(downloadManager);
                    final boolean bl = downloadManager.isDownloadComplete(true);
                    return new AZInstanceTracked.TrackTarget(){

                        @Override
                        public Object getTarget() {
                            return object;
                        }

                        @Override
                        public boolean isSeed() {
                            return bl;
                        }
                    };
                }
                catch (Throwable throwable) {
                    return null;
                }
            }

            @Override
            public DHTPlugin getDHTPlugin() {
                PluginInterface pluginInterface = AzureusCoreImpl.this.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
                if (pluginInterface != null) {
                    return (DHTPlugin)pluginInterface.getPlugin();
                }
                return null;
            }

            @Override
            public UPnPPlugin getUPnPPlugin() {
                PluginInterface pluginInterface = AzureusCoreImpl.this.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
                if (pluginInterface != null) {
                    return (UPnPPlugin)pluginInterface.getPlugin();
                }
                return null;
            }

            @Override
            public void addListener(final AZInstanceManagerAdapter.StateListener stateListener) {
                AzureusCoreImpl.this.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

                    @Override
                    public void started(AzureusCore azureusCore) {
                        stateListener.started();
                    }

                    @Override
                    public void stopping(AzureusCore azureusCore) {
                        stateListener.stopped();
                    }
                });
            }
        });
        this.speed_manager = SpeedManagerFactory.createSpeedManager(this, new SpeedManagerAdapter(){
            private final int UPLOAD_SPEED_ADJUST_MIN_KB_SEC = 10;
            private final int DOWNLOAD_SPEED_ADJUST_MIN_KB_SEC = 300;
            private boolean setting_limits;

            @Override
            public int getCurrentProtocolUploadSpeed(int n) {
                if (AzureusCoreImpl.this.global_manager != null) {
                    GlobalManagerStats globalManagerStats = AzureusCoreImpl.this.global_manager.getStats();
                    return globalManagerStats.getProtocolSendRateNoLAN(n);
                }
                return 0;
            }

            @Override
            public int getCurrentDataUploadSpeed(int n) {
                if (AzureusCoreImpl.this.global_manager != null) {
                    GlobalManagerStats globalManagerStats = AzureusCoreImpl.this.global_manager.getStats();
                    return globalManagerStats.getDataSendRateNoLAN(n);
                }
                return 0;
            }

            @Override
            public int getCurrentProtocolDownloadSpeed(int n) {
                if (AzureusCoreImpl.this.global_manager != null) {
                    GlobalManagerStats globalManagerStats = AzureusCoreImpl.this.global_manager.getStats();
                    return globalManagerStats.getProtocolReceiveRateNoLAN(n);
                }
                return 0;
            }

            @Override
            public int getCurrentDataDownloadSpeed(int n) {
                if (AzureusCoreImpl.this.global_manager != null) {
                    GlobalManagerStats globalManagerStats = AzureusCoreImpl.this.global_manager.getStats();
                    return globalManagerStats.getDataReceiveRateNoLAN(n);
                }
                return 0;
            }

            @Override
            public int getCurrentUploadLimit() {
                String string = TransferSpeedValidator.getActiveUploadParameter(AzureusCoreImpl.this.global_manager);
                int n = COConfigurationManager.getIntParameter(string);
                int n2 = n == 0 ? Integer.MAX_VALUE : n * 1024;
                return n2;
            }

            @Override
            public void setCurrentUploadLimit(int n) {
                if (n != this.getCurrentUploadLimit()) {
                    String string = TransferSpeedValidator.getActiveUploadParameter(AzureusCoreImpl.this.global_manager);
                    int n2 = n == Integer.MAX_VALUE ? 0 : (n + 1023) / 1024;
                    if (n2 > 0) {
                        n2 = Math.max(n2, 10);
                    }
                    COConfigurationManager.setParameter(string, n2);
                }
            }

            @Override
            public int getCurrentDownloadLimit() {
                return TransferSpeedValidator.getGlobalDownloadRateLimitBytesPerSecond();
            }

            @Override
            public void setCurrentDownloadLimit(int n) {
                if (n == Integer.MAX_VALUE) {
                    n = 0;
                }
                if (n > 0) {
                    n = Math.max(n, 307200);
                }
                TransferSpeedValidator.setGlobalDownloadRateLimitBytesPerSecond(n);
            }

            @Override
            public Object getLimits() {
                String string = TransferSpeedValidator.getActiveUploadParameter(AzureusCoreImpl.this.global_manager);
                String string2 = TransferSpeedValidator.getDownloadParameter();
                return new Object[]{string, new Integer(COConfigurationManager.getIntParameter(string)), string2, new Integer(COConfigurationManager.getIntParameter(string2))};
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLimits(Object object, boolean bl, boolean bl2) {
                if (object == null) {
                    return;
                }
                try {
                    if (this.setting_limits) {
                        return;
                    }
                    this.setting_limits = true;
                    Object[] objectArray = (Object[])object;
                    if (bl) {
                        COConfigurationManager.setParameter((String)objectArray[0], (Integer)objectArray[1]);
                    }
                    if (bl2) {
                        COConfigurationManager.setParameter((String)objectArray[2], (Integer)objectArray[3]);
                    }
                }
                finally {
                    this.setting_limits = false;
                }
            }
        });
        this.nat_traverser = new NATTraverser(this);
        PeerNATTraverser.initialise(this);
        SimpleTimer.addEvent("AzureusCore:gc", SystemTime.getOffsetTime(60000L), new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent timerEvent2) {
                System.gc();
            }
        });
    }

    protected void announceAll(boolean bl) {
        Object object;
        Logger.log(new LogEvent(LOGID, "Updating trackers"));
        GlobalManager globalManager = this.getGlobalManager();
        if (globalManager != null) {
            object = globalManager.getDownloadManagers();
            long l = SystemTime.getCurrentTime();
            for (int i = 0; i < object.size(); ++i) {
                DownloadManager downloadManager = (DownloadManager)object.get(i);
                Long l2 = (Long)downloadManager.getUserData(DM_ANNOUNCE_KEY);
                long l3 = l2 == null ? this.create_time : l2;
                TRTrackerAnnouncer tRTrackerAnnouncer = downloadManager.getTrackerClient();
                if (tRTrackerAnnouncer == null) continue;
                TRTrackerAnnouncerResponse tRTrackerAnnouncerResponse = tRTrackerAnnouncer.getLastResponse();
                if (l - l3 <= 900000L && tRTrackerAnnouncerResponse != null && tRTrackerAnnouncerResponse.getStatus() != 0 && !bl) continue;
                downloadManager.setUserData(DM_ANNOUNCE_KEY, new Long(l));
                Logger.log(new LogEvent(LOGID, "    updating tracker for " + downloadManager.getDisplayName()));
                downloadManager.requestTrackerAnnounce(true);
            }
        }
        if ((object = this.getPluginManager().getPluginInterfaceByClass(DHTTrackerPlugin.class)) != null) {
            ((DHTTrackerPlugin)object.getPlugin()).announceAll();
        }
    }

    @Override
    public LocaleUtil getLocaleUtil() {
        return LocaleUtil.getSingleton();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws AzureusCoreException {
        Object[] objectArray;
        Object object;
        String string;
        AEThread2.setOurThread();
        try {
            this.this_mon.enter();
            if (this.started) {
                throw new AzureusCoreException("Core: already started");
            }
            if (this.stopped) {
                throw new AzureusCoreException("Core: already stopped");
            }
            this.started = true;
        }
        finally {
            this.this_mon.exit();
        }
        if ("1".equals(System.getProperty("azureus.safemode"))) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Safe mode enabled"));
            }
            Constants.isSafeMode = true;
            System.setProperty("azureus.loadplugins", "0");
            System.setProperty("azureus.disabledownloads", "1");
            System.setProperty("azureus.skipSWTcheck", "1");
            Logger.log(new LogAlert(false, 1, "You are running " + Constants.APP_NAME + " in safe mode - you " + "can change your configuration, but any downloads added will " + "not be remembered when you close " + Constants.APP_NAME + "."));
        }
        if ((string = System.getProperty("delay.core", null)) != null) {
            try {
                long l = Long.parseLong(string);
                Thread.sleep(l);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        AEThread2 aEThread2 = new AEThread2("PluginLoader", true){

            @Override
            public void run() {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Loading of Plugins starts"));
                }
                AzureusCoreImpl.this.pi.loadPlugins(AzureusCoreImpl.this, false, !"0".equals(System.getProperty("azureus.loadplugins")), true, true);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Loading of Plugins complete"));
                }
            }
        };
        aEThread2.start();
        this.global_manager = GlobalManagerFactory.create(this, new GlobalMangerProgressListener(){

            @Override
            public void reportCurrentTask(String string) {
                AzureusCoreImpl.this.initialisation_op.reportCurrentTask(string);
            }

            @Override
            public void reportPercent(int n) {
                AzureusCoreImpl.this.initialisation_op.reportPercent(n);
            }
        }, 0L);
        if (this.stopped) {
            System.err.println("Core stopped while starting");
            return;
        }
        aEThread2.join();
        if (this.stopped) {
            System.err.println("Core stopped while starting");
            return;
        }
        this.triggerLifeCycleComponentCreated(this.global_manager);
        this.pi.initialisePlugins();
        if (this.stopped) {
            System.err.println("Core stopped while starting");
            return;
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Initializing Plugins complete"));
        }
        try {
            object = this.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
            if (object != null) {
                object.addEventListener(new PluginEventListener(){
                    private boolean first_dht = true;

                    @Override
                    public void handleEvent(PluginEvent pluginEvent) {
                        if (pluginEvent.getType() == 1024 && this.first_dht) {
                            this.first_dht = false;
                            DHT dHT = (DHT)pluginEvent.getValue();
                            AzureusCoreImpl.this.speed_manager.setSpeedTester(dHT.getSpeedTester());
                            AzureusCoreImpl.this.global_manager.addListener(new GlobalManagerAdapter(){

                                @Override
                                public void seedingStatusChanged(boolean bl, boolean bl2) {
                                    this.checkConfig();
                                }
                            });
                            COConfigurationManager.addAndFireParameterListeners(new String[]{"Auto Upload Speed Enabled", "Auto Upload Speed Seeding Enabled"}, new ParameterListener(){

                                @Override
                                public void parameterChanged(String string) {
                                    this.checkConfig();
                                }
                            });
                        }
                    }

                    protected void checkConfig() {
                        AzureusCoreImpl.this.speed_manager.setEnabled(TransferSpeedValidator.isAutoSpeedActive(AzureusCoreImpl.this.global_manager));
                    }
                });
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (COConfigurationManager.getBooleanParameter("Resume Downloads On Start")) {
            this.global_manager.resumeDownloads();
        }
        VersionCheckClient.getSingleton().initialise();
        this.instance_manager.initialize();
        NetworkManager.getSingleton().initialize(this);
        Runtime.getRuntime().addShutdownHook(new AEThread("Shutdown Hook"){

            @Override
            public void runSupport() {
                Logger.log(new LogEvent(LOGID, "Shutdown hook triggered"));
                AzureusCoreImpl.this.stop();
            }
        });
        object = UtilitiesImpl.addDelayedTask("Core", new Runnable(){

            @Override
            public void run() {
                new AEThread2("core:delayTask", true){

                    @Override
                    public void run() {
                        AEDiagnostics.checkDumpsAndNatives();
                        COConfigurationManager.setParameter("diags.enable.pending.writes", true);
                        AEDiagnostics.flushPendingLogs();
                        NetworkAdmin networkAdmin = NetworkAdmin.getSingleton();
                        networkAdmin.runInitialChecks(AzureusCoreImpl.this);
                        networkAdmin.addPropertyChangeListener(new NetworkAdminPropertyChangeListener(){
                            private String last_as;

                            @Override
                            public void propertyChanged(String string) {
                                NetworkAdmin networkAdmin = NetworkAdmin.getSingleton();
                                if (string.equals("Network Interfaces")) {
                                    boolean bl = false;
                                    NetworkAdminNetworkInterface[] networkAdminNetworkInterfaceArray = networkAdmin.getInterfaces();
                                    for (int i = 0; i < networkAdminNetworkInterfaceArray.length; ++i) {
                                        NetworkAdminNetworkInterfaceAddress[] networkAdminNetworkInterfaceAddressArray = networkAdminNetworkInterfaceArray[i].getAddresses();
                                        for (int j = 0; j < networkAdminNetworkInterfaceAddressArray.length; ++j) {
                                            if (networkAdminNetworkInterfaceAddressArray[j].isLoopback()) continue;
                                            bl = true;
                                        }
                                    }
                                    if (!bl) {
                                        return;
                                    }
                                    Logger.log(new LogEvent(LOGID, "Network interfaces have changed (new=" + networkAdmin.getNetworkInterfacesAsString() + ")"));
                                    AzureusCoreImpl.this.announceAll(false);
                                } else if (string.equals("AS")) {
                                    String string2 = networkAdmin.getCurrentASN().getAS();
                                    if (this.last_as == null) {
                                        this.last_as = string2;
                                    } else if (!string2.equals(this.last_as)) {
                                        Logger.log(new LogEvent(LOGID, "AS has changed (new=" + string2 + ")"));
                                        this.last_as = string2;
                                        AzureusCoreImpl.this.announceAll(false);
                                    }
                                }
                            }
                        });
                        AzureusCoreImpl.this.setupCloseActions();
                    }
                }.start();
            }
        });
        object.queue();
        if (this.stopped) {
            System.err.println("Core stopped while starting");
            return;
        }
        PairingManagerFactory.getSingleton();
        mon_coreRunningListeners.enter();
        try {
            if (coreRunningListeners == null) {
                objectArray = new Object[]{};
            } else {
                objectArray = coreRunningListeners.toArray();
                coreRunningListeners = null;
            }
        }
        finally {
            mon_coreRunningListeners.exit();
        }
        new AEThread2("Plugin Init Complete", false){

            @Override
            public void run() {
                AzureusCoreLifecycleListener azureusCoreLifecycleListener;
                try {
                    PlatformManagerFactory.getPlatformManager().startup(AzureusCoreImpl.this);
                }
                catch (Throwable throwable) {
                    Debug.out("PlatformManager: init failed", throwable);
                }
                Iterator iterator = AzureusCoreImpl.this.lifecycle_listeners.iterator();
                while (iterator.hasNext()) {
                    try {
                        azureusCoreLifecycleListener = (AzureusCoreLifecycleListener)iterator.next();
                        if (azureusCoreLifecycleListener.requiresPluginInitCompleteBeforeStartedEvent()) continue;
                        azureusCoreLifecycleListener.started(AzureusCoreImpl.this);
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
                AzureusCoreImpl.this.pi.initialisationComplete();
                iterator = AzureusCoreImpl.this.lifecycle_listeners.iterator();
                while (iterator.hasNext()) {
                    try {
                        azureusCoreLifecycleListener = (AzureusCoreLifecycleListener)iterator.next();
                        if (!azureusCoreLifecycleListener.requiresPluginInitCompleteBeforeStartedEvent()) continue;
                        azureusCoreLifecycleListener.started(AzureusCoreImpl.this);
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
            }
        }.start();
        for (Object object2 : objectArray) {
            try {
                ((AzureusCoreRunningListener)object2).azureusCoreRunning(this);
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
        }
    }

    @Override
    public boolean isInitThread() {
        return AEThread2.isOurThread(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStarted() {
        mon_coreRunningListeners.enter();
        try {
            boolean bl = this.started && coreRunningListeners == null;
            return bl;
        }
        finally {
            mon_coreRunningListeners.exit();
        }
    }

    @Override
    public void triggerLifeCycleComponentCreated(AzureusCoreComponent azureusCoreComponent) {
        Iterator iterator = this.lifecycle_listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((AzureusCoreLifecycleListener)iterator.next()).componentCreated(this, azureusCoreComponent);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    private void runNonDaemon(final Runnable runnable) throws AzureusCoreException {
        if (!Thread.currentThread().isDaemon()) {
            runnable.run();
        } else {
            final AESemaphore aESemaphore = new AESemaphore("AzureusCore:runNonDaemon");
            final Throwable[] throwableArray = new Throwable[]{null};
            new AEThread2("AzureusCore:runNonDaemon", false){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        throwableArray[0] = throwable;
                    }
                    finally {
                        aESemaphore.release();
                    }
                }
            }.start();
            aESemaphore.reserve();
            if (throwableArray[0] != null) {
                if (throwableArray[0] instanceof AzureusCoreException) {
                    throw (AzureusCoreException)throwableArray[0];
                }
                throw new AzureusCoreException("Operation failed", throwableArray[0]);
            }
        }
    }

    @Override
    public void stop() throws AzureusCoreException {
        this.runNonDaemon(new AERunnable(){

            @Override
            public void runSupport() {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Stop operation starts"));
                }
                AzureusCoreImpl.this.stopSupport(true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSupport(boolean bl) throws AzureusCoreException {
        AEDiagnostics.flushPendingLogs();
        boolean bl2 = false;
        try {
            this.this_mon.enter();
            if (this.stopped) {
                COConfigurationManager.save();
                bl2 = true;
            } else {
                this.stopped = true;
                if (!this.started) {
                    Logger.log(new LogEvent(LOGID, "Core not started"));
                    if (AEDiagnostics.isDirty()) {
                        AEDiagnostics.markClean();
                    }
                    this.stopping_sem.releaseForever();
                    return;
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
        if (bl2) {
            Logger.log(new LogEvent(LOGID, "Waiting for stop to complete"));
            this.stopping_sem.reserve();
            return;
        }
        SimpleTimer.addEvent("ShutFail", SystemTime.getOffsetTime(30000L), new TimerEventPerformer(){
            boolean die_die_die;

            @Override
            public void perform(TimerEvent timerEvent2) {
                AEDiagnostics.dumpThreads();
                if (this.die_die_die) {
                    Debug.out("Shutdown blocked, force exiting");
                    SESecurityManager.exitVM(0);
                }
                this.die_die_die = true;
                SimpleTimer.addEvent("ShutFail", SystemTime.getOffsetTime(30000L), this);
            }
        });
        ArrayList<AzureusCoreLifecycleListener> arrayList = new ArrayList<AzureusCoreLifecycleListener>();
        ArrayList<AzureusCoreLifecycleListener> arrayList2 = new ArrayList<AzureusCoreLifecycleListener>();
        for (AzureusCoreLifecycleListener azureusCoreLifecycleListener : this.lifecycle_listeners) {
            if (azureusCoreLifecycleListener.syncInvokeRequired()) {
                arrayList.add(azureusCoreLifecycleListener);
                continue;
            }
            arrayList2.add(azureusCoreLifecycleListener);
        }
        try {
            Object object;
            int n;
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Invoking synchronous 'stopping' listeners"));
            }
            for (n = 0; n < arrayList.size(); ++n) {
                try {
                    ((AzureusCoreLifecycleListener)arrayList.get(n)).stopping(this);
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Invoking asynchronous 'stopping' listeners"));
            }
            ListenerManager.dispatchWithTimeout(arrayList2, new ListenerManagerDispatcher(){

                public void dispatch(Object object, int n, Object object2) {
                    ((AzureusCoreLifecycleListener)object).stopping(AzureusCoreImpl.this);
                }
            }, 10000L);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Stopping global manager"));
            }
            if (this.global_manager != null) {
                this.global_manager.stopGlobalManager();
            }
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Invoking synchronous 'stopped' listeners"));
            }
            for (n = 0; n < arrayList.size(); ++n) {
                try {
                    ((AzureusCoreLifecycleListener)arrayList.get(n)).stopped(this);
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Invoking asynchronous 'stopped' listeners"));
            }
            ListenerManager.dispatchWithTimeout(arrayList2, new ListenerManagerDispatcher(){

                public void dispatch(Object object, int n, Object object2) {
                    ((AzureusCoreLifecycleListener)object).stopped(AzureusCoreImpl.this);
                }
            }, 10000L);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Waiting for quiescence"));
            }
            NonDaemonTaskRunner.waitUntilIdle();
            AEDiagnostics.markClean();
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Stop operation completes"));
            }
            try {
                object = Class.forName("sun.awt.AWTAutoShutdown");
                if (object != null) {
                    ((Class)object).getMethod("notifyToolkitThreadFree", new Class[0]).invoke(null, new Object[0]);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.ca_shutdown_computer_after_stop) {
                if (bl) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                try {
                    PlatformManagerFactory.getPlatformManager().shutdown(1);
                }
                catch (Throwable throwable) {
                    Debug.out("PlatformManager: shutdown failed", throwable);
                }
            }
            try {
                object = Thread.currentThread().getThreadGroup();
                while (((ThreadGroup)object).getParent() != null) {
                    object = ((ThreadGroup)object).getParent();
                }
                Thread[] threadArray = new Thread[((ThreadGroup)object).activeCount() + 1024];
                ((ThreadGroup)object).enumerate(threadArray, true);
                boolean bl3 = false;
                for (int i = 0; i < threadArray.length; ++i) {
                    Thread thread = threadArray[i];
                    if (thread == null || !thread.isAlive() || thread == Thread.currentThread() || thread.isDaemon() || AEThread2.isOurThread(thread)) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) {
                    new AEThread2("VMKiller", true){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(10000L);
                                ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                                Thread[] threadArray = new Thread[threadGroup.activeCount() + 1024];
                                threadGroup.enumerate(threadArray, true);
                                String string = "";
                                for (int i = 0; i < threadArray.length; ++i) {
                                    Thread thread = threadArray[i];
                                    if (thread == null || !thread.isAlive() || thread.isDaemon() || AEThread2.isOurThread(thread)) continue;
                                    String string2 = thread.getName();
                                    StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
                                    if (stackTraceElementArray.length > 0) {
                                        string2 = string2 + "[";
                                        for (int j = 0; j < stackTraceElementArray.length; ++j) {
                                            string2 = string2 + (j == 0 ? "" : ",") + stackTraceElementArray[j];
                                        }
                                        string2 = string2 + "]";
                                    }
                                    string = string + (string.length() == 0 ? "" : ", ") + string2;
                                }
                                Debug.out("Non-daemon thread(s) found: '" + string + "' - force closing VM");
                                SESecurityManager.exitVM(0);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }.start();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        finally {
            this.stopping_sem.releaseForever();
        }
    }

    @Override
    public void requestStop() throws AzureusCoreException {
        if (this.stopped) {
            return;
        }
        this.runNonDaemon(new AERunnable(){

            @Override
            public void runSupport() {
                Iterator iterator = AzureusCoreImpl.this.lifecycle_listeners.iterator();
                while (iterator.hasNext()) {
                    if (((AzureusCoreLifecycleListener)iterator.next()).stopRequested(AzureusCoreImpl.this)) continue;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 1, "Request to stop the core has been denied"));
                    }
                    return;
                }
                AzureusCoreImpl.this.stop();
            }
        });
    }

    @Override
    public void restart() throws AzureusCoreException {
        this.runNonDaemon(new AERunnable(){

            @Override
            public void runSupport() {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Restart operation starts"));
                }
                AzureusCoreImpl.this.checkRestartSupported();
                AzureusCoreImpl.this.restarting = true;
                AzureusCoreImpl.this.stopSupport(false);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Restart operation: stop complete,restart initiated"));
                }
                AzureusRestarterFactory.create(AzureusCoreImpl.this).restart(false);
            }
        });
    }

    @Override
    public void requestRestart() throws AzureusCoreException {
        this.runNonDaemon(new AERunnable(){

            @Override
            public void runSupport() {
                AzureusCoreImpl.this.checkRestartSupported();
                for (AzureusCoreLifecycleListener azureusCoreLifecycleListener : AzureusCoreImpl.this.lifecycle_listeners) {
                    if (azureusCoreLifecycleListener.restartRequested(AzureusCoreImpl.this)) continue;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 1, "Request to restart the core has been denied"));
                    }
                    return;
                }
                AzureusCoreImpl.this.restart();
            }
        });
    }

    @Override
    public boolean isRestarting() {
        return this.restarting;
    }

    @Override
    public void checkRestartSupported() throws AzureusCoreException {
        if (this.getPluginManager().getPluginInterfaceByClass("org.gudy.azureus2.update.UpdaterPatcher") == null) {
            Logger.log(new LogAlert(true, 3, "Can't restart without the 'azupdater' plugin installed"));
            throw new AzureusCoreException("Can't restart without the 'azupdater' plugin installed");
        }
    }

    @Override
    public GlobalManager getGlobalManager() throws AzureusCoreException {
        if (this.global_manager == null) {
            throw new AzureusCoreException("Core not running");
        }
        return this.global_manager;
    }

    @Override
    public TRHost getTrackerHost() throws AzureusCoreException {
        return TRHostFactory.getSingleton();
    }

    @Override
    public PluginManagerDefaults getPluginManagerDefaults() throws AzureusCoreException {
        return PluginManager.getDefaults();
    }

    @Override
    public PluginManager getPluginManager() throws AzureusCoreException {
        return PluginInitializer.getDefaultInterface().getPluginManager();
    }

    @Override
    public IpFilterManager getIpFilterManager() throws AzureusCoreException {
        return IpFilterManagerFactory.getSingleton();
    }

    @Override
    public AZInstanceManager getInstanceManager() {
        return this.instance_manager;
    }

    @Override
    public SpeedManager getSpeedManager() {
        return this.speed_manager;
    }

    @Override
    public CryptoManager getCryptoManager() {
        return this.crypto_manager;
    }

    @Override
    public NATTraverser getNATTraverser() {
        return this.nat_traverser;
    }

    private void setupCloseActions() {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"On Downloading Complete Do", "On Seeding Complete Do"}, new ParameterListener(){
            private TimerEventPeriodic timer_event;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void parameterChanged(String string) {
                String string2 = COConfigurationManager.getStringParameter("On Downloading Complete Do");
                String string3 = COConfigurationManager.getStringParameter("On Seeding Complete Do");
                20 var4_4 = this;
                synchronized (var4_4) {
                    boolean bl = string2.equals("Nothing");
                    boolean bl2 = string3.equals("Nothing");
                    if (bl) {
                        AzureusCoreImpl.this.ca_last_time_downloading = -1L;
                    }
                    if (bl2) {
                        AzureusCoreImpl.this.ca_last_time_seeding = -1L;
                    }
                    if (bl && bl2) {
                        if (this.timer_event != null) {
                            this.timer_event.cancel();
                            this.timer_event = null;
                        }
                    } else {
                        if (this.timer_event == null) {
                            this.timer_event = SimpleTimer.addPeriodicEvent("core:closeAct", 30000L, new TimerEventPerformer(){

                                @Override
                                public void perform(TimerEvent timerEvent2) {
                                    AzureusCoreImpl.this.checkCloseActions();
                                }
                            });
                        }
                        AzureusCoreImpl.this.checkCloseActions();
                    }
                }
            }
        });
    }

    protected void checkCloseActions() {
        Object object;
        List list = this.getGlobalManager().getDownloadManagers();
        boolean bl = false;
        boolean bl2 = false;
        for (DownloadManager downloadManager : list) {
            int n = downloadManager.getState();
            if (n == 55) {
                bl = true;
                continue;
            }
            if (n == 50 && (object = downloadManager.getPeerManager()) != null) {
                if (object.hasDownloadablePiece()) {
                    bl = true;
                } else {
                    n = 60;
                }
            }
            if (n != 60) continue;
            object = downloadManager.getDiskManager();
            if (object != null && object.getCompleteRecheckStatus() != -1) {
                bl = true;
                continue;
            }
            bl2 = true;
        }
        long l = SystemTime.getMonotonousTime();
        if (bl) {
            this.ca_last_time_downloading = l;
            this.ca_last_time_seeding = -1L;
        } else if (bl2) {
            this.ca_last_time_seeding = l;
        }
        String string = COConfigurationManager.getStringParameter("On Downloading Complete Do");
        if (!string.equals("Nothing") && this.ca_last_time_downloading >= 0L && !bl && l - this.ca_last_time_downloading >= 30000L) {
            this.executeCloseAction(true, string);
        }
        if (!((String)(object = COConfigurationManager.getStringParameter("On Seeding Complete Do"))).equals("Nothing") && this.ca_last_time_seeding >= 0L && !bl2 && l - this.ca_last_time_seeding >= 30000L) {
            this.executeCloseAction(false, (String)object);
        }
    }

    private void executeCloseAction(final boolean bl, final String string) {
        this.ca_last_time_downloading = -1L;
        this.ca_last_time_seeding = -1L;
        boolean bl2 = COConfigurationManager.getBooleanParameter("Stop Triggers Auto Reset");
        if (bl2) {
            if (bl) {
                COConfigurationManager.setParameter("On Downloading Complete Do", "Nothing");
            } else {
                COConfigurationManager.setParameter("On Seeding Complete Do", "Nothing");
            }
        }
        String string2 = MessageText.getString("core.shutdown." + (bl ? "dl" : "se"));
        String string3 = MessageText.getString("ConfigView.label.stop." + string);
        String string4 = MessageText.getString("core.shutdown.alert", new String[]{string3, string2});
        UIFunctions uIFunctions = UIFunctionsManager.getUIFunctions();
        if (uIFunctions != null) {
            uIFunctions.forceNotify(0, null, string4, null, new Object[0], -1);
        }
        Logger.log(new LogAlert(false, 0, string4));
        new DelayedEvent("CoreShutdown", 10000L, new AERunnable(){

            @Override
            public void runSupport() {
                Logger.log(new LogEvent(LOGID, "Executing close action '" + string + "' due to " + (bl ? "downloading" : "seeding") + " completion"));
                if (string.equals("QuitVuze")) {
                    AzureusCoreImpl.this.requestStop();
                } else if (string.equals("Sleep") || string.equals("Hibernate")) {
                    AzureusCoreImpl.this.announceAll(true);
                    try {
                        PlatformManagerFactory.getPlatformManager().shutdown(string.equals("Sleep") ? 4 : 2);
                    }
                    catch (Throwable throwable) {
                        Debug.out("PlatformManager: shutdown failed", throwable);
                    }
                } else if (string.equals("Shutdown")) {
                    AzureusCoreImpl.this.ca_shutdown_computer_after_stop = true;
                    AzureusCoreImpl.this.requestStop();
                } else {
                    Debug.out("Unknown close action '" + string + "'");
                }
            }
        });
    }

    @Override
    public AzureusCoreOperation createOperation(final int n) {
        AzureusCoreOperation azureusCoreOperation = new AzureusCoreOperation(){

            @Override
            public int getOperationType() {
                return n;
            }

            @Override
            public AzureusCoreOperationTask getTask() {
                return null;
            }

            @Override
            public void reportCurrentTask(String string) {
                AzureusCoreImpl.this.reportCurrentTask(this, string);
            }

            @Override
            public void reportPercent(int n2) {
                AzureusCoreImpl.this.reportPercent(this, n2);
            }
        };
        for (int i = 0; i < this.operation_listeners.size(); ++i) {
            try {
                ((AzureusCoreOperationListener)this.operation_listeners.get(i)).operationCreated(azureusCoreOperation);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        return azureusCoreOperation;
    }

    @Override
    public void createOperation(final int n, AzureusCoreOperationTask azureusCoreOperationTask) {
        final AzureusCoreOperationTask[] azureusCoreOperationTaskArray = new AzureusCoreOperationTask[]{azureusCoreOperationTask};
        AzureusCoreOperation azureusCoreOperation = new AzureusCoreOperation(){

            @Override
            public int getOperationType() {
                return n;
            }

            @Override
            public AzureusCoreOperationTask getTask() {
                return azureusCoreOperationTaskArray[0];
            }

            @Override
            public void reportCurrentTask(String string) {
                AzureusCoreImpl.this.reportCurrentTask(this, string);
            }

            @Override
            public void reportPercent(int n2) {
                AzureusCoreImpl.this.reportPercent(this, n2);
            }
        };
        for (int i = 0; i < this.operation_listeners.size(); ++i) {
            if (!((AzureusCoreOperationListener)this.operation_listeners.get(i)).operationCreated(azureusCoreOperation)) continue;
            azureusCoreOperationTaskArray[0] = null;
        }
        if (azureusCoreOperationTaskArray[0] != null) {
            azureusCoreOperationTask.run(azureusCoreOperation);
        }
    }

    protected void reportCurrentTask(AzureusCoreOperation azureusCoreOperation, String string) {
        if (azureusCoreOperation.getOperationType() == 1) {
            PluginInitializer.fireEvent(3, string);
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((AzureusCoreListener)iterator.next()).reportCurrentTask(azureusCoreOperation, string);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected void reportPercent(AzureusCoreOperation azureusCoreOperation, int n) {
        if (azureusCoreOperation.getOperationType() == 1) {
            PluginInitializer.fireEvent(4, new Integer(n));
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((AzureusCoreListener)iterator.next()).reportPercent(azureusCoreOperation, n);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    @Override
    public void addLifecycleListener(AzureusCoreLifecycleListener azureusCoreLifecycleListener) {
        this.lifecycle_listeners.add(azureusCoreLifecycleListener);
    }

    @Override
    public void removeLifecycleListener(AzureusCoreLifecycleListener azureusCoreLifecycleListener) {
        this.lifecycle_listeners.remove(azureusCoreLifecycleListener);
    }

    @Override
    public void addListener(AzureusCoreListener azureusCoreListener) {
        this.listeners.add(azureusCoreListener);
    }

    @Override
    public void removeListener(AzureusCoreListener azureusCoreListener) {
        this.listeners.remove(azureusCoreListener);
    }

    @Override
    public void addOperationListener(AzureusCoreOperationListener azureusCoreOperationListener) {
        this.operation_listeners.add(azureusCoreOperationListener);
    }

    @Override
    public void removeOperationListener(AzureusCoreOperationListener azureusCoreOperationListener) {
        this.operation_listeners.remove(azureusCoreOperationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCoreRunningListener(AzureusCoreRunningListener azureusCoreRunningListener) {
        mon_coreRunningListeners.enter();
        try {
            if (coreRunningListeners != null) {
                coreRunningListeners.add(azureusCoreRunningListener);
                return;
            }
        }
        finally {
            mon_coreRunningListeners.exit();
        }
        azureusCoreRunningListener.azureusCoreRunning(AzureusCoreImpl.getSingleton());
    }

    static {
        class_mon = new AEMonitor("AzureusCore:class");
        coreRunningListeners = new ArrayList<AzureusCoreRunningListener>(1);
        mon_coreRunningListeners = new AEMonitor("CoreCreationListeners");
        SUPPRESS_CLASSLOADER_ERRORS = false;
    }
}

