/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.lws;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.lws.LightWeightSeed;
import com.aelitis.azureus.core.lws.LightWeightSeedAdapter;
import com.aelitis.azureus.plugins.tracker.dht.DHTTrackerPlugin;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseImpl;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseTTTorrent;

public class LightWeightSeedManager {
    private static LightWeightSeedManager singleton = new LightWeightSeedManager();
    private Map lws_map = new HashMap();
    private boolean started;
    private Set dht_add_queue = new HashSet();
    private boolean borked;
    private DHTTrackerPlugin dht_tracker_plugin;
    private DDBaseTTTorrent tttorrent;
    private TimerEventPeriodic timer;
    private AESemaphore init_sem = new AESemaphore("LWSM");

    public static LightWeightSeedManager getSingleton() {
        return singleton;
    }

    protected LightWeightSeedManager() {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore azureusCore) {
                LightWeightSeedManager.this.startUp();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startUp() {
        block12: {
            LightWeightSeedManager lightWeightSeedManager = this;
            synchronized (lightWeightSeedManager) {
                if (this.started) {
                    return;
                }
                this.started = true;
            }
            boolean bl = true;
            try {
                PluginInterface pluginInterface = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(DHTTrackerPlugin.class);
                if (pluginInterface != null) {
                    final DHTTrackerPlugin dHTTrackerPlugin = (DHTTrackerPlugin)pluginInterface.getPlugin();
                    new AEThread2("LWS:waitForPlug", true){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                HashSet hashSet;
                                dHTTrackerPlugin.waitUntilInitialised();
                                if (dHTTrackerPlugin.isRunning()) {
                                    LightWeightSeedManager.this.tttorrent = DDBaseImpl.getSingleton(AzureusCoreFactory.getSingleton()).getTTTorrent();
                                }
                                Object object = this;
                                synchronized (object) {
                                    LightWeightSeedManager.this.dht_tracker_plugin = dHTTrackerPlugin;
                                    hashSet = new HashSet(LightWeightSeedManager.this.dht_add_queue);
                                    LightWeightSeedManager.this.dht_add_queue.clear();
                                }
                                object = hashSet.iterator();
                                while (object.hasNext()) {
                                    LightWeightSeedManager.this.addDownload((Download)object.next());
                                }
                            }
                            finally {
                                LightWeightSeedManager.this.init_sem.releaseForever();
                            }
                        }
                    }.start();
                    bl = false;
                    break block12;
                }
                LightWeightSeedManager lightWeightSeedManager2 = this;
                synchronized (lightWeightSeedManager2) {
                    this.borked = true;
                    this.dht_add_queue.clear();
                }
            }
            finally {
                if (bl) {
                    this.init_sem.releaseForever();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LightWeightSeed add(String string, HashWrapper hashWrapper, URL uRL, File file, LightWeightSeedAdapter lightWeightSeedAdapter) throws Exception {
        LightWeightSeed lightWeightSeed;
        if (!TorrentUtils.isDecentralised(uRL)) {
            throw new Exception("Only decentralised torrents supported");
        }
        LightWeightSeedManager lightWeightSeedManager = this;
        synchronized (lightWeightSeedManager) {
            if (this.lws_map.containsKey(hashWrapper)) {
                throw new Exception("Seed for hash '" + ByteFormatter.encodeString(hashWrapper.getBytes()) + "' already added");
            }
            lightWeightSeed = new LightWeightSeed(this, string, hashWrapper, uRL, file, lightWeightSeedAdapter);
            this.lws_map.put(hashWrapper, lightWeightSeed);
            if (this.timer == null) {
                this.timer = SimpleTimer.addPeriodicEvent("LWSManager:timer", 60000L, new TimerEventPerformer(){

                    @Override
                    public void perform(TimerEvent timerEvent2) {
                        LightWeightSeedManager.this.processTimer();
                    }
                });
            }
            this.log("Added LWS: " + string + ", " + UrlUtils.getMagnetURI(hashWrapper.getBytes()));
        }
        lightWeightSeed.start();
        return lightWeightSeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LightWeightSeed get(HashWrapper hashWrapper) {
        LightWeightSeedManager lightWeightSeedManager = this;
        synchronized (lightWeightSeedManager) {
            return (LightWeightSeed)this.lws_map.get(hashWrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTimer() {
        ArrayList arrayList;
        LightWeightSeedManager lightWeightSeedManager = this;
        synchronized (lightWeightSeedManager) {
            arrayList = new ArrayList(this.lws_map.values());
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                ((LightWeightSeed)arrayList.get(i)).checkDeactivation();
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(LightWeightSeed lightWeightSeed) {
        lightWeightSeed.stop();
        LightWeightSeedManager lightWeightSeedManager = this;
        synchronized (lightWeightSeedManager) {
            this.lws_map.remove(lightWeightSeed.getHash());
            if (this.lws_map.size() == 0 && this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }
        this.log("Added LWS: " + lightWeightSeed.getName() + ", " + UrlUtils.getMagnetURI(lightWeightSeed.getHash().getBytes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToDHTTracker(Download download) {
        Set set = this.dht_add_queue;
        synchronized (set) {
            if (this.borked) {
                return;
            }
            if (this.dht_tracker_plugin == null) {
                this.dht_add_queue.add(download);
                return;
            }
        }
        this.init_sem.reserve();
        this.addDownload(download);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromDHTTracker(Download download) {
        Set set = this.dht_add_queue;
        synchronized (set) {
            if (this.borked) {
                return;
            }
            if (this.dht_tracker_plugin == null) {
                this.dht_add_queue.remove(download);
                return;
            }
        }
        this.init_sem.reserve();
        this.removeDownload(download);
    }

    protected void addDownload(Download download) {
        this.dht_tracker_plugin.addDownload(download);
        if (this.tttorrent != null) {
            this.tttorrent.addDownload(download);
        }
    }

    protected void removeDownload(Download download) {
        this.dht_tracker_plugin.removeDownload(download);
        if (this.tttorrent != null) {
            this.tttorrent.removeDownload(download);
        }
    }

    protected void log(String string) {
        Logger.log(new LogEvent(LogIDs.CORE, string));
    }

    protected void log(String string, Throwable throwable) {
        Logger.log(new LogEvent(LogIDs.CORE, string, throwable));
    }
}

