/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.config;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.devices.Device;
import com.aelitis.azureus.core.devices.DeviceManager;
import com.aelitis.azureus.core.devices.DeviceManagerFactory;
import com.aelitis.azureus.core.devices.DeviceManagerListener;
import com.aelitis.azureus.core.devices.DeviceMediaRenderer;
import com.aelitis.azureus.core.devices.TranscodeFile;
import com.aelitis.azureus.core.devices.TranscodeJob;
import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.devices.TranscodeTarget;
import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.config.PlatformConfigMessenger;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.torrent.Torrent;

public class PlatformDevicesMessenger {
    public static final String CFG_SEND_QOS = "devices.sendQOS";
    public static final String LISTENER_ID = "devices";
    private static final String OP_QOS_TURN_ON = "qos-turn-on";
    private static final String OP_QOS_FOUND_DEVICE = "qos-found-device";
    private static final String OP_QOS_TRANSCODE = "qos-transcode";
    private static final String OP_QOS_PLAYBACK = "qos-playback";
    private static final String OP_GET_PROFILES = "get-profiles";
    private static final String OP_REPORT_DEVICES = "report-devices";
    private static final String OP_QOS_TRANSCODE_REQUEST = "qos-transcode-request";
    private static String plugin_xcode_version = null;
    private static String plugin_itunes_version = null;

    public static void qosTurnOn(boolean bl) {
        if (!COConfigurationManager.getBooleanParameter(CFG_SEND_QOS, false)) {
            return;
        }
        PlatformMessage platformMessage = new PlatformMessage("AZMSG", LISTENER_ID, OP_QOS_TURN_ON, new Object[]{"itunes", bl, "os-name", Constants.OSName}, 5000L);
        platformMessage.setSendAZID(false);
        PlatformMessenger.queueMessage(platformMessage, null);
    }

    public static void qosFoundDevice(Device device) {
        Object object;
        if (device == null || !COConfigurationManager.getBooleanParameter(CFG_SEND_QOS, false)) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        PlatformDevicesMessenger.addPluginVersionsToMap(hashMap);
        hashMap.put("device-name", device.getName());
        hashMap.put("device-type", new Integer(device.getType()));
        if (device instanceof DeviceMediaRenderer) {
            object = (DeviceMediaRenderer)device;
            hashMap.put("renderer-species", object.getRendererSpecies());
        }
        object = new PlatformMessage("AZMSG", LISTENER_ID, OP_QOS_FOUND_DEVICE, hashMap, 5000L);
        ((PlatformMessage)object).setSendAZID(false);
        PlatformMessenger.queueMessage((PlatformMessage)object, null);
    }

    private static void addPluginVersionsToMap(Map map) {
        if (AzureusCoreFactory.isCoreRunning()) {
            PluginManager pluginManager = AzureusCoreFactory.getSingleton().getPluginManager();
            PluginInterface pluginInterface = pluginManager.getPluginInterfaceByID("vuzexcode");
            if (pluginInterface != null) {
                map.put("xcode-plugin-version", pluginInterface.getPluginVersion());
            }
            if ((pluginInterface = pluginManager.getPluginInterfaceByID("azitunes")) != null) {
                map.put("itunes-plugin-version", pluginInterface.getPluginVersion());
            }
        }
        map.put("os-name", Constants.OSName);
    }

    public static void qosTranscodeRequest(TranscodeTarget transcodeTarget, String string) {
        Object object;
        if (!COConfigurationManager.getBooleanParameter(CFG_SEND_QOS, false) || transcodeTarget == null) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        PlatformDevicesMessenger.addPluginVersionsToMap(hashMap);
        Device device = transcodeTarget.getDevice();
        if (device != null) {
            hashMap.put("device-name", device.getName());
            hashMap.put("device-type", new Integer(device.getType()));
        }
        if (transcodeTarget instanceof DeviceMediaRenderer) {
            object = (DeviceMediaRenderer)transcodeTarget;
            hashMap.put("renderer-species", object.getRendererSpecies());
        }
        hashMap.put("source-ref", string);
        object = new PlatformMessage("AZMSG", LISTENER_ID, OP_QOS_TRANSCODE_REQUEST, hashMap, 5000L);
        ((PlatformMessage)object).setSendAZID(false);
        PlatformMessenger.queueMessage((PlatformMessage)object, null);
    }

    public static void qosTranscode(TranscodeJob transcodeJob, int n) {
        Object object;
        if (!COConfigurationManager.getBooleanParameter(CFG_SEND_QOS, false) || transcodeJob == null) {
            return;
        }
        TranscodeFile transcodeFile = transcodeJob.getTranscodeFile();
        DiskManagerFileInfo diskManagerFileInfo = null;
        try {
            diskManagerFileInfo = transcodeFile.getSourceFile();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DiskManagerFileInfo diskManagerFileInfo2 = null;
        try {
            diskManagerFileInfo2 = transcodeFile.getTargetFile();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        TranscodeProfile transcodeProfile = transcodeJob.getProfile();
        TranscodeTarget transcodeTarget = transcodeJob.getTarget();
        Device device = transcodeTarget.getDevice();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        PlatformDevicesMessenger.addPluginVersionsToMap(hashMap);
        hashMap.put("job-state", n);
        if ((n & 0xFF) == 5) {
            object = transcodeJob.getError();
            if (object != null) {
                if (((String)object).endsWith("\r\n")) {
                    ((String)object).substring(0, ((String)object).length() - 2);
                } else if (((String)object).endsWith("\r") || ((String)object).endsWith("\n")) {
                    ((String)object).substring(0, ((String)object).length() - 1);
                }
            }
            hashMap.put("job-error", object);
        }
        try {
            object = transcodeJob.getFile().getDownload().getTorrent();
            if (PlatformTorrentUtils.isContent((Torrent)object, true)) {
                hashMap.put("asset-hash", new HashWrapper(object.getHash()).toBase32String());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        hashMap.put("transcode-mode", new Integer(transcodeJob.getTranscodeRequirement()));
        hashMap.put("transcode-required", new Boolean(transcodeFile.getTranscodeRequired()));
        hashMap.put("transcode-video-width", new Long(transcodeFile.getVideoWidth()));
        hashMap.put("transcode-video-height", new Long(transcodeFile.getVideoHeight()));
        hashMap.put("transcode-video-duration-ms", new Long(transcodeFile.getDurationMillis()));
        hashMap.put("process-time-ms", new Long(transcodeJob.getProcessTime()));
        hashMap.put("device-name", device.getName());
        hashMap.put("device-type", new Integer(device.getType()));
        if (transcodeProfile != null) {
            hashMap.put("profile-name", transcodeProfile.getName());
        }
        if (transcodeTarget instanceof DeviceMediaRenderer) {
            object = (DeviceMediaRenderer)transcodeTarget;
            hashMap.put("renderer-species", object.getRendererSpecies());
        }
        if (diskManagerFileInfo != null) {
            hashMap.put("source-file-ext", FileUtil.getExtension(diskManagerFileInfo.getFile().getName()));
            hashMap.put("source-file-size", new Long(diskManagerFileInfo.getLength()));
        }
        if (diskManagerFileInfo2 != null) {
            hashMap.put("target-file-ext", FileUtil.getExtension(diskManagerFileInfo2.getFile().getName()));
            hashMap.put("target-file-size", new Long(diskManagerFileInfo2.getLength()));
        }
        object = new PlatformMessage("AZMSG", LISTENER_ID, OP_QOS_TRANSCODE, hashMap, 5000L);
        ((PlatformMessage)object).setSendAZID(false);
        PlatformMessenger.queueMessage((PlatformMessage)object, null);
    }

    public static void setupDeviceSender() {
        if (!COConfigurationManager.getStringParameter("ui").equals("az2")) {
            final DeviceManager deviceManager = DeviceManagerFactory.getSingleton();
            Device[] deviceArray = deviceManager.getDevices();
            if (deviceArray == null || deviceArray.length == 0) {
                deviceManager.addListener(new DeviceManagerListener(){

                    @Override
                    public void deviceRemoved(Device device) {
                    }

                    @Override
                    public void deviceChanged(Device device) {
                    }

                    @Override
                    public void deviceAttentionRequest(Device device) {
                    }

                    @Override
                    public void deviceAdded(Device device) {
                    }

                    @Override
                    public void deviceManagerLoaded() {
                        deviceManager.removeListener(this);
                        Device[] deviceArray = deviceManager.getDevices();
                        if (deviceArray != null && deviceArray.length > 0) {
                            PlatformDevicesMessenger.sendDeviceList(deviceArray);
                        }
                    }
                });
            } else {
                PlatformDevicesMessenger.sendDeviceList(deviceArray);
            }
        }
    }

    private static void sendDeviceList(Device[] deviceArray) {
        if (!PlatformConfigMessenger.allowSendDeviceList()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(deviceArray.length);
        for (Device device : deviceArray) {
            if (device.getType() != 3) continue;
            arrayList.add(device.getClassification());
        }
        if (arrayList.size() == 0) {
            return;
        }
        PlatformMessage platformMessage = new PlatformMessage("AZMSG", LISTENER_ID, OP_REPORT_DEVICES, new Object[]{"renderers", arrayList}, 500L);
        PlatformMessenger.queueMessage(platformMessage, null);
    }
}

