/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.ByteBucket;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class ByteBucketMT
implements ByteBucket {
    private int rate;
    private int burst_rate;
    private volatile long avail_bytes;
    private volatile long prev_update_time;
    private volatile boolean frozen;

    public ByteBucketMT(int n) {
        this(n, n + n / 5);
    }

    private ByteBucketMT(int n, int n2) {
        this.rate = n;
        this.burst_rate = n2;
        this.avail_bytes = 0L;
        this.prev_update_time = SystemTime.getMonotonousTime();
        this.ensureByteBucketMinBurstRate();
    }

    @Override
    public int getAvailableByteCount() {
        int n;
        if (this.avail_bytes < 0x6400000L) {
            this.update_avail_byte_count();
        }
        if ((n = (int)this.avail_bytes) < 0) {
            n = 0;
        }
        return n;
    }

    @Override
    public void setBytesUsed(int n) {
        if (this.avail_bytes >= 0x6400000L) {
            return;
        }
        this.avail_bytes -= (long)n;
    }

    @Override
    public int getRate() {
        return this.rate;
    }

    public int getBurstRate() {
        return this.burst_rate;
    }

    @Override
    public void setRate(int n) {
        this.setRate(n, n + n / 5);
    }

    @Override
    public void setFrozen(boolean bl) {
        this.frozen = bl;
    }

    public void setRate(int n, int n2) {
        if (n < 0) {
            Debug.out("rate_bytes_per_sec [" + n + "] < 0");
            n = 0;
        }
        if (n2 < n) {
            Debug.out("burst_rate [" + n2 + "] < rate_bytes_per_sec [" + n + "]");
            n2 = n;
        }
        this.rate = n;
        this.burst_rate = n2;
        if (this.avail_bytes > (long)n2) {
            this.avail_bytes = n2;
        }
        this.ensureByteBucketMinBurstRate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update_avail_byte_count() {
        if (this.frozen) {
            return;
        }
        ByteBucketMT byteBucketMT = this;
        synchronized (byteBucketMT) {
            long l = SystemTime.getMonotonousTime();
            if (this.prev_update_time < l) {
                this.avail_bytes += (l - this.prev_update_time) * (long)this.rate / 1000L;
                this.prev_update_time = l;
                if (this.avail_bytes > (long)this.burst_rate) {
                    this.avail_bytes = this.burst_rate;
                } else if (this.avail_bytes < 0L) {
                    // empty if block
                }
            }
        }
    }

    private void ensureByteBucketMinBurstRate() {
        int n = NetworkManager.getMinMssSize();
        if (this.burst_rate < n) {
            this.burst_rate = n;
        }
    }
}

